/*
 * Decompiled with CFR 0.152.
 */
package org.lance.namespace.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"column", "slop", "terms"})
public class PhraseQuery {
    public static final String JSON_PROPERTY_COLUMN = "column";
    @Nullable
    private String column;
    public static final String JSON_PROPERTY_SLOP = "slop";
    @Nullable
    private Integer slop;
    public static final String JSON_PROPERTY_TERMS = "terms";
    @Nonnull
    private String terms;

    public PhraseQuery column(@Nullable String column) {
        this.column = column;
        return this;
    }

    @Nullable
    @JsonProperty(value="column")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getColumn() {
        return this.column;
    }

    @JsonProperty(value="column")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColumn(@Nullable String column) {
        this.column = column;
    }

    public PhraseQuery slop(@Nullable Integer slop) {
        this.slop = slop;
        return this;
    }

    @Nullable
    @JsonProperty(value="slop")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSlop() {
        return this.slop;
    }

    @JsonProperty(value="slop")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSlop(@Nullable Integer slop) {
        this.slop = slop;
    }

    public PhraseQuery terms(@Nonnull String terms) {
        this.terms = terms;
        return this;
    }

    @Nonnull
    @JsonProperty(value="terms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTerms() {
        return this.terms;
    }

    @JsonProperty(value="terms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTerms(@Nonnull String terms) {
        this.terms = terms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhraseQuery phraseQuery = (PhraseQuery)o;
        return Objects.equals(this.column, phraseQuery.column) && Objects.equals(this.slop, phraseQuery.slop) && Objects.equals(this.terms, phraseQuery.terms);
    }

    public int hashCode() {
        return Objects.hash(this.column, this.slop, this.terms);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhraseQuery {\n");
        sb.append("    column: ").append(this.toIndentedString(this.column)).append("\n");
        sb.append("    slop: ").append(this.toIndentedString(this.slop)).append("\n");
        sb.append("    terms: ").append(this.toIndentedString(this.terms)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getColumn() != null) {
            try {
                joiner.add(String.format("%scolumn%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getColumn()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSlop() != null) {
            try {
                joiner.add(String.format("%sslop%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSlop()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTerms() != null) {
            try {
                joiner.add(String.format("%sterms%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTerms()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

