/*
 * Decompiled with CFR 0.152.
 */
package org.lance.namespace.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lance.namespace.model.QueryTableRequestFullTextQuery;
import org.lance.namespace.model.QueryTableRequestVector;

@JsonPropertyOrder(value={"id", "bypass_vector_index", "columns", "distance_type", "ef", "fast_search", "filter", "full_text_query", "k", "lower_bound", "nprobes", "offset", "prefilter", "refine_factor", "upper_bound", "vector", "vector_column", "version", "with_row_id"})
public class QueryTableRequest {
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private List<String> id = new ArrayList<String>();
    public static final String JSON_PROPERTY_BYPASS_VECTOR_INDEX = "bypass_vector_index";
    @Nullable
    private Boolean bypassVectorIndex;
    public static final String JSON_PROPERTY_COLUMNS = "columns";
    @Nullable
    private List<String> columns = new ArrayList<String>();
    public static final String JSON_PROPERTY_DISTANCE_TYPE = "distance_type";
    @Nullable
    private String distanceType;
    public static final String JSON_PROPERTY_EF = "ef";
    @Nullable
    private Integer ef;
    public static final String JSON_PROPERTY_FAST_SEARCH = "fast_search";
    @Nullable
    private Boolean fastSearch;
    public static final String JSON_PROPERTY_FILTER = "filter";
    @Nullable
    private String filter;
    public static final String JSON_PROPERTY_FULL_TEXT_QUERY = "full_text_query";
    @Nullable
    private QueryTableRequestFullTextQuery fullTextQuery;
    public static final String JSON_PROPERTY_K = "k";
    @Nonnull
    private Integer k;
    public static final String JSON_PROPERTY_LOWER_BOUND = "lower_bound";
    @Nullable
    private Float lowerBound;
    public static final String JSON_PROPERTY_NPROBES = "nprobes";
    @Nullable
    private Integer nprobes;
    public static final String JSON_PROPERTY_OFFSET = "offset";
    @Nullable
    private Integer offset;
    public static final String JSON_PROPERTY_PREFILTER = "prefilter";
    @Nullable
    private Boolean prefilter;
    public static final String JSON_PROPERTY_REFINE_FACTOR = "refine_factor";
    @Nullable
    private Integer refineFactor;
    public static final String JSON_PROPERTY_UPPER_BOUND = "upper_bound";
    @Nullable
    private Float upperBound;
    public static final String JSON_PROPERTY_VECTOR = "vector";
    @Nonnull
    private QueryTableRequestVector vector;
    public static final String JSON_PROPERTY_VECTOR_COLUMN = "vector_column";
    @Nullable
    private String vectorColumn;
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private Long version;
    public static final String JSON_PROPERTY_WITH_ROW_ID = "with_row_id";
    @Nullable
    private Boolean withRowId;

    public QueryTableRequest id(@Nullable List<String> id) {
        this.id = id;
        return this;
    }

    public QueryTableRequest addIdItem(String idItem) {
        if (this.id == null) {
            this.id = new ArrayList<String>();
        }
        this.id.add(idItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable List<String> id) {
        this.id = id;
    }

    public QueryTableRequest bypassVectorIndex(@Nullable Boolean bypassVectorIndex) {
        this.bypassVectorIndex = bypassVectorIndex;
        return this;
    }

    @Nullable
    @JsonProperty(value="bypass_vector_index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getBypassVectorIndex() {
        return this.bypassVectorIndex;
    }

    @JsonProperty(value="bypass_vector_index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBypassVectorIndex(@Nullable Boolean bypassVectorIndex) {
        this.bypassVectorIndex = bypassVectorIndex;
    }

    public QueryTableRequest columns(@Nullable List<String> columns) {
        this.columns = columns;
        return this;
    }

    public QueryTableRequest addColumnsItem(String columnsItem) {
        if (this.columns == null) {
            this.columns = new ArrayList<String>();
        }
        this.columns.add(columnsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColumns(@Nullable List<String> columns) {
        this.columns = columns;
    }

    public QueryTableRequest distanceType(@Nullable String distanceType) {
        this.distanceType = distanceType;
        return this;
    }

    @Nullable
    @JsonProperty(value="distance_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDistanceType() {
        return this.distanceType;
    }

    @JsonProperty(value="distance_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDistanceType(@Nullable String distanceType) {
        this.distanceType = distanceType;
    }

    public QueryTableRequest ef(@Nullable Integer ef) {
        this.ef = ef;
        return this;
    }

    @Nullable
    @JsonProperty(value="ef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getEf() {
        return this.ef;
    }

    @JsonProperty(value="ef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEf(@Nullable Integer ef) {
        this.ef = ef;
    }

    public QueryTableRequest fastSearch(@Nullable Boolean fastSearch) {
        this.fastSearch = fastSearch;
        return this;
    }

    @Nullable
    @JsonProperty(value="fast_search")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFastSearch() {
        return this.fastSearch;
    }

    @JsonProperty(value="fast_search")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFastSearch(@Nullable Boolean fastSearch) {
        this.fastSearch = fastSearch;
    }

    public QueryTableRequest filter(@Nullable String filter) {
        this.filter = filter;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFilter() {
        return this.filter;
    }

    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilter(@Nullable String filter) {
        this.filter = filter;
    }

    public QueryTableRequest fullTextQuery(@Nullable QueryTableRequestFullTextQuery fullTextQuery) {
        this.fullTextQuery = fullTextQuery;
        return this;
    }

    @Nullable
    @JsonProperty(value="full_text_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public QueryTableRequestFullTextQuery getFullTextQuery() {
        return this.fullTextQuery;
    }

    @JsonProperty(value="full_text_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullTextQuery(@Nullable QueryTableRequestFullTextQuery fullTextQuery) {
        this.fullTextQuery = fullTextQuery;
    }

    public QueryTableRequest k(@Nonnull Integer k) {
        this.k = k;
        return this;
    }

    @Nonnull
    @JsonProperty(value="k")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getK() {
        return this.k;
    }

    @JsonProperty(value="k")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setK(@Nonnull Integer k) {
        this.k = k;
    }

    public QueryTableRequest lowerBound(@Nullable Float lowerBound) {
        this.lowerBound = lowerBound;
        return this;
    }

    @Nullable
    @JsonProperty(value="lower_bound")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getLowerBound() {
        return this.lowerBound;
    }

    @JsonProperty(value="lower_bound")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLowerBound(@Nullable Float lowerBound) {
        this.lowerBound = lowerBound;
    }

    public QueryTableRequest nprobes(@Nullable Integer nprobes) {
        this.nprobes = nprobes;
        return this;
    }

    @Nullable
    @JsonProperty(value="nprobes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNprobes() {
        return this.nprobes;
    }

    @JsonProperty(value="nprobes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNprobes(@Nullable Integer nprobes) {
        this.nprobes = nprobes;
    }

    public QueryTableRequest offset(@Nullable Integer offset) {
        this.offset = offset;
        return this;
    }

    @Nullable
    @JsonProperty(value="offset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getOffset() {
        return this.offset;
    }

    @JsonProperty(value="offset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOffset(@Nullable Integer offset) {
        this.offset = offset;
    }

    public QueryTableRequest prefilter(@Nullable Boolean prefilter) {
        this.prefilter = prefilter;
        return this;
    }

    @Nullable
    @JsonProperty(value="prefilter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPrefilter() {
        return this.prefilter;
    }

    @JsonProperty(value="prefilter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrefilter(@Nullable Boolean prefilter) {
        this.prefilter = prefilter;
    }

    public QueryTableRequest refineFactor(@Nullable Integer refineFactor) {
        this.refineFactor = refineFactor;
        return this;
    }

    @Nullable
    @JsonProperty(value="refine_factor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRefineFactor() {
        return this.refineFactor;
    }

    @JsonProperty(value="refine_factor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefineFactor(@Nullable Integer refineFactor) {
        this.refineFactor = refineFactor;
    }

    public QueryTableRequest upperBound(@Nullable Float upperBound) {
        this.upperBound = upperBound;
        return this;
    }

    @Nullable
    @JsonProperty(value="upper_bound")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getUpperBound() {
        return this.upperBound;
    }

    @JsonProperty(value="upper_bound")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpperBound(@Nullable Float upperBound) {
        this.upperBound = upperBound;
    }

    public QueryTableRequest vector(@Nonnull QueryTableRequestVector vector) {
        this.vector = vector;
        return this;
    }

    @Nonnull
    @JsonProperty(value="vector")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QueryTableRequestVector getVector() {
        return this.vector;
    }

    @JsonProperty(value="vector")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVector(@Nonnull QueryTableRequestVector vector) {
        this.vector = vector;
    }

    public QueryTableRequest vectorColumn(@Nullable String vectorColumn) {
        this.vectorColumn = vectorColumn;
        return this;
    }

    @Nullable
    @JsonProperty(value="vector_column")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVectorColumn() {
        return this.vectorColumn;
    }

    @JsonProperty(value="vector_column")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVectorColumn(@Nullable String vectorColumn) {
        this.vectorColumn = vectorColumn;
    }

    public QueryTableRequest version(@Nullable Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable Long version) {
        this.version = version;
    }

    public QueryTableRequest withRowId(@Nullable Boolean withRowId) {
        this.withRowId = withRowId;
        return this;
    }

    @Nullable
    @JsonProperty(value="with_row_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getWithRowId() {
        return this.withRowId;
    }

    @JsonProperty(value="with_row_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWithRowId(@Nullable Boolean withRowId) {
        this.withRowId = withRowId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryTableRequest queryTableRequest = (QueryTableRequest)o;
        return Objects.equals(this.id, queryTableRequest.id) && Objects.equals(this.bypassVectorIndex, queryTableRequest.bypassVectorIndex) && Objects.equals(this.columns, queryTableRequest.columns) && Objects.equals(this.distanceType, queryTableRequest.distanceType) && Objects.equals(this.ef, queryTableRequest.ef) && Objects.equals(this.fastSearch, queryTableRequest.fastSearch) && Objects.equals(this.filter, queryTableRequest.filter) && Objects.equals(this.fullTextQuery, queryTableRequest.fullTextQuery) && Objects.equals(this.k, queryTableRequest.k) && Objects.equals(this.lowerBound, queryTableRequest.lowerBound) && Objects.equals(this.nprobes, queryTableRequest.nprobes) && Objects.equals(this.offset, queryTableRequest.offset) && Objects.equals(this.prefilter, queryTableRequest.prefilter) && Objects.equals(this.refineFactor, queryTableRequest.refineFactor) && Objects.equals(this.upperBound, queryTableRequest.upperBound) && Objects.equals(this.vector, queryTableRequest.vector) && Objects.equals(this.vectorColumn, queryTableRequest.vectorColumn) && Objects.equals(this.version, queryTableRequest.version) && Objects.equals(this.withRowId, queryTableRequest.withRowId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.bypassVectorIndex, this.columns, this.distanceType, this.ef, this.fastSearch, this.filter, this.fullTextQuery, this.k, this.lowerBound, this.nprobes, this.offset, this.prefilter, this.refineFactor, this.upperBound, this.vector, this.vectorColumn, this.version, this.withRowId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryTableRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    bypassVectorIndex: ").append(this.toIndentedString(this.bypassVectorIndex)).append("\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    distanceType: ").append(this.toIndentedString(this.distanceType)).append("\n");
        sb.append("    ef: ").append(this.toIndentedString(this.ef)).append("\n");
        sb.append("    fastSearch: ").append(this.toIndentedString(this.fastSearch)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    fullTextQuery: ").append(this.toIndentedString(this.fullTextQuery)).append("\n");
        sb.append("    k: ").append(this.toIndentedString(this.k)).append("\n");
        sb.append("    lowerBound: ").append(this.toIndentedString(this.lowerBound)).append("\n");
        sb.append("    nprobes: ").append(this.toIndentedString(this.nprobes)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("    prefilter: ").append(this.toIndentedString(this.prefilter)).append("\n");
        sb.append("    refineFactor: ").append(this.toIndentedString(this.refineFactor)).append("\n");
        sb.append("    upperBound: ").append(this.toIndentedString(this.upperBound)).append("\n");
        sb.append("    vector: ").append(this.toIndentedString(this.vector)).append("\n");
        sb.append("    vectorColumn: ").append(this.toIndentedString(this.vectorColumn)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    withRowId: ").append(this.toIndentedString(this.withRowId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            for (i = 0; i < this.getId().size(); ++i) {
                try {
                    joiner.add(String.format("%sid%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getId().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getBypassVectorIndex() != null) {
            try {
                joiner.add(String.format("%sbypass_vector_index%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getBypassVectorIndex()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getColumns() != null) {
            for (i = 0; i < this.getColumns().size(); ++i) {
                try {
                    joiner.add(String.format("%scolumns%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getColumns().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getDistanceType() != null) {
            try {
                joiner.add(String.format("%sdistance_type%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDistanceType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEf() != null) {
            try {
                joiner.add(String.format("%sef%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEf()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFastSearch() != null) {
            try {
                joiner.add(String.format("%sfast_search%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFastSearch()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFilter() != null) {
            try {
                joiner.add(String.format("%sfilter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFilter()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFullTextQuery() != null) {
            joiner.add(this.getFullTextQuery().toUrlQueryString(prefix + JSON_PROPERTY_FULL_TEXT_QUERY + suffix));
        }
        if (this.getK() != null) {
            try {
                joiner.add(String.format("%sk%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getK()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getLowerBound() != null) {
            try {
                joiner.add(String.format("%slower_bound%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLowerBound()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getNprobes() != null) {
            try {
                joiner.add(String.format("%snprobes%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNprobes()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getOffset() != null) {
            try {
                joiner.add(String.format("%soffset%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getOffset()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPrefilter() != null) {
            try {
                joiner.add(String.format("%sprefilter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPrefilter()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getRefineFactor() != null) {
            try {
                joiner.add(String.format("%srefine_factor%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRefineFactor()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getUpperBound() != null) {
            try {
                joiner.add(String.format("%supper_bound%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUpperBound()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getVector() != null) {
            joiner.add(this.getVector().toUrlQueryString(prefix + JSON_PROPERTY_VECTOR + suffix));
        }
        if (this.getVectorColumn() != null) {
            try {
                joiner.add(String.format("%svector_column%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getVectorColumn()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getVersion() != null) {
            try {
                joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getVersion()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getWithRowId() != null) {
            try {
                joiner.add(String.format("%swith_row_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getWithRowId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

