/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.servicecontainer.handler.protobufrpc.servlet;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.go.nict.langrid.commons.io.StreamUtil;
import jp.go.nict.langrid.commons.lang.ClassResource;
import jp.go.nict.langrid.commons.lang.ClassResourceLoader;
import jp.go.nict.langrid.commons.net.URLUtil;
import jp.go.nict.langrid.commons.rpc.intf.Description;
import jp.go.nict.langrid.commons.rpc.intf.Parameter;
import jp.go.nict.langrid.commons.rpc.intf.Service;
import jp.go.nict.langrid.commons.transformer.UTF8ByteArrayToStringTransformer;
import jp.go.nict.langrid.commons.util.Pair;
import jp.go.nict.langrid.commons.ws.ServiceContext;
import jp.go.nict.langrid.commons.ws.ServletServiceContext;
import jp.go.nict.langrid.commons.ws.param.ServletConfigParameterContext;
import jp.go.nict.langrid.servicecontainer.executor.StreamingNotifier;
import jp.go.nict.langrid.servicecontainer.handler.ServiceFactory;
import jp.go.nict.langrid.servicecontainer.handler.ServiceLoader;
import jp.go.nict.langrid.servicecontainer.handler.annotation.ServicesUtil;
import jp.go.nict.langrid.servicecontainer.handler.loader.ServiceFactoryLoader;
import jp.go.nict.langrid.servicecontainer.handler.protobufrpc.ProtoBufDynamicHandler;
import jp.go.nict.langrid.servicecontainer.handler.protobufrpc.ProtoBufHandler;
import jp.go.nict.langrid.servicecontainer.service.composite.AbstractCompositeService;
import jp.go.nict.langrid.servicecontainer.service.composite.Invocation;

public class ProtoBufRpcServlet
extends HttpServlet {
    @ClassResource(path="css.txt", converter=UTF8ByteArrayToStringTransformer.class)
    private String css;
    private ServiceFactoryLoader[] defaultLoaders;
    private static Map<String, ProtoBufHandler> handlers = new HashMap<String, ProtoBufHandler>();
    private static Logger logger = Logger.getLogger(ProtoBufRpcServlet.class.getName());

    public void init() throws ServletException {
        super.init();
        ServletConfigParameterContext ct = new ServletConfigParameterContext(this.getServletConfig(), true);
        String mapping = ct.getString("mapping", "");
        for (String s : mapping.split(",")) {
            String[] v = s.split(":");
            if (v.length != 2) continue;
            String name = v[0].trim();
            String clazz = v[1].trim();
            String failMsg = "failed to load handler: [" + name + ":" + clazz + "].";
            try {
                handlers.put(name, (ProtoBufHandler)Class.forName(clazz).newInstance());
            }
            catch (InstantiationException e) {
                logger.log(Level.WARNING, failMsg, e);
            }
            catch (IllegalAccessException e) {
                logger.log(Level.WARNING, failMsg, e);
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.WARNING, failMsg, e);
            }
            catch (ClassCastException e) {
                logger.log(Level.WARNING, failMsg, e);
            }
        }
        try {
            ClassResourceLoader.load((Object)((Object)this));
        }
        catch (IllegalArgumentException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
        this.defaultLoaders = ServicesUtil.getServiceFactoryLoaders(((Object)((Object)this)).getClass());
    }

    protected ServiceFactoryLoader[] getDefaultServiceFactoryLoaders() {
        return this.defaultLoaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletServiceContext sc = new ServletServiceContext(req);
        ServiceLoader loader = new ServiceLoader((ServiceContext)sc, this.getDefaultServiceFactoryLoaders());
        PrintWriter w = resp.getWriter();
        resp.setContentType("text/html");
        resp.setCharacterEncoding("UTF-8");
        w.println("<html><head>");
        w.println(this.css);
        w.println("</head><body>");
        w.println("<h2>And now... Some ProtobufRpc Services</h2>");
        w.println("<ul>");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        TreeSet<String> names = new TreeSet<String>();
        for (String s : loader.listServiceNames()) {
            names.add(s);
        }
        for (String s : names) {
            Object desc22;
            Service sa;
            ServiceFactory f = loader.loadServiceFactory(cl, s);
            Object service = f.getService();
            if (service instanceof StreamingNotifier) {
                s = s + "(Streaming ready!)";
            }
            if ((sa = service.getClass().getAnnotation(Service.class)) != null && ((Description[])(desc22 = sa.descriptions())).length > 0) {
                s = s + " - " + desc22[0].value();
            }
            w.print("<li><b>" + s + "</b><ul>");
            w.print("<li>interfaces<ul>");
            try {
                desc22 = f.getInterfaces().iterator();
                while (desc22.hasNext()) {
                    Class clazz = (Class)desc22.next();
                    if (StreamingNotifier.class.isAssignableFrom(clazz)) continue;
                    w.print("<li>" + ProtoBufRpcServlet.prettyName(clazz) + "<ul>");
                    try {
                        TreeSet<Method> methods = new TreeSet<Method>(new Comparator<Method>(){

                            @Override
                            public int compare(Method o1, Method o2) {
                                return o1.getName().compareTo(o2.getName());
                            }
                        });
                        methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
                        for (Method m : methods) {
                            if (m.isSynthetic() || (m.getModifiers() & 1) == 0) continue;
                            w.print("<li>" + ProtoBufRpcServlet.prettyName(m.getReturnType()) + " <b>" + m.getName() + "</b>(");
                            boolean first = true;
                            Annotation[][] annotss = m.getParameterAnnotations();
                            int i = 0;
                            for (Class<?> pc : m.getParameterTypes()) {
                                if (first) {
                                    first = false;
                                } else {
                                    w.print(", ");
                                }
                                w.print(ProtoBufRpcServlet.prettyName(pc));
                                for (Annotation annot : annotss[i]) {
                                    if (!(annot instanceof Parameter)) continue;
                                    w.print(" ");
                                    w.print(((Parameter)annot).name());
                                    break;
                                }
                                ++i;
                            }
                            w.println(")</li>");
                        }
                    }
                    finally {
                        w.println("</ul></li>");
                    }
                }
            }
            catch (SecurityException desc22) {
            }
            finally {
                w.println("</ul></li>");
            }
            w.print("<li>implementation<ul>");
            w.println("<li>" + ProtoBufRpcServlet.prettyName(service.getClass()) + "</li></ul></li>");
            if (service instanceof AbstractCompositeService) {
                boolean first = true;
                for (Pair v : ((AbstractCompositeService)service).invocations()) {
                    if (first) {
                        w.println("<li>invocations<ul>");
                        first = false;
                    }
                    w.println("<li><b>" + ((Invocation)v.getFirst()).name() + (((Invocation)v.getFirst()).required() ? "(required)" : "") + "</b>: " + ProtoBufRpcServlet.prettyName((Class)v.getSecond()) + "</li>");
                }
                if (!first) {
                    w.println("</ul></li>");
                }
            }
            w.println("</ul></li>");
            w.println("<br/>");
        }
        w.println("</ul>");
        w.println("</body></html>");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String sn;
        Object is = req.getInputStream();
        String contentEncoding = req.getHeader("Content-Encoding");
        if (contentEncoding != null) {
            if (contentEncoding.equals("deflate")) {
                is = new InflaterInputStream((InputStream)is);
            } else if (contentEncoding.equals("gzip")) {
                is = new GZIPInputStream((InputStream)is);
            }
        }
        CodedInputStream cis = CodedInputStream.newInstance((InputStream)is);
        CodedOutputStream cos = CodedOutputStream.newInstance((OutputStream)resp.getOutputStream());
        String fullName = cis.readString();
        String uri = req.getRequestURL().toString();
        String serviceName = uri.substring(uri.lastIndexOf(47) + 1);
        String queryStr = req.getQueryString();
        if (queryStr != null) {
            try {
                Map params = URLUtil.getQueryParameters((URL)new URL(uri + "?" + queryStr));
                sn = (String)params.get("serviceName");
                if (sn != null) {
                    serviceName = sn;
                }
            }
            catch (MalformedURLException params) {
                // empty catch block
            }
        }
        String[] names = fullName.split("\\.");
        sn = names[0];
        String mn = names[names.length - 1];
        ProtoBufHandler h = handlers.get(sn.toLowerCase());
        if (h == null) {
            h = new ProtoBufDynamicHandler();
        }
        try {
            h.handle(this.getDefaultServiceFactoryLoaders(), serviceName, mn, req, resp, cis, cos);
            cos.flush();
        }
        catch (FileNotFoundException e) {
            resp.setStatus(404);
            StreamUtil.writeString((OutputStream)resp.getOutputStream(), (String)("Service \"" + serviceName + "\" Not Found."), (String)"UTF-8");
        }
    }

    private static String prettyName(Class<?> clazz) {
        StringBuilder postfix = new StringBuilder();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ProtoBufRpcServlet.appendGenericsInfo(clazz, postfix);
            postfix.append("[]");
        } else {
            ProtoBufRpcServlet.appendGenericsInfo(clazz, postfix);
        }
        String n = clazz.getName();
        String sn = clazz.getSimpleName();
        return "<span class=\"info\">" + sn + postfix + "<span>" + n + postfix + "</span></span>";
    }

    private static void appendGenericsInfo(Class<?> clazz, StringBuilder b) {
        for (TypeVariable<Class<?>> v : clazz.getTypeParameters()) {
            if (b.length() == 0) {
                b.append("&lt;");
            } else {
                b.append(",");
            }
            b.append(v.getName());
        }
        if (b.length() != 0) {
            b.append("&gt;");
        }
    }

    public static void registerHandler(String serviceName, ProtoBufHandler handler) {
        handlers.put(serviceName, handler);
    }
}

