/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhiteSpaceAtBeginOfParagraph;
import org.languagetool.rules.WhiteSpaceBeforeParagraphEnd;
import org.languagetool.rules.crh.MorfologikCrimeanTatarSpellerRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.crh.CrimeanTatarSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.crh.CrimeanTatarTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.WordTokenizer;
import org.languagetool.tokenizers.crh.CrimeanTatarWordTokenizer;

public class CrimeanTatar
extends Language {
    private SentenceTokenizer sentenceTokenizer;
    private WordTokenizer wordTokenizer;
    private CrimeanTatarTagger tagger;

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public String getName() {
        return "Crimean Tatar";
    }

    public String getShortCode() {
        return "crh";
    }

    public String[] getCountries() {
        return new String[]{"UA"};
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new CrimeanTatarTagger();
        }
        return this.tagger;
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return CrimeanTatarSynthesizer.INSTANCE;
    }

    public WordTokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new CrimeanTatarWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Andriy Rysin")};
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language languagees, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"\u00d6z\u00fc bir \u00e7aqr\u0131m uzaqta<marker> ,</marker> demiryol ke\u00e7idi yan\u0131nda ya\u015fay."), Example.fixed((String)"\u00d6z\u00fc bir \u00e7aqr\u0131m uzaqta<marker>,</marker> demiryol ke\u00e7idi yan\u0131nda ya\u015fay.")), new DoublePunctuationRule(messages), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"Meclis Haberleri 10.09.2003. <marker>q\u0131r\u0131mtatar</marker> Milliy Meclisini\u00f1 120-c\u0131 topla\u015fuv\u0131 ol\u0131p ke\u00e7ti"), Example.fixed((String)"Meclis Haberleri 10.09.2003. <marker>Q\u0131r\u0131mtatar</marker> Milliy Meclisini\u00f1 120-c\u0131 topla\u015fuv\u0131 ol\u0131p ke\u00e7ti")), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new WhiteSpaceBeforeParagraphEnd(messages, (Language)this), new WhiteSpaceAtBeginOfParagraph(messages), new MorfologikCrimeanTatarSpellerRule(messages, this, userConfig, altLanguages)});
    }
}

