/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import gnu.trove.THashSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.patterns.StringMatcher;

final class CaseRuleExceptions {
    private static final Set<String> exceptions = CaseRuleExceptions.loadExceptions("/de/eigennamen_gross.txt", "/de/case_rule_exceptions.txt");

    private CaseRuleExceptions() {
    }

    public static Set<String> getExceptions() {
        return exceptions;
    }

    public static Set<StringMatcher[]> getExceptionPatterns() {
        THashSet exceptionPatterns = new THashSet(250);
        for (String phrase : exceptions) {
            String[] parts = StringUtils.split((String)phrase, (char)' ');
            StringMatcher[] patterns = new StringMatcher[parts.length];
            for (int j = 0; j < parts.length; ++j) {
                patterns[j] = StringMatcher.regexp((String)parts[j]);
            }
            exceptionPatterns.add((Object)patterns);
        }
        exceptionPatterns.trimToSize();
        return Collections.unmodifiableSet(exceptionPatterns);
    }

    private static Set<String> loadExceptions(String ... paths) {
        HashSet<String> result = new HashSet<String>();
        for (String path : paths) {
            List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
            for (String line : lines) {
                if (line.isEmpty() || line.startsWith("#")) continue;
                if (Character.isWhitespace(line.charAt(0)) || Character.isWhitespace(line.charAt(line.length() - 1))) {
                    throw new IllegalArgumentException("Invalid line in " + path + ", starts or ends with whitespace: '" + line + "'");
                }
                result.add(line);
            }
        }
        return Collections.unmodifiableSet(result);
    }
}

