/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.AgreementRule;
import org.languagetool.rules.de.AgreementTools;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public class AgreementRule2
extends Rule {
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"Gelegentlich|Antizyklisch|Unbedingt|Zus\u00e4tzlich|Nat\u00fcrlich|\u00c4u\u00dferlich|Erfolgreich|Sp\u00e4t|L\u00e4nger|Vorrangig|Rechtzeitig|Typisch|Allw\u00f6chentlich|W\u00f6chentlich|Inhaltlich|Tagt\u00e4glich|T\u00e4glich|Komplett|Genau|Gerade|Bewusst|Vereinzelt|G\u00e4nzlich|St\u00e4ndig|Okay|Meist|Generell|Ausreichend|Gen\u00fcgend|Reichlich|Regelm\u00e4\u00dfig(e|es)?|Unregelm\u00e4\u00dfig|Haupts\u00e4chlich"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.csRegex((String)"\u00dcberraschend"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*"), PatternRuleBuilderHelper.posRegex((String)"VER:.*")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"Nachhaltig"), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:.*"), PatternRuleBuilderHelper.pos((String)"VER:INF:SFT")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"\\d0er"), PatternRuleBuilderHelper.regex((String)"Jahren?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Schw\u00e4bisch"), PatternRuleBuilderHelper.token((String)"Hall")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"echt|absolut|voll|total"), PatternRuleBuilderHelper.regex((String)"Wahnsinn|Klasse")), Arrays.asList(PatternRuleBuilderHelper.pos((String)"SENT_START"), PatternRuleBuilderHelper.pos((String)"ADJ:PRD:GRU"), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:SIN:NEU:INF")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"voll|voller"), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:SIN:.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"einzig"), PatternRuleBuilderHelper.posRegex((String)"SUB:NOM:.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Intelligent"), PatternRuleBuilderHelper.token((String)"Design")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Alternativ"), PatternRuleBuilderHelper.token((String)"Berufserfahrung")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Maritim"), PatternRuleBuilderHelper.token((String)"Hotel")), Arrays.asList(PatternRuleBuilderHelper.csToken((String)"Russisch"), PatternRuleBuilderHelper.csToken((String)"Brot")), Arrays.asList(PatternRuleBuilderHelper.token((String)"ruhig"), PatternRuleBuilderHelper.csToken((String)"Blut")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Blind"), PatternRuleBuilderHelper.regex((String)"Dates?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Fair"), PatternRuleBuilderHelper.token((String)"Trade")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Frei"), PatternRuleBuilderHelper.token((String)"Haus")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Global"), PatternRuleBuilderHelper.token((String)"Player")), Arrays.asList(PatternRuleBuilderHelper.token((String)"psychisch"), PatternRuleBuilderHelper.regex((String)"Kranken?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"sportlich"), PatternRuleBuilderHelper.regex((String)"Aktiven?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"politisch"), PatternRuleBuilderHelper.regex((String)"Interessierten?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"voraussichtlich"), PatternRuleBuilderHelper.regex((String)"Ende|Anfang")), Arrays.asList(PatternRuleBuilderHelper.regex((String)"gesetzlich|privat|freiwillig"), PatternRuleBuilderHelper.regex((String)"(Kranken)?Versicherten?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"typisch"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*"), PatternRuleBuilderHelper.regex((String)"[!?.]")), Arrays.asList(PatternRuleBuilderHelper.token((String)"lecker"), PatternRuleBuilderHelper.token((String)"Essen")), Arrays.asList(PatternRuleBuilderHelper.token((String)"erneut"), PatternRuleBuilderHelper.posRegex((String)"SUB:.*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Gesetzlich"), PatternRuleBuilderHelper.regex((String)"Krankenversicherten?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"weitgehend"), PatternRuleBuilderHelper.token((String)"Einigkeit")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Ernst")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Anders")), Arrays.asList(PatternRuleBuilderHelper.token((String)"wirklich")), Arrays.asList(PatternRuleBuilderHelper.token((String)"gemeinsam")), Arrays.asList(PatternRuleBuilderHelper.token((String)"wenig")), Arrays.asList(PatternRuleBuilderHelper.token((String)"weniger")), Arrays.asList(PatternRuleBuilderHelper.token((String)"unaufgefordert")), Arrays.asList(PatternRuleBuilderHelper.token((String)"richtig")), Arrays.asList(PatternRuleBuilderHelper.token((String)"wei\u00df")), Arrays.asList(PatternRuleBuilderHelper.token((String)"speziell")), Arrays.asList(PatternRuleBuilderHelper.token((String)"halb")), Arrays.asList(PatternRuleBuilderHelper.token((String)"hinter")), Arrays.asList(PatternRuleBuilderHelper.token((String)"vermutlich")), Arrays.asList(PatternRuleBuilderHelper.token((String)"eventuell")), Arrays.asList(PatternRuleBuilderHelper.token((String)"ausschlie\u00dflich")), Arrays.asList(PatternRuleBuilderHelper.token((String)"ausschliesslich")), Arrays.asList(PatternRuleBuilderHelper.token((String)"blo\u00df")), Arrays.asList(PatternRuleBuilderHelper.token((String)"einfach")), Arrays.asList(PatternRuleBuilderHelper.token((String)"egal")), Arrays.asList(PatternRuleBuilderHelper.token((String)"endlich")), Arrays.asList(PatternRuleBuilderHelper.token((String)"unbemerkt")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Typisch"), PatternRuleBuilderHelper.tokenRegex((String)"Mann|Frau")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Ausreichend"), PatternRuleBuilderHelper.tokenRegex((String)"Bewegung")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Genau"), PatternRuleBuilderHelper.token((String)"Null")), Arrays.asList(PatternRuleBuilderHelper.token((String)"wohl")), Arrays.asList(PatternRuleBuilderHelper.token((String)"erst")), Arrays.asList(PatternRuleBuilderHelper.token((String)"lieber")), Arrays.asList(PatternRuleBuilderHelper.token((String)"besser")), Arrays.asList(PatternRuleBuilderHelper.token((String)"laut")), Arrays.asList(PatternRuleBuilderHelper.token((String)"research")), Arrays.asList(PatternRuleBuilderHelper.token((String)"researchs")), Arrays.asList(PatternRuleBuilderHelper.token((String)"security")), Arrays.asList(PatternRuleBuilderHelper.token((String)"business")), Arrays.asList(PatternRuleBuilderHelper.token((String)"voll"), PatternRuleBuilderHelper.token((String)"Sorge")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Total"), PatternRuleBuilderHelper.tokenRegex((String)"Tankstellen?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Ganz"), PatternRuleBuilderHelper.token((String)"Gentleman")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Kurz"), PatternRuleBuilderHelper.token((String)"Zeit"), PatternRuleBuilderHelper.tokenRegex((String)"f\u00fcr|um")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Golden"), PatternRuleBuilderHelper.token((String)"Gate")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Wirtschaftlich"), PatternRuleBuilderHelper.tokenRegex((String)"Berechtigte[rn]?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Russisch"), PatternRuleBuilderHelper.token((String)"Roulette")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Clever"), PatternRuleBuilderHelper.tokenRegex((String)"Shuttles?")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Personal"), PatternRuleBuilderHelper.tokenRegex((String)"(Computer|Coach|Trainer|Brand).*")), Arrays.asList(PatternRuleBuilderHelper.tokenRegex((String)"Digital|Fair|Regional|Global|Bilingual|International|National|Visual|Final|Rapid|Dual|Golden|Human"), PatternRuleBuilderHelper.tokenRegex((String)"(Initiative|Office|Connection|Bootcamp|Leadership|Sales|Community|Service|Management|Board|Identity|City|Paper|Transfer|Transformation|Power|Shopping|Brand|Master|Gate|Drive|Learning|Publishing|Signage|Value|Entertainment|Museum|Register|Society|Union|Institute|Symposium|Style|Design).*")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Smart")), Arrays.asList(PatternRuleBuilderHelper.token((String)"International"), PatternRuleBuilderHelper.tokenRegex((String)"Society|Olympic|Space")), Arrays.asList(PatternRuleBuilderHelper.token((String)"GmbH")));
    private final Supplier<List<DisambiguationPatternRule>> antiPatterns;

    public AgreementRule2(ResourceBundle messages, Language language) {
        super.setCategory(Categories.GRAMMAR.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"<marker>Kleiner Haus</marker> am Waldrand"), Example.fixed((String)"<marker>Kleines Haus</marker> am Waldrand"));
        this.antiPatterns = AgreementRule2.cacheAntiPatterns((Language)language, ANTI_PATTERNS);
    }

    public String getId() {
        return "DE_AGREEMENT2";
    }

    public String getDescription() {
        return "Kongruenz von Adjektiv und Nomen (unvollst\u00e4ndig!), z.B. 'kleiner (kleines) Haus'";
    }

    public int estimateContextForSureMatch() {
        return ANTI_PATTERNS.stream().mapToInt(List::size).max().orElse(0);
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns.get();
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        for (int i = 0; i < tokens.length; ++i) {
            AnalyzedTokenReadings nextToken;
            String token = tokens[i].getToken();
            if (tokens[i].isSentenceStart() || StringUtils.equalsAny((CharSequence)token, (CharSequence[])new CharSequence[]{"\"", "\u201e", "\u00bb", "\u00ab"})) continue;
            if (i + 1 >= tokens.length || !tokens[i].hasPosTagStartingWith("ADJ") || !tokens[i + 1].hasPosTagStartingWith("SUB") || tokens[i + 1].hasPosTagStartingWith("EIG")) break;
            if (tokens[i].isImmunized() || tokens[i + 1].isImmunized() || tokens[i].getToken().equalsIgnoreCase("unter")) continue;
            AnalyzedTokenReadings analyzedTokenReadings = nextToken = i + 2 < tokens.length ? tokens[i + 2] : null;
            if (nextToken != null && nextToken.hasPosTagStartingWith("SUB")) break;
            RuleMatch ruleMatch = this.checkAdjNounAgreement(tokens[i], tokens[i + 1], sentence);
            if (ruleMatch == null) continue;
            ruleMatches.add(ruleMatch);
            break;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private RuleMatch checkAdjNounAgreement(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedSentence sentence) {
        Set<String> set = this.retainCommonCategories(token1, token2);
        RuleMatch ruleMatch = null;
        if (set.isEmpty()) {
            String msg = "M\u00f6glicherweise fehlende grammatikalische \u00dcbereinstimmung zwischen Adjektiv und Nomen bez\u00fcglich Kasus, Numerus oder Genus. Beispiel: 'kleiner Haus' statt 'kleines Haus'";
            String shortMsg = "M\u00f6glicherweise keine \u00dcbereinstimmung bez\u00fcglich Kasus, Numerus oder Genus";
            ruleMatch = new RuleMatch((Rule)this, sentence, token1.getStartPos(), token2.getEndPos(), msg, shortMsg);
        }
        return ruleMatch;
    }

    @NotNull
    private Set<String> retainCommonCategories(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2) {
        Set<AgreementRule.GrammarCategory> categoryToRelaxSet = Collections.emptySet();
        Set<String> set1 = AgreementTools.getAgreementCategories(token1, categoryToRelaxSet, false);
        Set<String> set2 = AgreementTools.getAgreementCategories(token2, categoryToRelaxSet, false);
        set1.retainAll(set2);
        return set1;
    }
}

