/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractStatisticSentenceStyleRule;

public class SentenceWithManRule
extends AbstractStatisticSentenceStyleRule {
    private static final int DEFAULT_MIN_PERCENT = 15;
    String sentenceMessage = null;

    public SentenceWithManRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        super(messages, lang, userConfig, 15);
    }

    private static boolean isWordMan(AnalyzedTokenReadings token) {
        return token.hasLemma("man");
    }

    protected AnalyzedTokenReadings conditionFulfilled(List<AnalyzedTokenReadings> sentence) {
        for (int i = 0; i < sentence.size(); ++i) {
            if (!SentenceWithManRule.isWordMan(sentence.get(i))) continue;
            return sentence.get(i);
        }
        return null;
    }

    protected boolean excludeDirectSpeech() {
        return true;
    }

    public double denominator() {
        return 1000.0;
    }

    protected String getLimitMessage(int limit, double percent) {
        if (limit == 0) {
            return "S\u00e4tze mit der indirekten Leseransprache 'man' sind stilistisch wenig elegant formuliert. L\u00e4sst sich das Wort vermeiden?";
        }
        return "Mehr als " + limit + "\u2030 S\u00e4tze mit der indirekten Leseransprache 'man' {" + (int)(percent + 0.5) + "\u2030} gefunden. L\u00e4sst sich das Wort vermeiden?";
    }

    public String getId() {
        return "SENTENCE_WITH_MAN_DE";
    }

    public String getDescription() {
        return "Statistische Stilanalyse: S\u00e4tze mit indirekter Leseransprache 'man'";
    }

    public String getConfigureText() {
        return "Anzeigen wenn mehr als ...\u2030 S\u00e4tze eines Kapitels 'man' enthalten:";
    }
}

