/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.GenericUnpairedQuotesRule;
import org.languagetool.tools.Tools;

public class GermanUnpairedQuotesRule
extends GenericUnpairedQuotesRule {
    private static final List<String> DE_START_SYMBOLS = Arrays.asList("\u201e", "\u00bb", "\u00ab", "\"", "'", "\u201a", "\u203a", "\u2039");
    private static final List<String> DE_END_SYMBOLS = Arrays.asList("\u201c", "\u00ab", "\u00bb", "\"", "'", "\u2018", "\u2039", "\u203a");

    public GermanUnpairedQuotesRule(ResourceBundle messages, Language language) {
        super(messages, DE_START_SYMBOLS, DE_END_SYMBOLS);
        this.setUrl(Tools.getUrl((String)"https://languagetool.org/insights/de/beitrag/klammern/"));
        this.addExamplePair(Example.wrong((String)"\u00bbHallo Hans ist das dein <marker>\u203a</marker>neues Auto?\u00ab, fragte er."), Example.fixed((String)"\u00bbHallo Hans ist das dein <marker>\u203a</marker>neues\u2039 Auto?\u00ab, fragte er."));
    }

    public String getId() {
        return "DE_UNPAIRED_QUOTES";
    }
}

