/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordRepeatRule;

public class EnglishWordRepeatRule
extends WordRepeatRule {
    public EnglishWordRepeatRule(ResourceBundle messages, Language language) {
        super(messages, language);
        this.addExamplePair(Example.wrong((String)"This <marker>is is</marker> just an example sentence."), Example.fixed((String)"This <marker>is</marker> just an example sentence."));
    }

    public String getId() {
        return "ENGLISH_WORD_REPEAT_RULE";
    }

    public boolean ignore(AnalyzedTokenReadings[] tokens, int position) {
        if (position == 0) {
            return false;
        }
        String word = tokens[position].getToken();
        if ((this.repetitionOf("did", tokens, position) || this.repetitionOf("do", tokens, position) || this.repetitionOf("does", tokens, position)) && position + 1 < tokens.length && tokens[position + 1].getToken().equalsIgnoreCase("n't")) {
            return true;
        }
        if (this.repetitionOf("had", tokens, position) && this.posIsIn(tokens, position - 2, "PRP", "NN")) {
            return true;
        }
        if (this.repetitionOf("that", tokens, position) && this.posIsIn(tokens, position + 1, "MD", "NN", "PRP$", "JJ", "VBZ", "VBD")) {
            return true;
        }
        if (this.repetitionOf("can", tokens, position) && this.posIsIn(tokens, position - 1, "NN")) {
            return true;
        }
        if (this.repetitionOf("hip", tokens, position) && position + 1 < tokens.length && tokens[position + 1].getToken().equalsIgnoreCase("hooray")) {
            return true;
        }
        if (this.repetitionOf("bam", tokens, position) && position + 1 < tokens.length && tokens[position + 1].getToken().equalsIgnoreCase("bigelow")) {
            return true;
        }
        if (this.repetitionOf("wild", tokens, position) && position + 1 < tokens.length && tokens[position + 1].getToken().equalsIgnoreCase("west")) {
            return true;
        }
        if (this.repetitionOf("far", tokens, position) && position + 1 < tokens.length && tokens[position + 1].getToken().equalsIgnoreCase("away")) {
            return true;
        }
        if (this.repetitionOf("so", tokens, position) && position + 1 < tokens.length && tokens[position + 1].getToken().equalsIgnoreCase("much")) {
            return true;
        }
        if (this.repetitionOf("so", tokens, position) && position + 1 < tokens.length && tokens[position + 1].getToken().equalsIgnoreCase("many")) {
            return true;
        }
        if (this.repetitionOf("s", tokens, position) && position > 1 && tokens[position - 2].getToken().matches("['\u2019`\u00b4\u2018]")) {
            return true;
        }
        if (this.repetitionOf("a", tokens, position) && position > 1 && tokens[position - 2].getToken().equals(".")) {
            return true;
        }
        if (this.repetitionOf("on", tokens, position) && position > 1 && tokens[position - 2].getToken().equals(".")) {
            return true;
        }
        if (tokens[position - 1].getToken().equalsIgnoreCase(word) && (position + 1 < tokens.length && tokens[position + 1].getToken().equalsIgnoreCase(word) || position > 1 && tokens[position - 2].getToken().equalsIgnoreCase(word))) {
            return true;
        }
        if (tokens[position].getToken().matches("(?i)^[a-z]$") && position > 1 && tokens[position - 2].getToken().matches("(?i)^[a-z]$") && position + 1 < tokens.length && tokens[position + 1].getToken().matches("(?i)^[a-z]$")) {
            return true;
        }
        if (this.repetitionOf("blah", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("uh", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("paw", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("yum", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("wop", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("woop", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("fnarr", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("fnar", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("ha", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("omg", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("boo", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("tick", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("twinkle", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("ta", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("la", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("x", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("hi", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("ho", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("heh", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("jay", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("walla", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("sri", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("hey", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("hah", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("heh", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("oh", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("ouh", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("chop", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("ring", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("beep", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("bleep", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("yeah", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("wait", tokens, position) && position == 2) {
            return true;
        }
        if (this.repetitionOf("quack", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("meow", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("squawk", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("whoa", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("si", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("honk", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("brum", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("chi", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("santorio", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("lapu", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("chow", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("beep", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("shh", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("yummy", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("boom", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("bye", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("ah", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("aah", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("bang", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("woof", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("wink", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("yes", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("tsk", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("hush", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("ding", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("choo", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("tuk", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("yadda", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("sapiens", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("tse", tokens, position)) {
            return true;
        }
        if (this.repetitionOf("no", tokens, position)) {
            return true;
        }
        if (tokens[position].getToken().endsWith("ay")) {
            if (tokens[position - 1].getToken().equals("may") && tokens[position].getToken().equals("May")) {
                return true;
            }
            if (tokens[position - 1].getToken().equals("May") && tokens[position].getToken().equals("may")) {
                return true;
            }
            if (tokens[1].getToken().equals("May") && tokens[2].getToken().equals("May")) {
                return true;
            }
        } else if (tokens[position].getToken().endsWith("ill")) {
            return position > 0 && tokens[position - 1].getToken().equals("will") && tokens[position].getToken().equals("Will") || tokens[position - 1].getToken().equals("Will") && tokens[position].getToken().equals("will") || tokens[1].getToken().equals("Will") && tokens[2].getToken().equals("Will");
        }
        return super.ignore(tokens, position);
    }

    private boolean posIsIn(AnalyzedTokenReadings[] tokens, int position, String ... posTags) {
        if (position >= 0 && position < tokens.length) {
            for (String posTag : posTags) {
                if (!tokens[position].hasPartialPosTag(posTag)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean repetitionOf(String word, AnalyzedTokenReadings[] tokens, int position) {
        return position > 0 && tokens[position - 1].getToken().equalsIgnoreCase(word) && tokens[position].getToken().equalsIgnoreCase(word);
    }
}

