/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.es.CompoundRule;
import org.languagetool.rules.es.MorfologikSpanishSpellerRule;
import org.languagetool.rules.es.QuestionMarkRule;
import org.languagetool.rules.es.SimpleReplaceRule;
import org.languagetool.rules.es.SimpleReplaceVerbsRule;
import org.languagetool.rules.es.SpanishConfusionProbabilityRule;
import org.languagetool.rules.es.SpanishMultitokenSpeller;
import org.languagetool.rules.es.SpanishRepeatedWordsRule;
import org.languagetool.rules.es.SpanishUnpairedBracketsRule;
import org.languagetool.rules.es.SpanishWikipediaRule;
import org.languagetool.rules.es.SpanishWordRepeatBeginningRule;
import org.languagetool.rules.es.SpanishWordRepeatRule;
import org.languagetool.rules.es.SpanishWrongWordInContextRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.multitoken.MultitokenSpeller;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.es.SpanishSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.es.SpanishHybridDisambiguator;
import org.languagetool.tagging.es.SpanishTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.es.SpanishWordTokenizer;
import org.languagetool.tools.StringTools;

public class Spanish
extends Language
implements AutoCloseable {
    private LanguageModel languageModel;
    private static final Map<String, Integer> id2prio = new HashMap<String, Integer>();
    private static final Pattern ES_CONTRACTIONS;
    private List<String> suggestionsToAvoid = Arrays.asList("aqu\u00e9l", "aqu\u00e9lla", "aqu\u00e9llas", "aqu\u00e9llos", "\u00e9sa", "\u00e9sas", "\u00e9se", "\u00e9sos", "\u00e9sta", "\u00e9stas", "\u00e9ste", "\u00e9stos", "s\u00f3lo");
    private Pattern voseoPostagPatern = Pattern.compile("V....V.*");

    public String getName() {
        return "Spanish";
    }

    public String getShortCode() {
        return "es";
    }

    public String[] getCountries() {
        return new String[]{"ES", "", "MX", "GT", "CR", "PA", "DO", "VE", "PE", "AR", "EC", "CL", "UY", "PY", "BO", "SV", "HN", "NI", "PR", "US", "CU"};
    }

    public Language getDefaultLanguageVariant() {
        return Languages.getLanguageForShortCode((String)"es");
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return SpanishTagger.INSTANCE;
    }

    public Disambiguator createDefaultDisambiguator() {
        return new SpanishHybridDisambiguator(this.getDefaultLanguageVariant());
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new SpanishWordTokenizer();
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return SpanishSynthesizer.INSTANCE;
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Jaume Ortol\u00e0")};
    }

    public SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikSpanishSpellerRule(messages, this, null, Collections.emptyList());
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"En su opini\u00f3n<marker> ,</marker> no era verdad."), Example.fixed((String)"En su opini\u00f3n<marker>,</marker> no era verdad.")), new DoublePunctuationRule(messages), new SpanishUnpairedBracketsRule(messages), new QuestionMarkRule(messages), new MorfologikSpanishSpellerRule(messages, this, userConfig, altLanguages), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"Venta al p\u00fablico. <marker>ha</marker> subido mucho."), Example.fixed((String)"Venta al p\u00fablico. <marker>Ha</marker> subido mucho.")), new SpanishWordRepeatRule(messages, this), new MultipleWhitespaceRule(messages, (Language)this), new SpanishWikipediaRule(messages), new SpanishWrongWordInContextRule(messages, this), new LongSentenceRule(messages, userConfig, 60), new LongParagraphRule(messages, (Language)this, userConfig), new SimpleReplaceRule(messages, this), new SimpleReplaceVerbsRule(messages, this), new SpanishWordRepeatBeginningRule(messages, this), new CompoundRule(messages, this, userConfig), new SpanishRepeatedWordsRule(messages)});
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        this.languageModel = this.initLanguageModel(indexDir, this.languageModel);
        return this.languageModel;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return Arrays.asList(new Rule[]{new SpanishConfusionProbabilityRule(messages, languageModel, this)});
    }

    public String getOpeningDoubleQuote() {
        return "\u00ab";
    }

    public String getClosingDoubleQuote() {
        return "\u00bb";
    }

    public String getOpeningSingleQuote() {
        return "\u2018";
    }

    public String getClosingSingleQuote() {
        return "\u2019";
    }

    public boolean isAdvancedTypographyEnabled() {
        return true;
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    public Map<String, Integer> getPriorityMap() {
        return id2prio;
    }

    protected int getPriorityForId(String id) {
        if (id.equals("CONFUSIONS2")) {
            return 50;
        }
        if (id.equals("RARE_WORDS")) {
            return 50;
        }
        if (id.equals("MISSPELLING")) {
            return 40;
        }
        if (id.equals("CONFUSIONS")) {
            return 40;
        }
        if (id.equals("INCORRECT_EXPRESSIONS")) {
            return 40;
        }
        if (id.equals("DIACRITICS")) {
            return 30;
        }
        if (id.startsWith("ES_SIMPLE_REPLACE_SIMPLE")) {
            return 30;
        }
        if (id.startsWith("ES_COMPOUNDS")) {
            return 50;
        }
        Integer prio = id2prio.get(id);
        if (prio != null) {
            return prio;
        }
        if (id.startsWith("AI_ES_HYDRA_LEO")) {
            return -101;
        }
        if (id.startsWith("AI_ES_GGEC")) {
            if (id.equals("AI_ES_GGEC_REPLACEMENT_OTHER")) {
                return -300;
            }
            return 0;
        }
        if (id.startsWith("ES_MULTITOKEN_SPELLING")) {
            return -95;
        }
        return super.getPriorityForId(id);
    }

    public boolean hasMinMatchesRules() {
        return true;
    }

    public String adaptSuggestion(String replacement) {
        Matcher m = ES_CONTRACTIONS.matcher(replacement);
        String newReplacement = m.replaceAll("$1$2");
        return newReplacement;
    }

    public List<String> prepareLineForSpeller(String line) {
        String[] parts = line.split("#");
        if (parts.length == 0) {
            return Arrays.asList(line);
        }
        String[] formTag = parts[0].split("[\t;]");
        if (formTag.length > 1) {
            String tag = formTag[1].trim();
            if (tag.startsWith("N") || tag.equals("_Latin_") || tag.equals("LOC_ADV")) {
                return Arrays.asList(formTag[0].trim());
            }
            return Arrays.asList("");
        }
        return Arrays.asList(line);
    }

    public MultitokenSpeller getMultitokenSpeller() {
        return SpanishMultitokenSpeller.INSTANCE;
    }

    public List<RuleMatch> mergeSuggestions(List<RuleMatch> ruleMatches, AnnotatedText text, Set<String> enabledRules) {
        ArrayList<RuleMatch> results = new ArrayList<RuleMatch>();
        for (RuleMatch ruleMatch : ruleMatches) {
            List suggestions = ruleMatch.getSuggestedReplacements();
            if (suggestions.size() == 1 && ruleMatch.getRule().getId().startsWith("AI_ES_GGEC")) {
                List atr;
                String suggestion = (String)suggestions.get(0);
                if (this.suggestionsToAvoid.contains(suggestion.toLowerCase()) || ruleMatch.getSentence().getText().trim().startsWith(StringTools.uppercaseFirstChar((String)suggestion))) continue;
                try {
                    atr = this.getTagger().tag(Arrays.asList(suggestion));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (atr != null && atr.size() > 0 && ((AnalyzedTokenReadings)atr.get(0)).matchesPosTagRegex(this.voseoPostagPatern)) continue;
            }
            results.add(ruleMatch);
        }
        return results;
    }

    static {
        id2prio.put("ES_SIMPLE_REPLACE_MULTIWORDS", 50);
        id2prio.put("LOS_MAPUCHE", 50);
        id2prio.put("TE_TILDE", 50);
        id2prio.put("DE_TILDE", 50);
        id2prio.put("PLURAL_SEPARADO", 50);
        id2prio.put("PERSONAJES_FAMOSOS", 50);
        id2prio.put("NO_SEPARADO", 40);
        id2prio.put("PARTICIPIO_MS", 40);
        id2prio.put("VERBO_MODAL_INFINITIVO", 40);
        id2prio.put("EL_NO_TILDE", 40);
        id2prio.put("SE_CREO", 35);
        id2prio.put("POR_CIERTO", 30);
        id2prio.put("DEGREE_CHAR", 30);
        id2prio.put("LO_LOS", 30);
        id2prio.put("ETCETERA", 30);
        id2prio.put("P_EJ", 30);
        id2prio.put("SE_CREO2", 25);
        id2prio.put("AGREEMENT_ADJ_NOUN_AREA", 30);
        id2prio.put("PRONOMBRE_SIN_VERBO", 25);
        id2prio.put("AGREEMENT_DET_ABREV", 25);
        id2prio.put("MUCHO_NF", 25);
        id2prio.put("AGREEMENT_DET_NOUN_EXCEPTIONS", 25);
        id2prio.put("TYPOGRAPHY", 20);
        id2prio.put("AGREEMENT_DET_NOUN", 15);
        id2prio.put("AGREEMENT_DET_ADJ", 10);
        id2prio.put("CONFUSION_ES_SE", 20);
        id2prio.put("HALLA_HAYA", 10);
        id2prio.put("VALLA_VAYA", 10);
        id2prio.put("SI_AFIRMACION", 10);
        id2prio.put("TE_TILDE2", 10);
        id2prio.put("SEPARADO", 1);
        id2prio.put("ES_SPLIT_WORDS", -10);
        id2prio.put("U_NO", -10);
        id2prio.put("EL_TILDE", -10);
        id2prio.put("SINGLE_CHARACTER", -15);
        id2prio.put("TOO_LONG_PARAGRAPH", -15);
        id2prio.put("PREP_VERB", -20);
        id2prio.put("SUBJUNTIVO_FUTURO", -30);
        id2prio.put("SUBJUNTIVO_PASADO", -30);
        id2prio.put("SUBJUNTIVO_PASADO2", -30);
        id2prio.put("AGREEMENT_ADJ_NOUN", -30);
        id2prio.put("AGREEMENT_PARTICIPLE_NOUN", -30);
        id2prio.put("AGREEMENT_POSTPONED_ADJ", -30);
        id2prio.put("MULTI_ADJ", -30);
        id2prio.put("SUBJUNTIVO_INCORRECTO", -40);
        id2prio.put("COMMA_SINO", -40);
        id2prio.put("COMMA_SINO2", -40);
        id2prio.put("VOSEO", -40);
        id2prio.put("REPETITIONS_STYLE", -50);
        id2prio.put("MORFOLOGIK_RULE_ES", -100);
        id2prio.put("PHRASE_REPETITION", -150);
        id2prio.put("SPANISH_WORD_REPEAT_RULE", -150);
        id2prio.put("UPPERCASE_SENTENCE_START", -200);
        id2prio.put("ES_QUESTION_MARK", -250);
        ES_CONTRACTIONS = Pattern.compile("\\b([Aa]|[Dd]e) e(l)\\b");
    }
}

