/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.es;

import java.io.IOException;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractCompoundRule;
import org.languagetool.rules.CompoundRuleData;
import org.languagetool.rules.Example;
import org.languagetool.tagging.es.SpanishTagger;

public class CompoundRule
extends AbstractCompoundRule {
    private static volatile CompoundRuleData compoundData;

    public CompoundRule(ResourceBundle messages, Language lang, UserConfig userConfig) throws IOException {
        super(messages, lang, userConfig, "Se escribe con un guion.", "Se escribe junto sin espacio ni guion.", "Se escribe junto o con un guion.", "Error de palabra compuesta");
        super.useSubRuleSpecificIds();
        this.addExamplePair(Example.wrong((String)"<marker>Guinea Conakri</marker>."), Example.fixed((String)"<marker>Guinea-Conakri</marker>."));
    }

    public String getId() {
        return "ES_COMPOUNDS";
    }

    public String getDescription() {
        return "Palabras compuestas con guion: $match";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompoundRuleData getCompoundRuleData() {
        CompoundRuleData data = compoundData;
        if (data != null) return data;
        Class<CompoundRule> clazz = CompoundRule.class;
        synchronized (CompoundRule.class) {
            data = compoundData;
            if (data != null) return data;
            compoundData = data = new CompoundRuleData("/es/compounds.txt");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return data;
        }
    }

    public boolean isMisspelled(String word) throws IOException {
        return !SpanishTagger.INSTANCE.tag(Arrays.asList(word)).get(0).isTagged();
    }
}

