/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.es;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.tools.StringTools;

public class QuestionMarkRule
extends TextLevelRule {
    public QuestionMarkRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.TYPOGRAPHY.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Typographical);
        this.addExamplePair(Example.wrong((String)"<marker>Qu\u00e9</marker> pasa?"), Example.fixed((String)"<marker>\u00bfQu\u00e9</marker> pasa?"));
    }

    public int minToCheckParagraph() {
        return 1;
    }

    public final String getId() {
        return "ES_QUESTION_MARK";
    }

    public String getDescription() {
        return "Signos de exclamaci\u00f3n / interrogaci\u00f3n desparejados";
    }

    public RuleMatch[] match(List<AnalyzedSentence> sentences) {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        boolean prevSentEndsWithColon = false;
        int pos = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
            int needsInvQuestionMarkAt = this.hasTokenAtPos("?", tokens);
            int needsInvExclMarkAt = this.hasTokenAtPos("!", tokens);
            boolean endsWithColon = tokens[tokens.length - 1].getToken().equals(":");
            if (needsInvQuestionMarkAt > 1 || needsInvExclMarkAt > 1) {
                boolean hasInvQuestionMark = false;
                boolean hasInvExlcMark = false;
                AnalyzedTokenReadings firstToken = null;
                for (int i = 0; i < tokens.length; ++i) {
                    if (firstToken == null && !tokens[i].isSentenceStart() && !StringTools.isPunctuationMark((String)tokens[i].getToken())) {
                        firstToken = tokens[i];
                    }
                    if (tokens[i].getToken().equals("\u00bf") && i < needsInvQuestionMarkAt) {
                        hasInvQuestionMark = true;
                    } else if (tokens[i].getToken().equals("\u00a1") && i < needsInvExclMarkAt) {
                        hasInvExlcMark = true;
                    }
                    if (!tokens[i].isSentenceEnd() && (tokens[i].getToken().equals("?") && i > needsInvQuestionMarkAt || tokens[i].getToken().equals("!") && i > needsInvExclMarkAt)) {
                        firstToken = null;
                    }
                    if (i > 2 && i + 2 < tokens.length) {
                        if (tokens[i - 1].getToken().equals(",") && tokens[i].hasPosTag("CC") && tokens[i + 1].hasPosTag("SPS00") && (tokens[i + 2].hasPosTagStartingWith("PT") || tokens[i + 2].hasPosTagStartingWith("DT"))) {
                            firstToken = tokens[i];
                        }
                        if (tokens[i - 1].getToken().equals(",") && tokens[i].hasPosTag("SPS00") && (tokens[i + 1].hasPosTagStartingWith("PT") || tokens[i + 1].hasPosTagStartingWith("DT"))) {
                            firstToken = tokens[i];
                        }
                        if (tokens[i - 1].getToken().equals(",") && tokens[i].hasPosTag("CC") && (tokens[i + 1].hasPosTagStartingWith("PT") || tokens[i + 1].hasPosTagStartingWith("DT"))) {
                            firstToken = tokens[i];
                        }
                        if (tokens[i - 1].getToken().equals(",") && (tokens[i].hasPosTagStartingWith("PT") || tokens[i].hasPosTagStartingWith("DT"))) {
                            firstToken = tokens[i];
                        }
                        if (tokens[i - 1].getToken().equals(",") && tokens[i].hasPosTag("CC") && (tokens[i + 1].getToken().equals("no") || tokens[i + 1].getToken().equals("s\u00ed"))) {
                            firstToken = tokens[i];
                        }
                    }
                    if (i <= 2 || i >= tokens.length || !tokens[i - 1].getToken().equals(",") || !tokens[i].getToken().equals("no") && !tokens[i].getToken().equals("s\u00ed") && !tokens[i].getToken().equals("eh")) continue;
                    firstToken = tokens[i];
                }
                if (firstToken != null && !firstToken.hasPosTag("_english_ignore_")) {
                    String s = null;
                    if (needsInvQuestionMarkAt <= 1 || needsInvExclMarkAt <= 1) {
                        if (needsInvQuestionMarkAt > 1 && !hasInvQuestionMark) {
                            s = "\u00bf";
                        } else if (needsInvExclMarkAt > 1 && !hasInvExlcMark) {
                            s = "\u00a1";
                        }
                    }
                    if (s != null) {
                        String message = "S\u00edmbolo desparejado: Parece que falta un '" + s + "'";
                        RuleMatch match = new RuleMatch((Rule)this, sentence, pos + firstToken.getStartPos(), pos + firstToken.getEndPos(), message);
                        match.setSuggestedReplacement(s + firstToken.getToken());
                        matches.add(match);
                    }
                }
            }
            pos += sentence.getCorrectedTextLength();
            prevSentEndsWithColon = endsWithColon;
        }
        return this.toRuleMatchArray(matches);
    }

    private int hasTokenAtPos(String ch, AnalyzedTokenReadings[] tokens) {
        for (int i = tokens.length - 1; i > 0; --i) {
            if (!tokens[i].getToken().equals(ch)) continue;
            return i;
        }
        return -1;
    }
}

