/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.gl;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Galician;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class GalicianWikipediaRule
extends AbstractSimpleReplaceRule2 {
    public static final String WIKIPEDIA_COMMON_ERRORS = "GL_WIKIPEDIA_COMMON_ERRORS";
    private static final String FILE_NAME = "/gl/wikipedia.txt";
    private static final Locale GL_LOCALE = new Locale("gl");

    public final List<String> getFileNames() {
        return Collections.singletonList(FILE_NAME);
    }

    public GalicianWikipediaRule(ResourceBundle messages) throws IOException {
        super(messages, (Language)new Galician());
        super.setCategory(Categories.WIKIPEDIA.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Grammar);
        this.addExamplePair(Example.wrong((String)"<marker>a efectos de</marker>"), Example.fixed((String)"<marker>para os efectos de</marker>"));
    }

    public final String getId() {
        return WIKIPEDIA_COMMON_ERRORS;
    }

    public String getDescription() {
        return "Erros frecuentes nos artigos da Wikipedia";
    }

    public String getShort() {
        return "Erro gramatical ou de normativa";
    }

    public String getMessage() {
        return "'$match' \u00e9 un erro. Considere utilizar $suggestions";
    }

    public String getSuggestionsSeparator() {
        return " ou ";
    }

    public URL getUrl() {
        return Tools.getUrl((String)"https://gl.wikipedia.org/wiki/Wikipedia:Erros_de_ortograf%C3%ADa_e_desviaci%C3%B3ns");
    }

    public Locale getLocale() {
        return GL_LOCALE;
    }
}

