/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.EmptyLineRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.ParagraphRepeatBeginningRule;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhiteSpaceAtBeginOfParagraph;
import org.languagetool.rules.WhiteSpaceBeforeParagraphEnd;
import org.languagetool.rules.gl.CastWordsRule;
import org.languagetool.rules.gl.GalicianBarbarismsRule;
import org.languagetool.rules.gl.GalicianRedundancyRule;
import org.languagetool.rules.gl.GalicianWikipediaRule;
import org.languagetool.rules.gl.GalicianWordinessRule;
import org.languagetool.rules.gl.SimpleReplaceRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.hunspell.HunspellRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.gl.GalicianSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.gl.GalicianHybridDisambiguator;
import org.languagetool.tagging.gl.GalicianTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.gl.GalicianWordTokenizer;

public class Galician
extends Language {
    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public String getName() {
        return "Galician";
    }

    public String getShortCode() {
        return "gl";
    }

    public String[] getCountries() {
        return new String[]{"ES"};
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new GalicianTagger();
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new GalicianWordTokenizer();
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return GalicianSynthesizer.INSTANCE;
    }

    public Disambiguator createDefaultDisambiguator() {
        return new GalicianHybridDisambiguator();
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.LookingForNewMaintainer;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Susana Sotelo Doc\u00edo"), new Contributor("Tiago F. Santos (4.0-4.7)", "https://github.com/TiagoSantos81")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"Tomamos caf\u00e9<marker> ,</marker> queixo, bolachas e uvas."), Example.fixed((String)"Tomamos caf\u00e9<marker>,</marker> queixo, bolachas e uvas.")), new DoublePunctuationRule(messages), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{", "\u201c", "\u00ab", "\u00bb", "\u2018", "\"", "'"), Arrays.asList("]", ")", "}", "\u201d", "\u00bb", "\u00ab", "\u2019", "\"", "'")), new HunspellRule(messages, (Language)this, userConfig, altLanguages), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"Esta casa \u00e9 vella. <marker>foi</marker> construida en 1950."), Example.fixed((String)"Esta casa \u00e9 vella. <marker>Foi</marker> construida en 1950.")), new MultipleWhitespaceRule(messages, (Language)this), new LongSentenceRule(messages, userConfig, 50), new LongParagraphRule(messages, (Language)this, userConfig), new SentenceWhitespaceRule(messages), new WhiteSpaceBeforeParagraphEnd(messages, (Language)this), new WhiteSpaceAtBeginOfParagraph(messages), new EmptyLineRule(messages, (Language)this), new ParagraphRepeatBeginningRule(messages, (Language)this), new PunctuationMarkAtParagraphEnd(messages, (Language)this), new SimpleReplaceRule(messages), new CastWordsRule(messages), new GalicianRedundancyRule(messages), new GalicianWordinessRule(messages), new GalicianBarbarismsRule(messages), new GalicianWikipediaRule(messages)});
    }

    @Nullable
    protected SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new HunspellRule(messages, (Language)this, null, null);
    }

    protected int getPriorityForId(String id) {
        switch (id) {
            case "DEGREE_MINUTES_SECONDS": {
                return 30;
            }
            case "UNPAIRED_BRACKETS": {
                return -5;
            }
            case "GL_BARBARISM_REPLACE": {
                return -10;
            }
            case "GL_SIMPLE_REPLACE": {
                return -11;
            }
            case "GL_REDUNDANCY_REPLACE": {
                return -12;
            }
            case "GL_WORDINESS_REPLACE": {
                return -13;
            }
            case "TOO_LONG_PARAGRAPH": {
                return -15;
            }
            case "GL_WIKIPEDIA_COMMON_ERRORS": {
                return -45;
            }
            case "HUNSPELL_RULE": {
                return -50;
            }
            case "REPEATED_WORDS": {
                return -210;
            }
            case "REPEATED_WORDS_3X": {
                return -211;
            }
            case "TOO_LONG_SENTENCE_20": {
                return -997;
            }
            case "TOO_LONG_SENTENCE_25": {
                return -998;
            }
            case "TOO_LONG_SENTENCE_30": {
                return -999;
            }
            case "TOO_LONG_SENTENCE_35": {
                return -1000;
            }
            case "TOO_LONG_SENTENCE_40": {
                return -1001;
            }
            case "TOO_LONG_SENTENCE_45": {
                return -1002;
            }
            case "TOO_LONG_SENTENCE_50": {
                return -1003;
            }
            case "TOO_LONG_SENTENCE_60": {
                return -1004;
            }
        }
        return super.getPriorityForId(id);
    }
}

