/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.nl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.Dutch;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;

public final class MorfologikDutchSpellerRule
extends MorfologikSpellerRule {
    public MorfologikDutchSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig) throws IOException {
        this(messages, language, userConfig, Collections.emptyList());
    }

    public MorfologikDutchSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        super(messages, language, userConfig, altLanguages);
    }

    protected boolean ignorePotentiallyMisspelledWord(String word) throws IOException {
        return Dutch.getCompoundAcceptor().acceptCompound(word);
    }

    public String getFileName() {
        return "/nl/spelling/nl_NL.dict";
    }

    public String getId() {
        return "MORFOLOGIK_RULE_NL_NL";
    }

    protected String getIgnoreFileName() {
        return "/nl/spelling/ignore.txt";
    }

    public String getSpellingFileName() {
        return "/nl/spelling/spelling.txt";
    }

    protected String getProhibitFileName() {
        return "/nl/spelling/prohibit.txt";
    }

    public List<RuleMatch> getRuleMatches(String word, int startPos, AnalyzedSentence sentence, List<RuleMatch> ruleMatchesSoFar, int idx, AnalyzedTokenReadings[] tokens) throws IOException {
        if (tokens[idx].hasPosTag("_english_ignore_")) {
            return Collections.emptyList();
        }
        return super.getRuleMatches(word, startPos, sentence, ruleMatchesSoFar, idx, tokens);
    }
}

