/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.pt;

import java.util.Arrays;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.WordRepeatBeginningRule;

public class PortugueseWordRepeatBeginningRule
extends WordRepeatBeginningRule {
    private static final Set<String> ADVERBS = new HashSet<String>(Arrays.asList("Abaixo", "Acaso", "Acima", "Acol\u00e1", "Ademais", "Adentro", "Adiante", "Adicionalmente", "Afinal", "Afora", "Agora", "A\u00ed", "Ainda", "Al\u00e9m", "Algures", "Ali", "Ali\u00e1s", "Amanh\u00e3", "Ami\u00fade", "Antigamente", "Aonde", "Apenas", "Apesar", "Aqu\u00e9m", "Aqui", "Assaz", "Assim", "At\u00e9", "Atr\u00e1s", "Bastante", "Bem", "Bondosamente", "Breve", "C\u00e1", "Casualmente", "Cedo", "Certamente", "Certo", "Constantemente", "Cuidadosamente", "Dantes", "Debaixo", "Debalde", "Decerto", "Defronte", "Demais", "Demasiado", "Dentro", "Depois", "Depressa", "Detr\u00e1s", "Devagar", "Doravante", "E", "Efetivamente", "Embaixo", "Embora", "Enfim", "Ent\u00e3o", "Entrementes", "Exclusivamente", "Externamente", "Fora", "Frequentemente", "Generosamente", "Hoje", "Imediatamente", "Inclusivamente", "Inda", "J\u00e1", "Jamais", "L\u00e1", "Logo", "Longe", "Mais", "Mal", "Mas", "Melhor", "Menos", "Mesmo", "Muito", "N\u00e3o", "Nem", "Nenhures", "Nunca", "Onde", "Ontem", "Ora", "Ou", "Outra", "Outro", "Outrora", "Outrossim", "Perto", "Pior", "Porventura", "Possivelmente", "Pouco", "Primeiramente", "Primeiro", "Principalmente", "Provavelmente", "Provisoriamente", "Quanto", "Qu\u00e3o", "Quase", "Qui\u00e7\u00e1", "Realmente", "Salvo", "Seguidamente", "Sempre", "Sen\u00e3o", "Ser\u00e1", "Sim", "Simplesmente", "S\u00f3", "Sobremaneira", "Sobremodo", "Sobretudo", "Somente", "Sucessivamente", "Talvez", "Tamb\u00e9m", "Tampouco", "Tanto", "T\u00e3o", "Tarde", "Ultimamente", "Unicamente"));

    public PortugueseWordRepeatBeginningRule(ResourceBundle messages, Language language) {
        super(messages, language);
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.addExamplePair(Example.wrong((String)"Al\u00e9m disso, a rua \u00e9 quase completamente resid\u00eancial. <marker>Al\u00e9m</marker> disso, foi chamada em nome de um poeta."), Example.fixed((String)"Al\u00e9m disso, a rua \u00e9 quase completamente resid\u00eancial. <marker>Foi</marker> chamada em nome de um poeta."));
    }

    public String getId() {
        return "PORTUGUESE_WORD_REPEAT_BEGINNING_RULE";
    }

    protected boolean isAdverb(AnalyzedTokenReadings token) {
        return ADVERBS.contains(token.getToken());
    }
}

