/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.uk.CaseGovernmentHelper;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.rules.uk.RuleException;
import org.languagetool.rules.uk.SearchHelper;
import org.languagetool.rules.uk.TokenAgreementNounVerbExceptionHelper;
import org.languagetool.rules.uk.TokenAgreementPrepNounRule;
import org.languagetool.rules.uk.TokenAgreementVerbNounRule;
import org.languagetool.rules.uk.VerbInflectionHelper;
import org.languagetool.tagging.uk.PosTagHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenAgreementVerbNounExceptionHelper {
    private static final Logger logger = LoggerFactory.getLogger(TokenAgreementVerbNounExceptionHelper.class);
    private static final Pattern VCHYTY_PATTERN = Pattern.compile(".*\u0432\u0447[\u0430\u0438]\u0442\u0438(\u0441\u044f)?");
    private static final Pattern ADV_PREDICT_PATTERN = Pattern.compile("(adv|noninfl:&predic).*");
    private static final Pattern MODALS_ADJ = Pattern.compile("\u0437\u043c\u0443\u0448\u0435\u043d\u0438\u0439|\u0432\u0438\u043c\u0443\u0448\u0435\u043d\u0438\u0439|\u043f\u043e\u0432\u0438\u043d\u043d\u0438\u0439|\u0437\u0434\u0430\u0442\u043d\u0438\u0439|\u0433\u043e\u0442\u043e\u0432\u0438\u0439|\u043b\u0430\u0434\u043d\u0438\u0439|\u0440\u0430\u0434\u0438\u0439");
    private static final Pattern PARTS_CANT_SKIP = Pattern.compile("\u0456|\u0439|\u0442\u0430|\u0447\u0438|\u0430\u0431\u043e|\u0430\u043b\u0435|\u044f\u043a|\u0434\u0435|\u043a\u0443\u0434\u0438|\u043d\u0430\u0447\u0435|\u043d\u0456\u0431\u0438|\u0445\u043e\u0447|\u043d\u0430\u0432\u0456\u0449\u043e|\u043d\u0435\u043c\u043e\u0432|\u0432\u0434\u0432\u0456\u0447\u0456|\u0434\u0435\u0434\u0430\u043b\u0456|\u0449\u043e\u0439\u043d\u043e|\u043d\u0430\u0441\u043a\u0456\u043b\u044c\u043a\u0438");

    private TokenAgreementVerbNounExceptionHelper() {
    }

    public static boolean isException(AnalyzedTokenReadings[] tokens, TokenAgreementVerbNounRule.State state, List<VerbInflectionHelper.Inflection> verbInflections, List<VerbInflectionHelper.Inflection> nounAdjInflections, List<AnalyzedToken> verbTokenReadings, List<AnalyzedToken> nounTokenReadings) {
        String genders2;
        Pattern vRodDriverPattern;
        int xpos;
        int v2pos;
        Set<String> advReq;
        int verbPos = state.verbPos;
        int nounAdjPos = state.nounPos;
        String cleanTokenLower = tokens[nounAdjPos].getCleanToken().toLowerCase();
        if (PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("numr.*v_naz.*")) || LemmaHelper.hasLemma(tokens[nounAdjPos], LemmaHelper.ADV_QUANT_PATTERN, Pattern.compile("noun.*v_naz.*|adv.*|part.*"))) {
            if (PosTagHelper.hasPosTag(state.verbAnalyzedTokenReadings, Pattern.compile(".*:[sn](:.*|$)"))) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
            if (verbPos > 1 && PosTagHelper.hasPosTag(state.verbAnalyzedTokenReadings, Pattern.compile("verb.*inf.*")) && LemmaHelper.hasLemma(tokens[verbPos - 1], Pattern.compile("\u0431\u0443\u0442\u0438|\u043c\u0443\u0441\u0438\u0442\u0438"), Pattern.compile("verb.*(past:n|:s:3).*"))) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
        }
        if (verbPos > 1 && LemmaHelper.hasLemma(tokens[verbPos], "\u0431\u0443\u0442\u0438") && LemmaHelper.hasLemma(tokens[verbPos - 1], MODALS_ADJ, Pattern.compile("adj:.:v_naz.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[verbPos], Pattern.compile("\u0437?\u043c\u043e\u0433\u0442\u0438")) && PosTagHelper.hasPosTag(tokens[nounAdjPos], ".*v_oru.*")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 1 && LemmaHelper.hasLemma(tokens[verbPos], Pattern.compile("\u0437?\u043c\u043e\u0433\u0442\u0438")) && tokens[verbPos - 1].getCleanToken().toLowerCase().equals("\u0447\u0438\u043c")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[verbPos], "\u0445\u043e\u0442\u0456\u0442\u0438") && PosTagHelper.hasPosTagPart(tokens[nounAdjPos], "v_oru")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[verbPos], Pattern.compile("\u043c\u0430\u0442\u0438|\u043c\u0430\u044e\u0447\u0438|\u043c\u0430\u0432\u0448\u0438")) && PosTagHelper.hasPosTagPart(tokens[nounAdjPos], "v_oru")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[verbPos], Pattern.compile("\u0431\u0443\u0442\u0438")) && PosTagHelper.hasPosTag(tokens[nounAdjPos], "(adj|numr).*v_rod.*")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 1 && tokens[verbPos - 1].getCleanToken().toLowerCase().equals("\u0449\u043e") && LemmaHelper.hasLemma(tokens[verbPos], Pattern.compile("\u0431\u0443\u0442\u0438"), Pattern.compile("verb.*(:s:3|past:n).*")) && PosTagHelper.hasPosTag(tokens[nounAdjPos], "(adj|noun).*v_rod.*")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 1 && tokens[verbPos].getCleanToken().toLowerCase().equals("\u0431\u0443\u043b\u043e") && tokens[verbPos - 1].getCleanToken().toLowerCase().equals("\u043d\u0430\u0432\u0456\u0449\u043e")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 1 && tokens[verbPos].getCleanToken().toLowerCase().equals("\u0431\u0443\u043b\u043e") && PosTagHelper.hasPosTag(tokens[verbPos - 1], "(adv:comp[cs].*|.*predic.*)")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 2 && tokens[verbPos].getCleanToken().toLowerCase().equals("\u0431\u0443\u043b\u043e") && tokens[verbPos - 1].getCleanToken().toLowerCase().matches("\u0431\u0438?") && PosTagHelper.hasPosTag(tokens[verbPos - 2], "(adv:comp[cs].*|.*predic.*)")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 1 && tokens[verbPos].getCleanToken().toLowerCase().equals("\u0431\u0443\u043b\u043e") && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile(".*v_naz.*")) && PosTagHelper.hasPosTag(tokens[verbPos - 1], "adj:.:v_naz:&adjp:.*:perf.*")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (cleanTokenLower.matches("\u0437\u0430\u0439\u0432\u0435|\u0440\u0435\u0437\u043e\u043d")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (tokens[verbPos].getCleanToken().toLowerCase().matches("\u0431\u0443\u043b\u043e|\u0431\u0443\u0434\u0435") && LemmaHelper.hasLemma(tokens[nounAdjPos], Arrays.asList("\u0432\u0435\u0441\u044c"), Pattern.compile(".*v_zna.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (tokens[verbPos].getCleanToken().toLowerCase().matches("\u0431\u0443\u043b\u043e|\u0431\u0443\u0434\u0435") && new SearchHelper.Match().target(SearchHelper.Condition.postag(Pattern.compile(".*predic.*"))).limit(nounAdjPos - verbPos).mAfter(tokens, verbPos + 1) >= 0) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (tokens[verbPos].getCleanToken().toLowerCase().matches("\u0431\u0443\u043b\u043e|\u0431\u0443\u0434\u0435") && new SearchHelper.Match().target(SearchHelper.Condition.lemma(Pattern.compile("\u0442\u0440\u0435\u0431\u0430|\u043f\u043e\u0442\u0440\u0456\u0431\u043d\u043e"))).mNow(tokens, verbPos - 1) >= 0) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (tokens[verbPos].getCleanToken().toLowerCase().equals("\u0431\u0443\u0432")) {
            if (tokens[nounAdjPos].getCleanToken().toLowerCase().matches("\u043b\u044e\u0434\u0438\u043d\u0430|\u0437\u043d\u0430\u043c\u0435\u043d\u0438\u0442\u0456\u0441\u0442\u044c")) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
            if (nounAdjPos < tokens.length - 1 && tokens[nounAdjPos + 1].getCleanToken().toLowerCase().matches("\u043b\u044e\u0434\u0438\u043d\u0430")) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
        }
        if (verbPos > 1 && tokens[verbPos - 1].getCleanToken().toLowerCase().equals("\u043a\u043e\u043d\u043a\u0443\u0440\u0441") && LemmaHelper.hasLemma(tokens[verbPos], Pattern.compile("\u0431\u0443\u0442\u0438"), Pattern.compile("verb.*(:s:3|past:m).*")) && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("num.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos - verbPos > 1 && (advReq = CaseGovernmentHelper.getCaseGovernments(tokens[nounAdjPos - 1], Pattern.compile("adv(?!p).*"))).size() > 0) {
            for (int ii = verbPos + 1; ii < nounAdjPos; ++ii) {
                if (!TokenAgreementPrepNounRule.hasVidmPosTag(advReq, tokens[ii])) continue;
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
        }
        if (LemmaHelper.PLUS_MINUS.contains(cleanTokenLower)) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (cleanTokenLower.matches("[0-9]+-.+|\u0434\u043e\u0440\u043e\u0433\u043e\u044e|\u0442\u043e\u043b\u043a\u043e\u043c|\u0434\u0438\u0432\u043e\u043c|\u0447\u0432\u0435\u0440\u0442\u044c|\u0442\u0440\u0435\u0442\u0438\u043d\u0443|\u043f\u043e\u043b\u043e\u0432\u0438\u043d\u0443|\u0441\u0432\u044f\u0442\u0430\u044f")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 1 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("adj:[fn]:v_(zna|oru).*")) && LemmaHelper.hasLemma(tokens[nounAdjPos + 1], Arrays.asList("\u0434\u043e\u0440\u043e\u0433\u0430", "\u0436\u0438\u0442\u0442\u044f", "\u043c\u0456\u0440\u0430"), Pattern.compile("noun:inanim:[fn]:v_(zna|oru).*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTagPart(tokens[verbPos], "impers") && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile(".*v_oru.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[nounAdjPos], Arrays.asList("\u043a\u043e\u0436\u043d\u0438\u0439"), Pattern.compile(".*v_naz.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[verbPos], Arrays.asList("\u0437\u0432\u0430\u0442\u0438", "\u043d\u0430\u0437\u0438\u0432\u0430\u0442\u0438", "\u0437\u0432\u0430\u0442\u0438\u0441\u044f", "\u043d\u0430\u0437\u0438\u0432\u0430\u0442\u0438\u0441\u044f")) && Character.isUpperCase(tokens[nounAdjPos].getCleanToken().charAt(0))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[verbPos], Arrays.asList("\u0442\u0440\u0438\u0432\u0430\u0442\u0438", "\u043f\u0440\u043e\u0442\u0440\u0438\u0432\u0430\u0442\u0438", "\u0439\u0442\u0438", "\u0456\u0442\u0438", "\u0445\u043e\u0434\u0438\u0442\u0438", "\u0457\u0445\u0430\u0442\u0438")) && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("(adj|numr|noun:inanim).*v_zna.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 3 && tokens[verbPos].getCleanToken().equalsIgnoreCase("\u0432\u043f\u0430\u043b\u043e") && "\u043d\u0456".equals(tokens[verbPos - 1].getCleanToken())) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 2 && tokens[verbPos].getCleanToken().equalsIgnoreCase("\u0441\u043a\u0430\u0437\u0430\u0442\u0438") && "\u043d\u0435".equals(tokens[verbPos - 1].getCleanToken()) && PosTagHelper.hasPosTagPart(tokens[nounAdjPos], "v_naz")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (state.cases.contains("v_rod") && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("numr.*?v_zna.*|noun.*v_zna.*numr.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 1 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("(noun|adj):.*:v_rod.*")) && PosTagHelper.hasPosTag(tokens[nounAdjPos + 1], Pattern.compile("num.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 2 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("(noun|adj):.*:v_rod.*")) && LemmaHelper.isDash(tokens[nounAdjPos + 1]) && PosTagHelper.hasPosTag(tokens[nounAdjPos + 2], Pattern.compile("num.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 2 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("(noun:inanim|adj):.:v_rod.*")) && (v2pos = LemmaHelper.tokenSearch(tokens, state.nounPos + 1, (Pattern)null, Pattern.compile("\u043d\u0430"), Pattern.compile("[a-z].*"), LemmaHelper.Dir.FORWARD)) >= 0 && v2pos <= state.nounPos + 5 && v2pos < tokens.length - 1) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 2 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("noun.*v_(rod|zna).*")) && tokens[nounAdjPos + 1].getCleanToken().matches("\u043d\u0430|\u0437|\u0456\u0437|\u0437\u043e|\u043f\u0456\u0434") && PosTagHelper.hasPosTag(tokens[nounAdjPos + 2], Pattern.compile("number|numr.*v_zna.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTagPart(tokens[nounAdjPos], "v_dav")) {
            if (PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf")) {
                if (verbPos > 1 && LemmaHelper.hasLemma(tokens[verbPos - 1], Arrays.asList("\u044f\u043a", "\u043a\u0443\u0434\u0438", "\u0434\u0435", "\u0449\u043e", "\u0447\u043e\u0433\u043e", "\u0447\u0438"))) {
                    TokenAgreementVerbNounExceptionHelper.logException();
                    return true;
                }
                if (nounAdjPos < tokens.length - 1 && tokens[nounAdjPos + 1].getCleanToken().toLowerCase().matches("\u043d\u0456\u043a\u043e\u043b\u0438|\u043d\u0456\u043a\u0443\u0434\u0438|\u043d\u0456\u0447\u043e\u0433\u043e|\u043d\u0456\u0447\u0438\u043c|\u043d\u0456\u0434\u0435|\u043d\u0435\u043c\u0430\u0454?|\u043d\u0435")) {
                    TokenAgreementVerbNounExceptionHelper.logException();
                    return true;
                }
                if (LemmaHelper.hasLemma(tokens[verbPos], Arrays.asList("\u0436\u0438\u0442\u0438", "\u0441\u0438\u0434\u0456\u0442\u0438", "\u0441\u0443\u0434\u0438\u0442\u0438"))) {
                    TokenAgreementVerbNounExceptionHelper.logException();
                    return true;
                }
                if (verbPos > 1 && tokens[verbPos - 1].getCleanToken().toLowerCase().matches("\u043d\u0456\u043a\u043e\u043b\u0438|\u043d\u0456\u043a\u0443\u0434\u0438|\u043d\u0456\u0447\u043e\u0433\u043e|\u043d\u0456\u0447\u0438\u043c|\u043d\u0456\u0434\u0435|\u0434\u0435|\u043d\u0435\u043c\u0430\u0454?|\u043d\u0435")) {
                    TokenAgreementVerbNounExceptionHelper.logException();
                    return true;
                }
                if (verbPos > 1 && nounAdjPos < tokens.length - 1 && tokens[verbPos - 1].getCleanToken().toLowerCase().matches("\u043d\u0435|\u0430?\u043d\u0456") && PosTagHelper.hasPosTagPart(tokens[nounAdjPos + 1], "v_rod")) {
                    TokenAgreementVerbNounExceptionHelper.logException();
                    return true;
                }
                if (verbPos > 1 && tokens[verbPos - 1].getCleanToken().toLowerCase().matches("\u0441\u043b\u0456\u0434|\u0441\u043d\u0430\u0433\u0438|\u0441\u0438\u043b\u0443")) {
                    TokenAgreementVerbNounExceptionHelper.logException();
                    return true;
                }
            }
            if (nounAdjPos < tokens.length - 2 && tokens[nounAdjPos + 1].getCleanToken().toLowerCase().matches("\u0432|\u0443|\u043d\u0430|\u0432\u0456\u0434|\u043f\u0456\u0434|\u043f\u043e|\u0434\u043e|\u0456?\u0437|\u0437[\u0456\u043e]|\u043d\u0430\u0434|\u0437-\u043f\u0456\u0434|\u043f\u0435\u0440\u0435\u0434|\u043f\u043e\u043f\u0456\u0434|\u043f\u043e\u0437\u0430|\u043d\u0430\u043f\u0435\u0440\u0435\u0440\u0456\u0437") && PosTagHelper.hasPosTag(tokens[nounAdjPos + 2], Pattern.compile("(noun|adj).*"))) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
            if (nounAdjPos < tokens.length - 1 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile(".*v_dav.*")) && tokens[nounAdjPos + 1].getCleanToken().toLowerCase().matches("\u043d\u0430\u0437\u0443\u0441\u0442\u0440\u0456\u0447|\u043d\u0430\u0432\u043f\u0435\u0440\u0435\u0439\u043c\u0438|\u043d\u0430\u0432\u0437\u0434\u043e\u0433\u0456\u043d|\u0443\u0441\u043b\u0456\u0434")) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
            if (nounAdjPos < tokens.length - 2 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("noun.*?v_dav:&pron:(pers|refl).*"))) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
        }
        if (PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && tokens[nounAdjPos].getCleanToken().equalsIgnoreCase("\u0433\u0440\u0456\u0445")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (new SearchHelper.Match().skip(SearchHelper.Condition.postag(Pattern.compile(".*v_(rod|zna|oru).*|part.*|number"))).target(SearchHelper.Condition.lemma(LemmaHelper.TIME_PLUS_LEMMAS_PATTERN)).limit(4).mAfter(tokens, nounAdjPos) > 0) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 3 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("numr.*v_zna.*")) && new SearchHelper.Match().target(SearchHelper.Condition.lemma(LemmaHelper.TIME_PLUS_LEMMAS_PATTERN)).limit(4).mAfter(tokens, nounAdjPos + 1) > 0) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (new SearchHelper.Match().skip(SearchHelper.Condition.postag(Pattern.compile(".*v_oru.*|part.*|adv.*"))).target(new SearchHelper.Condition(Pattern.compile("\u043c\u043e\u0432\u0430"), Pattern.compile("noun:inanim:.:v_oru.*"))).limit(4).mAfter(tokens, nounAdjPos) > 0) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 1 && tokens[nounAdjPos + 1].getCleanToken().toLowerCase().equals("\u043a\u043e\u043b\u044c\u043e\u0440\u0443") && PosTagHelper.hasPosTagStart(tokens[nounAdjPos], "adj:m:v_rod")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTagPart(tokens[nounAdjPos], "v_kly") && PosTagHelper.hasPosTagPart(tokens[verbPos], "impr")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTagPart(nounTokenReadings, "noun:anim:m:v_naz") && PosTagHelper.hasPosTag(verbTokenReadings, Pattern.compile("verb.*:f(:.*|$)")) && TokenAgreementNounVerbExceptionHelper.hasMascFemLemma(nounTokenReadings)) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTagPart(tokens[state.nounPos], "v_rod") && PosTagHelper.hasPosTag(state.verbTokenReadings, Pattern.compile("verb.*?(futr|past):(s:3.*|n($|:.+))"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(state.verbAnalyzedTokenReadings, Pattern.compile("(\u043f\u043e)?\u043c\u0435\u043d\u0448\u0430\u0442\u0438|(\u043f\u043e)?\u0431\u0456\u043b\u044c\u0448\u0430\u0442\u0438|\u0441\u0442\u0430\u0442\u0438"), Pattern.compile("verb.*:[sn](:.*|$)")) && PosTagHelper.hasPosTag(tokens[state.nounPos], Pattern.compile("(noun|adj).*v_rod.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 1 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("noun:.*v_rod.*")) && tokens[nounAdjPos + 1].getCleanToken().matches("\u043c\u0435\u043d\u0448\u0435|\u0431\u0456\u043b\u044c\u0448\u0435")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (state.verbPos > 1 && PosTagHelper.hasPosTagPart(tokens[state.nounPos], "v_rod") && (xpos = LemmaHelper.tokenSearch(tokens, state.verbPos - 1, (String)null, vRodDriverPattern = Pattern.compile("\u043d\u0435|(\u043d\u0430)?\u0441[\u043a\u0442]\u0456\u043b\u044c\u043a\u0438|(\u043d\u0430\u0439)?\u0431\u0456\u043b\u044c\u0448\u0435|(\u043d\u0430\u0439)?\u043c\u0435\u043d\u0448\u0435|(\u043d\u0435|\u0437\u0430)?\u0431\u0430\u0433\u0430\u0442\u043e|(\u043d\u0435|\u0447\u0438|\u0437\u0430)?\u043c\u0430\u043b\u043e|\u0442\u0440\u043e\u0445\u0438|\u0433\u043e\u0434\u0456|\u043d\u0435\u043c\u043e\u0436\u043b\u0438\u0432\u043e|\u0430?\u043d\u0456\u0436|\u0432\u0434\u043e\u0441\u0442\u0430\u043b\u044c|\u043a\u0443\u043f\u0443", 66), Pattern.compile("[a-z].*"), LemmaHelper.Dir.REVERSE)) >= 0 && xpos >= state.verbPos - 4) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 1 && CaseGovernmentHelper.hasCaseGovernment(state.verbAnalyzedTokenReadings, PosTagHelper.VERB_ADVP_PATTERN, "v_inf") && (v2pos = LemmaHelper.tokenSearch(tokens, state.nounPos + 1, PosTagHelper.VERB_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.FORWARD)) >= 0 && v2pos <= state.nounPos + 5 && TokenAgreementVerbNounExceptionHelper.agrees(tokens[v2pos], state.nounAdjNazInflections, state.nounAdjIndirTokenReadings)) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 1 && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && (v2pos = LemmaHelper.tokenSearch(tokens, state.nounPos + 1, PosTagHelper.VERB_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.FORWARD)) >= 0 && v2pos <= state.nounPos + 4 && CaseGovernmentHelper.hasCaseGovernment(tokens[v2pos], PosTagHelper.VERB_PATTERN, "v_inf")) {
            if (TokenAgreementVerbNounExceptionHelper.agrees(tokens[v2pos], state.nounAdjNazInflections, state.nounAdjIndirTokenReadings)) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
            if (tokens[v2pos - 1].getCleanToken().equals("\u043d\u0435")) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
        }
        if (nounAdjPos < tokens.length - 1 && PosTagHelper.hasPosTagStart(tokens[verbPos], "advp") && (v2pos = LemmaHelper.tokenSearch(tokens, state.nounPos + 1, PosTagHelper.VERB_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.FORWARD)) >= 0 && v2pos <= state.nounPos + 3 && TokenAgreementVerbNounExceptionHelper.agrees(tokens[v2pos], state.nounAdjNazInflections, state.nounAdjIndirTokenReadings)) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 1 && PosTagHelper.hasPosTagStart(tokens[verbPos], "advp") && Arrays.asList("\u043f\u043e\u0441\u043c\u0456\u0445\u0430\u044e\u0447\u0438\u0441\u044c", "\u0441\u043c\u0456\u044e\u0447\u0438\u0441\u044c").contains(tokens[verbPos].getCleanToken()) && PosTagHelper.hasPosTagStart(tokens[verbPos - 1], "verb") && TokenAgreementVerbNounExceptionHelper.agrees(tokens[verbPos - 1], state.nounAdjNazInflections, state.nounAdjIndirTokenReadings)) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 1 && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && !LemmaHelper.hasLemma(tokens[verbPos], VCHYTY_PATTERN)) {
            v2pos = LemmaHelper.tokenSearch(tokens, state.nounPos + 1, ADV_PREDICT_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.FORWARD);
            while (v2pos >= 0 && v2pos <= state.nounPos + 4) {
                Set<String> cases = CaseGovernmentHelper.getCaseGovernments(tokens[v2pos], ADV_PREDICT_PATTERN);
                if (TokenAgreementPrepNounRule.hasVidmPosTag(cases, state.nounAdjIndirTokenReadings)) {
                    TokenAgreementVerbNounExceptionHelper.logException();
                    return true;
                }
                v2pos = LemmaHelper.tokenSearch(tokens, v2pos + 1, ADV_PREDICT_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.FORWARD);
            }
        }
        if (nounAdjPos < tokens.length - 1 && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && (v2pos = LemmaHelper.tokenSearch(tokens, state.nounPos + 1, PosTagHelper.ADJ_V_NAZ_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.FORWARD)) >= 0 && v2pos <= state.nounPos + 3 && CaseGovernmentHelper.hasCaseGovernment(tokens[v2pos], PosTagHelper.ADJ_V_NAZ_PATTERN, "v_inf")) {
            String genders1 = PosTagHelper.getGenders(tokens[nounAdjPos], "(noun|adj).*v_naz.*");
            genders2 = PosTagHelper.getGenders(tokens[v2pos], PosTagHelper.ADJ_V_NAZ_PATTERN);
            if (genders1.matches(".*[" + genders2 + "].*")) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
        }
        if (PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && PosTagHelper.hasPosTag(tokens[nounAdjPos], PosTagHelper.ADJ_V_NAZ_PATTERN) && CaseGovernmentHelper.hasCaseGovernment(tokens[nounAdjPos], PosTagHelper.ADJ_V_NAZ_PATTERN, "v_inf")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 1 && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf")) {
            int v2pos2;
            int lookupPos = state.verbPos - 1;
            if (verbPos > 3 && LemmaHelper.hasLemma(tokens[verbPos - 1], Arrays.asList("\u0456", "\u0439", "\u0442\u0430")) && PosTagHelper.hasPosTagPart(tokens[verbPos - 2], ":inf")) {
                lookupPos = verbPos - 3;
            }
            if ((v2pos2 = LemmaHelper.tokenSearch(tokens, lookupPos, PosTagHelper.VERB_ADVP_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.REVERSE)) >= 0 && v2pos2 >= state.verbPos - 5 && (CaseGovernmentHelper.hasCaseGovernment(tokens[v2pos2], PosTagHelper.VERB_ADVP_PATTERN, "v_inf") || tokens[verbPos].getCleanToken().matches("(\u043f\u043e)?\u0457\u0441\u0442\u0438"))) {
                if (TokenAgreementVerbNounExceptionHelper.agrees(tokens[v2pos2], state.nounAdjNazInflections, state.nounAdjIndirTokenReadings)) {
                    TokenAgreementVerbNounExceptionHelper.logException();
                    return true;
                }
                if (PosTagHelper.hasPosTag(tokens[v2pos2], Pattern.compile("verb.*:p($|:.*)")) && PosTagHelper.hasPosTag(tokens[state.nounPos], Pattern.compile(".*v_naz.*"))) {
                    TokenAgreementVerbNounExceptionHelper.logException();
                    return true;
                }
            }
        }
        if (verbPos > 1 && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf")) {
            v2pos = LemmaHelper.tokenSearch(tokens, state.verbPos - 1, ADV_PREDICT_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.REVERSE);
            while (v2pos >= 0 && v2pos >= state.verbPos - 3) {
                if (PosTagHelper.hasPosTag(tokens[v2pos], Pattern.compile("noninfl.&predic.*")) && PosTagHelper.hasPosTagPart(tokens[state.nounPos], "v_naz")) {
                    TokenAgreementVerbNounExceptionHelper.logException();
                    return true;
                }
                Set<String> cases = CaseGovernmentHelper.getCaseGovernments(tokens[v2pos], ADV_PREDICT_PATTERN);
                if (TokenAgreementPrepNounRule.hasVidmPosTag(cases, state.nounAdjIndirTokenReadings)) {
                    TokenAgreementVerbNounExceptionHelper.logException();
                    return true;
                }
                v2pos = LemmaHelper.tokenSearch(tokens, v2pos - 1, ADV_PREDICT_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.REVERSE);
            }
        }
        if (verbPos > 1 && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && PosTagHelper.hasPosTagPart(tokens[nounAdjPos], "v_naz")) {
            if (tokens[verbPos - 1].getCleanToken().toLowerCase().matches("\u0437\u043c\u043e\u0437\u0456|\u0437\u043c\u043e\u0433\u0443|\u0441\u0438\u043b\u0456|\u0441\u0438\u043b\u0430\u0445")) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
            v2pos = LemmaHelper.tokenSearch(tokens, state.verbPos - 1, PosTagHelper.ADJ_V_NAZ_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.REVERSE);
            if (v2pos >= 0 && v2pos >= state.verbPos - 3 && CaseGovernmentHelper.hasCaseGovernment(tokens[v2pos], PosTagHelper.ADJ_V_NAZ_PATTERN, "v_inf")) {
                String genders1 = PosTagHelper.getGenders(tokens[nounAdjPos], "(noun|adj|numr).*v_naz.*");
                genders2 = PosTagHelper.getGenders(tokens[v2pos], PosTagHelper.ADJ_V_NAZ_PATTERN);
                if (genders1.matches(".*[" + genders2 + "].*")) {
                    TokenAgreementVerbNounExceptionHelper.logException();
                    return true;
                }
            }
        }
        if (verbPos > 1 && LemmaHelper.hasLemma(tokens[verbPos], "\u0431\u0443\u0442\u0438") && PosTagHelper.hasPosTag(tokens[verbPos - 1], "adj:.:v_naz.*") && CaseGovernmentHelper.hasCaseGovernment(tokens[verbPos - 1], "v_rod") && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("(adj|noun).*v_rod.*"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 1 && LemmaHelper.hasLemma(tokens[verbPos], "\u0431\u0443\u0442\u0438") && PosTagHelper.hasPosTag(tokens[verbPos - 1], "verb.*impers.*") && TokenAgreementVerbNounExceptionHelper.agrees(tokens[verbPos - 1], state.nounAdjNazInflections, state.nounAdjIndirTokenReadings)) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 1 && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && (PosTagHelper.hasPosTagPart(tokens[nounAdjPos], "v_dav") || PosTagHelper.hasPosTagPart(tokens[nounAdjPos], "v_rod") || PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("adj:.:v_naz.*"))) && (v2pos = LemmaHelper.tokenSearch(tokens, state.verbPos - 1, PosTagHelper.NOUN_V_NAZ_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.REVERSE)) >= 0 && v2pos >= state.verbPos - 3 && CaseGovernmentHelper.hasCaseGovernment(tokens[v2pos], PosTagHelper.NOUN_V_NAZ_PATTERN, "v_inf")) {
            if (PosTagHelper.hasPosTagPart(tokens[nounAdjPos], "v_dav") && LemmaHelper.hasLemma(tokens[verbPos], Pattern.compile(".*\u0432\u0447\u0438\u0442\u0438(\u0441\u044f)?"))) {
                return false;
            }
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (verbPos > 1 && CaseGovernmentHelper.hasCaseGovernment(state.verbAnalyzedTokenReadings, PosTagHelper.VERB_PATTERN, "v_inf") && (v2pos = LemmaHelper.tokenSearch(tokens, state.verbPos - 1, PosTagHelper.VERB_PATTERN, null, Pattern.compile("[a-z].*"), LemmaHelper.Dir.REVERSE)) >= 0 && v2pos >= state.verbPos - 3 && PosTagHelper.hasPosTagPart(tokens[v2pos], ":inf") && TokenAgreementVerbNounExceptionHelper.agrees(tokens[v2pos], state.nounAdjNazInflections, state.nounAdjIndirTokenReadings)) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 2 && PosTagHelper.hasPosTag(tokens[verbPos], Pattern.compile("verb.*:p(:.*)?")) && PosTagHelper.hasPosTagPart(tokens[nounAdjPos], ":v_naz")) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        if (nounAdjPos < tokens.length - 2 && PosTagHelper.hasPosTag(tokens[nounAdjPos], Pattern.compile("adj:.:v_rod(?!.*pron).*")) && PosTagHelper.hasPosTag(tokens[nounAdjPos + 1], Pattern.compile("noun:.*v_rod(?!.*pron).*")) && PosTagHelper.hasPosTag(tokens[nounAdjPos + 2], Pattern.compile("(noun|adj)(?!.*pron).*"))) {
            List readings = tokens[nounAdjPos + 2].getReadings();
            List<AnalyzedToken> readingsVnaz = readings.stream().filter(r -> PosTagHelper.hasPosTagPart(r, "v_naz")).collect(Collectors.toList());
            List<VerbInflectionHelper.Inflection> nounAdjNazInflectionsVnaz = VerbInflectionHelper.getNounInflections(readingsVnaz);
            nounAdjNazInflectionsVnaz.addAll(VerbInflectionHelper.getAdjInflections(readingsVnaz));
            List<AnalyzedToken> readingsIndir = readings.stream().filter(r -> !PosTagHelper.hasPosTagPart(r, "v_naz")).collect(Collectors.toList());
            if (TokenAgreementVerbNounExceptionHelper.agrees(tokens[verbPos], nounAdjNazInflectionsVnaz, readingsIndir)) {
                TokenAgreementVerbNounExceptionHelper.logException();
                return true;
            }
        }
        if (verbPos > 2 && PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") && PosTagHelper.hasPosTagStart(tokens[verbPos - 2], "verb") && (LemmaHelper.hasLemma(tokens[verbPos - 1], Arrays.asList("\u0431", "\u0431\u0438")) || PosTagHelper.hasPosTag(tokens[verbPos - 1], Pattern.compile("adv(?!p).*")) || LemmaHelper.hasLemma(tokens[verbPos - 2], Arrays.asList("\u043c\u0430\u0442\u0438"), "verb"))) {
            TokenAgreementVerbNounExceptionHelper.logException();
            return true;
        }
        return false;
    }

    private static boolean agrees(AnalyzedTokenReadings verbTokenReadings, List<VerbInflectionHelper.Inflection> nounAdjNazInflections, List<AnalyzedToken> nounAdjIndirTokenReadings) {
        Set<String> cases;
        List<VerbInflectionHelper.Inflection> verbInflections;
        if (nounAdjNazInflections != null && nounAdjNazInflections.size() > 0 && !Collections.disjoint(verbInflections = VerbInflectionHelper.getVerbInflections(verbTokenReadings.getReadings()), nounAdjNazInflections)) {
            return true;
        }
        return nounAdjIndirTokenReadings.size() > 0 && (cases = CaseGovernmentHelper.getCaseGovernments(verbTokenReadings, PosTagHelper.VERB_ADVP_PATTERN)).size() > 0 && TokenAgreementPrepNounRule.hasVidmPosTag(cases, nounAdjIndirTokenReadings);
    }

    private static void logException() {
        if (logger.isDebugEnabled()) {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
            logger.debug("exception: " + stackTraceElement.getLineNumber());
        }
    }

    static int isExceptionHardAdjNoun(AnalyzedTokenReadings[] tokens, int i, TokenAgreementVerbNounRule.State state) {
        String cleanTokenLower = tokens[i].getCleanToken().toLowerCase();
        if (cleanTokenLower.matches("[0-9]{4}-.+|\u043d\u0456\u043a\u043e\u043c\u0443|\u043d\u0456\u0447\u043e\u043c\u0443|\u043d\u0456\u0447\u043e\u0433\u043e|\u043d\u0456\u043a\u043e\u0433\u043e|\u043d\u0456\u0447\u0438\u043c|\u0440\u0435\u0448\u0442\u0443|\u043d\u0456\u0449\u043e")) {
            return 1;
        }
        if (LemmaHelper.hasLemma(tokens[i], Arrays.asList("\u0441\u0430\u043c", "\u0441\u0430\u043c\u0438\u0439", "\u0441\u0435\u0431\u0435", "\u043e\u0434\u0438\u043d"))) {
            return 1;
        }
        if (i < tokens.length - 1 && PosTagHelper.hasPosTag(tokens[i], Pattern.compile("adj:m:v_rod.*")) && tokens[i + 1].getCleanToken().matches("\u0440\u043e\u0434\u0443|\u0440\u0430\u0437\u0443|\u0442\u0438\u043f\u0443|\u0448\u0442\u0438\u0431\u0443|\u0440\u043e\u0437\u043c\u0456\u0440\u0443")) {
            return 1;
        }
        if (i < tokens.length - 1 && PosTagHelper.hasPosTag(tokens[i], Pattern.compile("(adj|numr):[mp]:v_oru.*")) && tokens[i + 1].getCleanToken().matches("\u0447\u0438\u043d\u043e\u043c|\u0441\u043f\u043e\u0441\u043e\u0431\u043e\u043c|\u0440\u043e\u0431\u043e\u043c|\u0445\u043e\u0434\u043e\u043c|\u0448\u043b\u044f\u0445\u043e\u043c|\u043a\u043e\u0448\u0442\u043e\u043c")) {
            return 1;
        }
        if (i < tokens.length - 1 && PosTagHelper.hasPosTag(tokens[i], Pattern.compile("adj:f:v_oru.*")) && tokens[i + 1].getCleanToken().matches("\u043c\u0456\u0440\u043e\u044e")) {
            return 1;
        }
        if (i < tokens.length - 1 && PosTagHelper.hasPosTag(tokens[i], Pattern.compile("adj:f:v_rod.*")) && tokens[i + 1].getCleanToken().matches("\u044f\u043a\u043e\u0441\u0442\u0456|\u0441\u0432\u0456\u0436\u043e\u0441\u0442\u0456")) {
            return 1;
        }
        if (i < tokens.length - 1 && tokens[i + 1].getCleanToken().toLowerCase().matches("\u0442\u0435\u043c\u043f\u0430\u043c\u0438")) {
            return 1;
        }
        if (new SearchHelper.Match().tokenLine("\u043d\u0435 \u0442\u0435 \u0449\u043e\u0431").mNow(tokens, i) == i + 2 || new SearchHelper.Match().tokenLine("\u043d\u0435 \u0442\u0435 \u0449\u043e").mNow(tokens, i) == i + 2 || new SearchHelper.Match().tokenLine("\u043d\u0435 \u043e\u0441\u0442\u0430\u043d\u043d\u044c\u043e\u044e \u0447\u0435\u0440\u0433\u043e\u044e").mNow(tokens, i) == i + 2) {
            return 3;
        }
        if (new SearchHelper.Match().tokenLine("\u043d\u0435 \u0442\u0435, \u0449\u043e").mNow(tokens, i) == i + 3) {
            return 4;
        }
        if (new SearchHelper.Match().tokenLine("\u0441\u0432\u0456\u0442 \u0437\u0430 \u043e\u0447\u0456").mNow(tokens, i) == i + 2) {
            return 3;
        }
        if (new SearchHelper.Match().tokenLine("\u043d\u0456 \u0441\u0432\u0456\u0442 \u043d\u0456").mNow(tokens, i) == i + 2) {
            return 3;
        }
        if (new SearchHelper.Match().tokenLine("\u043a\u0443\u0434\u0438 \u043e\u0447\u0456").mNow(tokens, i) == i + 1) {
            return 3;
        }
        if (new SearchHelper.Match().tokenLine("\u043a\u0443\u0434\u0438 \u043e\u0447\u0456").mNow(tokens, i) == i + 1) {
            return 3;
        }
        if (new SearchHelper.Match().tokenLine("\u0441\u0442\u0430\u043d\u043e\u043c \u043d\u0430").mNow(tokens, i) == i + 1) {
            return 3;
        }
        if (new SearchHelper.Match().tokenLine("\u0441\u0442\u0440\u0430\u0445 \u044f\u043a").mNow(tokens, i) == i + 1) {
            return 3;
        }
        if (new SearchHelper.Match().tokenLine("\u0436\u0430\u0445 \u044f\u043a").mNow(tokens, i) == i + 1) {
            return 3;
        }
        if (tokens[i - 1].getCleanToken().equals("\u043d\u0435") && tokens[i].getCleanToken().matches("\u0443\u043a\u0430\u0437|\u0432\u0430\u0440\u0456\u0430\u043d\u0442|\u0440\u0456\u0434\u043a\u0456\u0441\u0442\u044c")) {
            return 0;
        }
        return -1;
    }

    static int isExceptionSkip(AnalyzedTokenReadings[] tokens, int i) {
        String cleanTokenLower = tokens[i].getCleanToken().toLowerCase();
        if (PosTagHelper.hasPosTagAll(tokens[i].getReadings(), Pattern.compile("(part|adv).*")) && !LemmaHelper.ADV_QUANT_PATTERN.matcher(cleanTokenLower).matches() && !PARTS_CANT_SKIP.matcher(cleanTokenLower).matches()) {
            return 0;
        }
        if (PosTagHelper.hasPosTag((Collection<AnalyzedToken>)tokens[i].getReadings(), Pattern.compile("part.*")) && PosTagHelper.hasPosTagAll(tokens[i].getReadings(), Pattern.compile("(part|conj|adv).*")) && !PARTS_CANT_SKIP.matcher(cleanTokenLower).matches()) {
            return 0;
        }
        return -1;
    }

    static RuleException isExceptionVerb(AnalyzedTokenReadings[] tokens, int i, TokenAgreementVerbNounRule.State state) {
        if (LemmaHelper.hasLemma(tokens[i], Arrays.asList("\u043c\u0443\u0441\u0438\u0442\u0438"))) {
            return new RuleException(RuleException.Type.exception);
        }
        String cleanTokenLower = tokens[i].getCleanToken().toLowerCase();
        if (cleanTokenLower.equals("\u043c\u043e\u0436\u0435")) {
            return new RuleException(RuleException.Type.exception);
        }
        if (i > 1 && (cleanTokenLower.matches("\u0454") || LemmaHelper.hasLemma(tokens[i], "\u043c\u043e\u0433\u0442\u0438")) && tokens[i - 1].getCleanToken().equalsIgnoreCase("\u044f\u043a")) {
            return new RuleException(RuleException.Type.exception);
        }
        if (i < tokens.length - 2 && cleanTokenLower.equals("\u0431\u0443\u0434\u044c") && tokens[i + 1].getCleanToken().equalsIgnoreCase("\u0442\u043e")) {
            return new RuleException(RuleException.Type.exception);
        }
        if (i > 1 && i < tokens.length - 1 && tokens[i].getCleanToken().toLowerCase().equals("\u0441\u043f\u0430\u0442\u0438") && LemmaHelper.hasLemma(tokens[i - 1], Pattern.compile("(\u043f\u043e|\u0432)?\u043a\u043b\u0430(\u0441\u0442\u0438|\u0432\u0448\u0438)"))) {
            return new RuleException(RuleException.Type.skip);
        }
        if (i > 1 && state != null) {
            if (cleanTokenLower.matches("\u0431\u0443\u0432|\u0431\u0443\u043b\u043e") && PosTagHelper.hasPosTag(tokens[i - 1], Pattern.compile("verb.*:past:m.*"))) {
                return new RuleException(0);
            }
            if (cleanTokenLower.matches("\u0431\u0443\u043b\u0438|\u0431\u0443\u043b\u043e") && PosTagHelper.hasPosTag(tokens[i - 1], Pattern.compile("verb.*:past:p.*"))) {
                return new RuleException(0);
            }
            if (cleanTokenLower.equals("\u0431\u0443\u043b\u043e") && PosTagHelper.hasPosTag(tokens[i - 1], Pattern.compile("verb.*:past:n.*"))) {
                return new RuleException(0);
            }
            if (cleanTokenLower.matches("\u0431\u0443\u043b\u0430|\u0431\u0443\u043b\u043e") && PosTagHelper.hasPosTag(tokens[i - 1], Pattern.compile("verb.*:past:f.*"))) {
                return new RuleException(0);
            }
        }
        if (i > 1 && cleanTokenLower.matches("\u0431\u0443\u043b\u043e|\u0431\u0443\u0434\u0435") && state != null && PosTagHelper.hasPosTag(tokens[i - 1], Pattern.compile("verb.*(impers|predic).*"))) {
            return new RuleException(0);
        }
        return new RuleException(RuleException.Type.none);
    }
}

