/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.zh.ChineseConfusionProbabilityRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.zh.ChineseTagger;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.zh.ChineseSentenceTokenizer;
import org.languagetool.tokenizers.zh.ChineseWordTokenizer;

public class Chinese
extends Language
implements AutoCloseable {
    private LuceneLanguageModel languageModel;

    public String getShortCode() {
        return "zh";
    }

    public String getName() {
        return "Chinese";
    }

    public String[] getCountries() {
        return new String[]{"CN"};
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Tao Lin")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) {
        return Arrays.asList(new DoublePunctuationRule(messages), new MultipleWhitespaceRule(messages, (Language)this));
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new ChineseTagger();
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new ChineseWordTokenizer();
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new ChineseSentenceTokenizer();
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        return this.initLanguageModel(indexDir, (LanguageModel)this.languageModel);
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return Arrays.asList(new Rule[]{new ChineseConfusionProbabilityRule(messages, languageModel, this)});
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }
}

