/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.server.DatabaseLogEntry;

class DatabaseRuleMatchLogEntry
extends DatabaseLogEntry {
    private final List<RuleMatchInfo> matches = new ArrayList<RuleMatchInfo>();

    DatabaseRuleMatchLogEntry(Map<String, Integer> matchCounts) {
        for (Map.Entry<String, Integer> match : matchCounts.entrySet()) {
            this.matches.add(new RuleMatchInfo(match.getKey(), match.getValue()));
        }
    }

    public int getMatchCount() {
        return this.matches.size();
    }

    @Override
    public Map<Object, Object> getMapping() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("matches", this.matches);
        return map;
    }

    @Override
    public String getMappingIdentifier() {
        return "org.languagetool.server.LogMapper.ruleMatch";
    }

    static class RuleMatchInfo {
        String ruleId;
        int matchCount;

        RuleMatchInfo(String rule_id, int match_count) {
            this.ruleId = StringUtils.abbreviate((String)rule_id, (int)128);
            this.matchCount = match_count;
        }
    }
}

