/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job;

import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.dbflute.bhv.proposal.callback.ExecutedSqlCounter;
import org.dbflute.bhv.proposal.callback.TraceableSqlAdditionalInfoProvider;
import org.dbflute.hook.AccessContext;
import org.dbflute.hook.CallbackContext;
import org.dbflute.hook.SqlFireHook;
import org.dbflute.hook.SqlResultHandler;
import org.dbflute.hook.SqlStringFilter;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfTraceViewUtil;
import org.dbflute.util.DfTypeUtil;
import org.dbflute.util.Srl;
import org.lastaflute.core.exception.ExceptionTranslator;
import org.lastaflute.core.magic.ThreadCacheContext;
import org.lastaflute.core.mail.PostedMailCounter;
import org.lastaflute.core.smartdeploy.ManagedHotdeploy;
import org.lastaflute.core.util.ContainerUtil;
import org.lastaflute.db.dbflute.accesscontext.AccessContextArranger;
import org.lastaflute.db.dbflute.accesscontext.AccessContextResource;
import org.lastaflute.db.dbflute.accesscontext.PreparedAccessContext;
import org.lastaflute.db.dbflute.callbackcontext.traceablesql.RomanticTraceableSqlFireHook;
import org.lastaflute.db.dbflute.callbackcontext.traceablesql.RomanticTraceableSqlResultHandler;
import org.lastaflute.db.dbflute.callbackcontext.traceablesql.RomanticTraceableSqlStringFilter;
import org.lastaflute.db.jta.romanticist.SavedTransactionMemories;
import org.lastaflute.db.jta.romanticist.TransactionMemoriesProvider;
import org.lastaflute.job.JobManager;
import org.lastaflute.job.LaJob;
import org.lastaflute.job.LaJobRuntime;
import org.lastaflute.job.LaScheduledJob;
import org.lastaflute.job.exception.JobStoppedException;
import org.lastaflute.job.key.LaJobKey;
import org.lastaflute.job.log.JobErrorLog;
import org.lastaflute.job.log.JobErrorLogHook;
import org.lastaflute.job.log.JobErrorResource;
import org.lastaflute.job.log.JobErrorStackTracer;
import org.lastaflute.job.log.JobHistoryHook;
import org.lastaflute.job.log.JobNoticeLog;
import org.lastaflute.job.log.JobNoticeLogHook;
import org.lastaflute.job.subsidiary.CrossVMHook;
import org.lastaflute.job.subsidiary.RunnerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaJobRunner {
    private static final Logger logger = LoggerFactory.getLogger(LaJobRunner.class);
    protected static final String LF = "\n";
    protected static final String EX_IND = "  ";
    protected static final DateTimeFormatter beginTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    @Resource
    private JobManager jobManager;
    @Resource
    private ExceptionTranslator exceptionTranslator;
    protected AccessContextArranger accessContextArranger;
    protected CrossVMHook crossVMHook;
    protected JobErrorLogHook errorLogHook;
    protected JobHistoryHook historyHook;
    protected JobNoticeLogHook noticeLogHook;
    protected int jobHistoryLimit = 100;

    public LaJobRunner useAccessContext(AccessContextArranger oneArgLambda) {
        this.assertArgumentNotNull("oneArgLambda(accessContextArranger)", oneArgLambda);
        this.accessContextArranger = oneArgLambda;
        return this;
    }

    public LaJobRunner useCrossVMHook(CrossVMHook crossVMHook) {
        this.assertArgumentNotNull("crossVMHook", crossVMHook);
        this.crossVMHook = crossVMHook;
        return this;
    }

    public LaJobRunner useErrorLogHook(JobErrorLogHook errorLogHook) {
        this.assertArgumentNotNull("errorLogHook", errorLogHook);
        this.errorLogHook = errorLogHook;
        return this;
    }

    public LaJobRunner useHistoryHook(JobHistoryHook historyHook) {
        this.assertArgumentNotNull("historyHook", historyHook);
        this.historyHook = historyHook;
        return this;
    }

    public LaJobRunner useNoticeLogHook(JobNoticeLogHook noticeLogHook) {
        if (noticeLogHook == null) {
            throw new IllegalArgumentException("The argument 'noticeLogHook' should not be null.");
        }
        this.noticeLogHook = noticeLogHook;
        return this;
    }

    public LaJobRunner limitJobHistory(int jobHistoryLimit) {
        if (jobHistoryLimit < this.getJobHistoryMinimumLimit()) {
            throw new IllegalArgumentException("The argument 'jobHistoryLimit' should not be over or equal 10: " + jobHistoryLimit);
        }
        this.jobHistoryLimit = jobHistoryLimit;
        return this;
    }

    protected int getJobHistoryMinimumLimit() {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunnerResult run(Class<? extends LaJob> jobType, Supplier<LaJobRuntime> runtimeSupplier) {
        if (this.isPlainlyRun()) {
            LaJobRuntime runtime = runtimeSupplier.get();
            this.debugFw(runtime, "...Calling doRun() of job runner plainly", new Object[0]);
            return this.doRun(jobType, runtime);
        }
        ClassLoader originalLoader = this.startHotdeploy();
        try {
            LaJobRuntime runtime = runtimeSupplier.get();
            this.debugFw(runtime, "...Calling doRun() of job runner as hotdeploy: {}", originalLoader);
            RunnerResult runnerResult = this.doRun(jobType, runtime);
            return runnerResult;
        }
        finally {
            this.stopHotdeploy(originalLoader);
        }
    }

    protected boolean isPlainlyRun() {
        return !this.isHotdeployEnabled() || this.isSuppressHotdeploy();
    }

    protected boolean isHotdeployEnabled() {
        return ManagedHotdeploy.isHotdeploy();
    }

    protected boolean isSuppressHotdeploy() {
        return false;
    }

    protected ClassLoader startHotdeploy() {
        return ManagedHotdeploy.start();
    }

    protected void stopHotdeploy(ClassLoader originalLoader) {
        ManagedHotdeploy.stop((ClassLoader)originalLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RunnerResult doRun(Class<? extends LaJob> jobType, LaJobRuntime runtime) {
        this.arrangeThreadCacheContext(runtime);
        this.arrangePreparedAccessContext(runtime);
        this.arrangeCallbackContext(runtime);
        Object variousPreparedObj = this.prepareVariousContext(runtime);
        long before = this.showRunning(runtime);
        Throwable cause = null;
        try {
            this.debugFw(runtime, "...Calling try clause of job runner", new Object[0]);
            this.hookBefore(runtime);
            this.debugFw(runtime, "...Calling actuallyRun() of job runner", new Object[0]);
            this.actuallyRun(jobType, runtime);
            this.debugFw(runtime, "...Calling finally clause of job runner", new Object[0]);
            this.hookFinally(runtime, (OptionalThing<Throwable>)OptionalThing.ofNullable((Object)cause, () -> {
                throw new IllegalStateException("Not found the cause: " + runtime);
            }));
            this.showFinishing(runtime, before, cause);
            this.clearVariousContext(runtime, variousPreparedObj);
            this.clearPreparedAccessContext();
            this.clearCallbackContext();
            this.clearThreadCacheContext();
        }
        catch (Throwable e) {
            try {
                Throwable filtered;
                this.debugFw(runtime, "...Calling catch clause of job runner: {}", e.getClass().getSimpleName());
                cause = filtered = this.filterCause(e);
                this.showJobException(runtime, before, filtered);
                this.debugFw(runtime, "...Calling finally clause of job runner", new Object[0]);
                this.hookFinally(runtime, (OptionalThing<Throwable>)OptionalThing.ofNullable((Object)cause, () -> {
                    throw new IllegalStateException("Not found the cause: " + runtime);
                }));
                this.showFinishing(runtime, before, cause);
                this.clearVariousContext(runtime, variousPreparedObj);
                this.clearPreparedAccessContext();
                this.clearCallbackContext();
                this.clearThreadCacheContext();
            }
            catch (Throwable throwable) {
                this.debugFw(runtime, "...Calling finally clause of job runner", new Object[0]);
                this.hookFinally(runtime, (OptionalThing<Throwable>)OptionalThing.ofNullable(cause, () -> {
                    throw new IllegalStateException("Not found the cause: " + runtime);
                }));
                this.showFinishing(runtime, before, cause);
                this.clearVariousContext(runtime, variousPreparedObj);
                this.clearPreparedAccessContext();
                this.clearCallbackContext();
                this.clearThreadCacheContext();
                throw throwable;
            }
        }
        this.debugFw(runtime, "...Calling createRunnerResult() of job runner", new Object[0]);
        return this.createRunnerResult(runtime, cause);
    }

    protected void hookBefore(LaJobRuntime runtime) {
    }

    protected void actuallyRun(Class<? extends LaJob> jobType, LaJobRuntime runtime) {
        LaJob job = this.getJobComponent(jobType);
        job.run(runtime);
    }

    protected LaJob getJobComponent(Class<? extends LaJob> jobType) {
        return (LaJob)ContainerUtil.getComponent(this.resolveJobType(jobType));
    }

    protected Class<? extends LaJob> resolveJobType(Class<? extends LaJob> jobType) {
        if (ManagedHotdeploy.isThreadContextHotdeploy()) {
            return this.reloadJobTypeByContextClassLoader(jobType);
        }
        return jobType;
    }

    protected Class<? extends LaJob> reloadJobTypeByContextClassLoader(Class<? extends LaJob> jobType) {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            return Class.forName(jobType.getName(), true, contextClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Not found the job: " + jobType, e);
        }
    }

    protected void hookFinally(LaJobRuntime runtime, OptionalThing<Throwable> cause) {
    }

    protected RunnerResult createRunnerResult(LaJobRuntime runtime, Throwable cause) {
        return RunnerResult.asExecuted(runtime.getBeginTime(), runtime.getEndTitleRoll(), (OptionalThing<Throwable>)OptionalThing.ofNullable((Object)cause, () -> {
            throw new IllegalStateException("Not found the cause.");
        }), runtime.isNextTriggerSuppressed());
    }

    protected long showRunning(LaJobRuntime runtime) {
        JobNoticeLog.log(runtime.getNoticeLogLevel(), () -> this.buildRunningJobLogMessage(runtime));
        if (this.noticeLogHook != null) {
            this.noticeLogHook.hookRunning(runtime, this.buildRunningJobLogMessage(runtime));
        }
        return System.currentTimeMillis();
    }

    protected String buildRunningJobLogMessage(LaJobRuntime runtime) {
        StringBuilder sb = new StringBuilder();
        sb.append("#flow #job ...Running job: ");
        sb.append(runtime.toCronMethodDisp());
        this.buildProcessHashIfNeeds(sb);
        return sb.toString();
    }

    protected void showFinishing(LaJobRuntime runtime, long before, Throwable cause) {
        String msg = this.buildFinishingMsg(runtime, before, cause);
        if (this.noticeLogHook != null) {
            this.noticeLogHook.hookFinishing(runtime, msg, (OptionalThing<Throwable>)OptionalThing.ofNullable((Object)cause, () -> {
                throw new IllegalStateException("Not found the cause: " + runtime);
            }));
        }
        JobNoticeLog.log(runtime.getNoticeLogLevel(), () -> msg);
    }

    protected String buildFinishingMsg(LaJobRuntime runtime, long before, Throwable cause) {
        long after = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        sb.append("#flow #job ...Finishing job: ").append(runtime.toRunMethodDisp());
        this.buildProcessHashIfNeeds(sb);
        sb.append(LF).append("[Job Result]");
        this.buildBeginTimeIfNeeds(sb);
        sb.append(LF).append(" performanceView: ").append(this.toPerformanceView(before, after));
        this.extractSqlCounter().ifPresent(counter -> sb.append(LF).append(" sqlCount: ").append(counter.toLineDisp()));
        this.extractMailCounter().ifPresent(counter -> sb.append(LF).append(" mailCount: ").append(counter.toLineDisp()));
        this.extractRemoteApiCounter().ifPresent(counter -> sb.append(LF).append(" remoteApiCount: ").append((String)counter.get()));
        sb.append(LF).append(" runtime: ").append(runtime);
        this.buildTriggeredNextJobExp(runtime).ifPresent(exp -> sb.append(LF).append(" triggeredNextJob: ").append((String)exp));
        if (runtime.isNextTriggerSuppressed()) {
            sb.append(LF).append(" suppressNextTrigger: true");
        }
        runtime.getEndTitleRoll().ifPresent(roll -> {
            sb.append(LF).append(" endTitleRoll:");
            roll.getDataMap().forEach((key, value) -> sb.append(LF).append("   ").append((String)key).append(": ").append(value));
        });
        if (cause != null) {
            sb.append(LF).append(" cause: ");
            sb.append(cause.getClass().getSimpleName()).append(" *Read the exception message!");
            sb.append(" ").append(Integer.toHexString(cause.hashCode()));
        }
        sb.append(LF).append(LF);
        return sb.toString();
    }

    protected void buildBeginTimeIfNeeds(StringBuilder sb) {
        Object beginTime = this.findBeginTime();
        if (beginTime != null) {
            sb.append(LF).append(" beginTime: ");
            String beginExp = beginTime instanceof LocalDateTime ? beginTimeFormatter.format((LocalDateTime)beginTime) : beginTime.toString();
            sb.append(beginExp);
        }
    }

    protected void buildProcessHashIfNeeds(StringBuilder sb) {
        Object processHash = this.findProcessHash();
        if (processHash != null) {
            sb.append(" #").append(processHash);
        }
    }

    protected String toPerformanceView(long before, long after) {
        return DfTraceViewUtil.convertToPerformanceView((long)(after - before));
    }

    protected OptionalThing<String> buildTriggeredNextJobExp(LaJobRuntime runtime) {
        LaJobKey jobKey = runtime.getJobKey();
        String exp = (String)this.jobManager.findJobByKey(jobKey).map(job -> {
            Set<LaJobKey> triggeredJobKeyList = job.getTriggeredJobKeySet();
            if (!triggeredJobKeyList.isEmpty()) {
                List dispList = triggeredJobKeyList.stream().map(triggeredJobKey -> (String)this.jobManager.findJobByKey((LaJobKey)triggeredJobKey).map(triggeredJob -> triggeredJob.toIdentityDisp()).orElseGet(() -> "(*Not found the triggered job: " + triggeredJobKey + ")")).collect(Collectors.toList());
                return dispList.size() == 1 ? (String)dispList.get(0) : dispList.toString();
            }
            return "";
        }).orElseGet(() -> "(*Not found the current job: " + jobKey + ")");
        return OptionalThing.ofNullable((Object)(!exp.isEmpty() ? exp : null), () -> {
            throw new IllegalStateException("Not found the triggeredNextJob expression: " + exp);
        });
    }

    protected void arrangeThreadCacheContext(LaJobRuntime runtime) {
        ThreadCacheContext.initialize();
        LocalDateTime beginTime = runtime.getBeginTime();
        this.registerBeginTime(beginTime);
        this.registerProcessHash(this.generateProcessHash(beginTime));
        ThreadCacheContext.registerRequestPath((String)this.buildRequestPath(runtime));
        ThreadCacheContext.registerEntryMethod((Method)runtime.getRunMethod());
    }

    protected String generateProcessHash(LocalDateTime beginTime) {
        String bestEffortUnique = beginTime.toString() + Thread.currentThread().getName();
        return Integer.toHexString(bestEffortUnique.hashCode());
    }

    protected String buildRequestPath(LaJobRuntime runtime) {
        return runtime.getJobType().getSimpleName();
    }

    protected Object findBeginTime() {
        return ThreadCacheContext.getObject((String)"fw:beginTime");
    }

    protected void registerBeginTime(LocalDateTime beginTime) {
        ThreadCacheContext.setObject((String)"fw:beginTime", (Object)beginTime);
    }

    protected Object findProcessHash() {
        return ThreadCacheContext.getObject((String)"fw:processHash");
    }

    protected void registerProcessHash(String processHash) {
        ThreadCacheContext.setObject((String)"fw:processHash", (Object)processHash);
    }

    protected void clearThreadCacheContext() {
        ThreadCacheContext.clear();
    }

    protected void arrangePreparedAccessContext(LaJobRuntime runtime) {
        if (this.accessContextArranger == null) {
            return;
        }
        AccessContextResource resource = this.createAccessContextResource(runtime);
        AccessContext context = this.accessContextArranger.arrangePreparedAccessContext(resource);
        if (context == null) {
            String msg = "Cannot return null from access context arranger: " + this.accessContextArranger + " runtime=" + runtime;
            throw new IllegalStateException(msg);
        }
        PreparedAccessContext.setAccessContextOnThread((AccessContext)context);
    }

    protected AccessContextResource createAccessContextResource(LaJobRuntime runtime) {
        String classTitle = DfTypeUtil.toClassTitle(runtime.getJobType());
        Method runMethod = runtime.getRunMethod();
        LinkedHashMap<String, Object> runtimeAttributeMap = new LinkedHashMap<String, Object>(runtime.getParameterMap());
        return new AccessContextResource(classTitle, runMethod, runtimeAttributeMap);
    }

    protected void clearPreparedAccessContext() {
        PreparedAccessContext.clearAccessContextOnThread();
    }

    protected void arrangeCallbackContext(LaJobRuntime runtime) {
        CallbackContext.setSqlFireHookOnThread((SqlFireHook)this.createSqlFireHook(runtime));
        CallbackContext.setSqlStringFilterOnThread((SqlStringFilter)this.createSqlStringFilter(runtime));
        CallbackContext.setSqlResultHandlerOnThread((SqlResultHandler)this.createSqlResultHandler());
    }

    protected SqlFireHook createSqlFireHook(LaJobRuntime runtime) {
        return this.newRomanticTraceableSqlFireHook();
    }

    protected RomanticTraceableSqlFireHook newRomanticTraceableSqlFireHook() {
        return new RomanticTraceableSqlFireHook();
    }

    protected SqlStringFilter createSqlStringFilter(LaJobRuntime runtime) {
        return this.newRomanticTraceableSqlStringFilter(runtime.getRunMethod(), () -> this.buildSqlMarkingAdditionalInfo());
    }

    protected String buildSqlMarkingAdditionalInfo() {
        return null;
    }

    protected RomanticTraceableSqlStringFilter newRomanticTraceableSqlStringFilter(Method actionMethod, TraceableSqlAdditionalInfoProvider additionalInfoProvider) {
        return new RomanticTraceableSqlStringFilter(actionMethod, additionalInfoProvider);
    }

    protected SqlResultHandler createSqlResultHandler() {
        return this.newRomanticTraceableSqlResultHandler();
    }

    protected RomanticTraceableSqlResultHandler newRomanticTraceableSqlResultHandler() {
        return new RomanticTraceableSqlResultHandler();
    }

    protected void clearCallbackContext() {
        CallbackContext.clearSqlResultHandlerOnThread();
        CallbackContext.clearSqlStringFilterOnThread();
        CallbackContext.clearSqlFireHookOnThread();
    }

    protected Object prepareVariousContext(LaJobRuntime runtime) {
        return null;
    }

    protected void clearVariousContext(LaJobRuntime runtime, Object variousPreparedObj) {
    }

    protected Throwable filterCause(Throwable e) {
        return this.exceptionTranslator.filterCause(e);
    }

    protected void showJobException(LaJobRuntime runtime, long before, Throwable cause) {
        String msg = this.buildJobExceptionMessage(runtime, before, cause);
        this.logJobException(runtime, msg, cause);
    }

    protected String buildJobExceptionMessage(LaJobRuntime runtime, long before, Throwable cause) {
        StringBuilder sb = new StringBuilder();
        sb.append("#flow #job Failed to run the job process:");
        sb.append(LF);
        sb.append("/= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =: ");
        sb.append(runtime.getJobType().getName());
        sb.append(LF).append(EX_IND);
        sb.append("jobRuntime=").append(runtime);
        this.setupExceptionMessageAccessContext(sb, runtime);
        this.setupExceptionMessageCallbackContext(sb, runtime);
        this.setupExceptionMessageVariousContext(sb, runtime, cause);
        this.setupExceptionMessageSqlCountIfExists(sb);
        this.setupExceptionMessageTransactionMemoriesIfExists(sb);
        this.setupExceptionMessageMailCountIfExists(sb);
        this.setupExceptionMessageRemoteApiCountIfExists(sb);
        long after = System.currentTimeMillis();
        String performanceView = this.toPerformanceView(before, after);
        sb.append(LF);
        sb.append("= = = = = = = = = =/ [").append(performanceView).append("] #").append(Integer.toHexString(cause.hashCode()));
        this.buildExceptionStackTrace(cause, sb);
        return sb.toString().trim();
    }

    protected void setupExceptionMessageAccessContext(StringBuilder sb, LaJobRuntime runtime) {
        sb.append(LF).append(EX_IND).append("; accessContext=").append(PreparedAccessContext.getAccessContextOnThread());
    }

    protected void setupExceptionMessageCallbackContext(StringBuilder sb, LaJobRuntime runtime) {
        sb.append(LF).append(EX_IND).append("; callbackContext=").append(CallbackContext.getCallbackContextOnThread());
    }

    protected void setupExceptionMessageVariousContext(StringBuilder sb, LaJobRuntime runtime, Throwable cause) {
        StringBuilder variousContextSb = new StringBuilder();
        this.buildVariousContextInJobExceptionMessage(variousContextSb, runtime, cause);
        if (variousContextSb.length() > 0) {
            sb.append(LF).append(EX_IND).append(variousContextSb.toString());
        }
    }

    protected void buildVariousContextInJobExceptionMessage(StringBuilder sb, LaJobRuntime runtime, Throwable cause) {
    }

    protected void setupExceptionMessageSqlCountIfExists(StringBuilder sb) {
        this.extractSqlCounter().ifPresent(counter -> sb.append(LF).append(EX_IND).append("; sqlCount=").append(counter.toLineDisp()));
    }

    protected void setupExceptionMessageTransactionMemoriesIfExists(StringBuilder sb) {
        SavedTransactionMemories memories = ThreadCacheContext.findTransactionMemories();
        if (memories != null) {
            List providerList = memories.getOrderedProviderList();
            StringBuilder txSb = new StringBuilder();
            for (TransactionMemoriesProvider provider : providerList) {
                provider.provide().ifPresent(result -> {
                    if (txSb.length() == 0) {
                        txSb.append(LF).append(EX_IND).append("; transactionMemories=wholeShow:");
                    }
                    txSb.append(Srl.indent((int)EX_IND.length(), (String)("\n*" + result)));
                });
            }
            sb.append((CharSequence)txSb);
        }
    }

    protected void setupExceptionMessageMailCountIfExists(StringBuilder sb) {
        this.extractMailCounter().ifPresent(counter -> sb.append(LF).append(EX_IND).append("; mailCount=").append(counter.toLineDisp()));
    }

    protected void setupExceptionMessageRemoteApiCountIfExists(StringBuilder sb) {
        this.extractRemoteApiCounter().ifPresent(counter -> sb.append(LF).append(EX_IND).append("; remoteApiCount=").append((String)counter.get()));
    }

    protected void buildExceptionStackTrace(Throwable cause, StringBuilder sb) {
        sb.append(LF).append(new JobErrorStackTracer().buildExceptionStackTrace(cause));
    }

    protected void logJobException(LaJobRuntime runtime, String bigMsg, Throwable cause) {
        if (this.isBusinessStoppedException(cause)) {
            JobNoticeLog.log(runtime.getNoticeLogLevel(), () -> bigMsg);
            if (this.noticeLogHook != null) {
                this.noticeLogHook.hookStopped(runtime, bigMsg, (OptionalThing<Throwable>)OptionalThing.of((Object)cause));
            }
        } else {
            if (this.errorLogHook != null) {
                OptionalThing<LaScheduledJob> job = this.jobManager.findJobByKey(runtime.getJobKey());
                this.errorLogHook.hookError(new JobErrorResource(job, (OptionalThing<LaJobRuntime>)OptionalThing.of((Object)runtime), bigMsg, cause));
            }
            JobErrorLog.log(bigMsg);
        }
    }

    protected boolean isBusinessStoppedException(Throwable cause) {
        return cause instanceof JobStoppedException;
    }

    protected OptionalThing<ExecutedSqlCounter> extractSqlCounter() {
        CallbackContext context = CallbackContext.getCallbackContextOnThread();
        if (context == null) {
            return OptionalThing.empty();
        }
        SqlStringFilter filter = context.getSqlStringFilter();
        if (filter == null || !(filter instanceof ExecutedSqlCounter)) {
            return OptionalThing.empty();
        }
        return OptionalThing.of((Object)((ExecutedSqlCounter)filter));
    }

    protected OptionalThing<PostedMailCounter> extractMailCounter() {
        return OptionalThing.ofNullable((Object)ThreadCacheContext.findMailCounter(), () -> {
            throw new IllegalStateException("Not found the mail counter in the thread cache.");
        });
    }

    protected OptionalThing<Supplier<String>> extractRemoteApiCounter() {
        Supplier counter = (Supplier)ThreadCacheContext.getObject((String)"fw:remoteApiCounter");
        return OptionalThing.ofNullable((Object)counter, () -> {
            throw new IllegalStateException("Not found the remote-api counter in the thread cache.");
        });
    }

    protected void debugFw(LaJobRuntime runtime, String msg, Object ... args) {
        if (runtime.isFrameworkDebug() && logger.isInfoEnabled()) {
            logger.info("#job #fw " + msg, args);
        }
    }

    protected void assertArgumentNotNull(String variableName, Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("The argument '" + variableName + "' should not be null.");
        }
    }

    public String toString() {
        return DfTypeUtil.toClassTitle((Object)this) + ":{accessContext=" + this.accessContextArranger + "}@" + Integer.toHexString(this.hashCode());
    }

    public OptionalThing<AccessContextArranger> getAccessContextArranger() {
        return OptionalThing.ofNullable((Object)this.accessContextArranger, () -> {
            throw new IllegalStateException("Not found the accessContextArranger.");
        });
    }

    public OptionalThing<CrossVMHook> getCrossVMHook() {
        return OptionalThing.ofNullable((Object)this.crossVMHook, () -> {
            throw new IllegalStateException("Not found the crossVMHook.");
        });
    }

    public OptionalThing<JobErrorLogHook> getErrorLogHook() {
        return OptionalThing.ofNullable((Object)this.errorLogHook, () -> {
            throw new IllegalStateException("Not found the errorLogHook.");
        });
    }

    public OptionalThing<JobHistoryHook> getHistoryHook() {
        return OptionalThing.ofNullable((Object)this.historyHook, () -> {
            throw new IllegalStateException("Not found the historyHook.");
        });
    }
}

