/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.optional.OptionalThing;
import org.lastaflute.job.JobManager;
import org.lastaflute.job.LaJobHistory;
import org.lastaflute.job.LaScheduledJob;
import org.lastaflute.job.LaSchedulingNow;
import org.lastaflute.job.LastaJobStarter;
import org.lastaflute.job.key.LaJobKey;
import org.lastaflute.job.key.LaJobUnique;
import org.lastaflute.job.subsidiary.CronConsumer;
import org.lastaflute.job.subsidiary.JobConcurrentExec;
import org.lastaflute.web.servlet.filter.bowgun.BowgunCurtainBefore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJobManager
implements JobManager {
    private static final Logger logger = LoggerFactory.getLogger(SimpleJobManager.class);
    protected static boolean bowgunEmptyScheduling;
    protected static boolean locked;
    protected LaSchedulingNow schedulingNow = this.createEmptyNow();
    protected boolean schedulingDone;

    @PostConstruct
    public synchronized void initialize() {
        BowgunCurtainBefore.unlock();
        BowgunCurtainBefore.shootBowgunCurtainBefore(assistantDirector -> {
            if (!bowgunEmptyScheduling) {
                this.startSchedule();
            }
            this.showBootLogging();
        });
    }

    protected void startSchedule() {
        this.schedulingNow = this.createStarter().start();
        this.schedulingDone = true;
    }

    protected void showBootLogging() {
        if (logger.isInfoEnabled()) {
            logger.info("[Job Manager]");
            logger.info(" schedulingNow: " + this.schedulingNow);
        }
    }

    @Override
    public OptionalThing<LaScheduledJob> findJobByKey(LaJobKey jobKey) {
        this.assertArgumentNotNull("jobKey", jobKey);
        OptionalThing<? extends LaScheduledJob> job = this.schedulingNow.findJobByKey(jobKey);
        return job;
    }

    @Override
    public OptionalThing<LaScheduledJob> findJobByUniqueOf(LaJobUnique jobUnique) {
        this.assertArgumentNotNull("jobUnique", jobUnique);
        OptionalThing<? extends LaScheduledJob> job = this.schedulingNow.findJobByUniqueOf(jobUnique);
        return job;
    }

    @Override
    public List<LaScheduledJob> getJobList() {
        List<LaScheduledJob> jobList = this.schedulingNow.getJobList();
        return jobList;
    }

    @Override
    public void schedule(CronConsumer oneArgLambda) {
        this.assertArgumentNotNull("oneArgLambda", oneArgLambda);
        this.schedulingNow.schedule(oneArgLambda);
    }

    @Override
    @PreDestroy
    public synchronized void destroy() {
        this.schedulingNow.destroy();
        this.schedulingNow = this.createEmptyNow();
        this.schedulingDone = false;
    }

    @Override
    public synchronized void reboot() {
        this.destroy();
        this.startSchedule();
        this.showBootLogging();
    }

    @Override
    public synchronized boolean isSchedulingDone() {
        return this.schedulingDone;
    }

    @Override
    public List<LaJobHistory> searchJobHistoryList() {
        return this.schedulingNow.searchJobHistoryList();
    }

    protected LastaJobStarter createStarter() {
        return new LastaJobStarter();
    }

    protected LaSchedulingNow createEmptyNow() {
        return new EmptySchedulingNow();
    }

    protected void throwJobManagerNotInitializedYetException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("JobManager is not initialized yet at the timing.");
        br.addItem("Advice");
        br.addElement((Object)"You cannot use JobManager in your job scheduler");
        br.addElement((Object)"because JobManager uses the your scheduling result.");
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    protected void assertArgumentNotNull(String variableName, Object value) {
        if (variableName == null) {
            throw new IllegalArgumentException("The variableName should not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The argument '" + variableName + "' should not be null.");
        }
    }

    public static synchronized void shootBowgunEmptyScheduling() {
        SimpleJobManager.assertUnlocked();
        if (bowgunEmptyScheduling) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("...Shooting bowgun empty scheduling: true");
        }
        bowgunEmptyScheduling = true;
        SimpleJobManager.lock();
    }

    public static boolean isLocked() {
        return locked;
    }

    public static void lock() {
        if (locked) {
            return;
        }
        locked = true;
    }

    public static void unlock() {
        if (!locked) {
            return;
        }
        locked = false;
    }

    protected static void assertUnlocked() {
        if (!SimpleJobManager.isLocked()) {
            return;
        }
        throw new IllegalStateException("The job manager is locked.");
    }

    static {
        locked = true;
    }

    protected class EmptySchedulingNow
    implements LaSchedulingNow {
        protected EmptySchedulingNow() {
        }

        @Override
        public OptionalThing<? extends LaScheduledJob> findJobByKey(LaJobKey jobKey) {
            return this.createEmptyOptional();
        }

        @Override
        public OptionalThing<? extends LaScheduledJob> findJobByUniqueOf(LaJobUnique jobUnique) {
            return this.createEmptyOptional();
        }

        protected OptionalThing<LaScheduledJob> createEmptyOptional() {
            return OptionalThing.ofNullable(null, () -> {
                throw new IllegalStateException("Not initialized yet, confirm Job initialization flow.");
            });
        }

        public List<LaScheduledJob> getJobList() {
            return Collections.emptyList();
        }

        @Override
        public void schedule(CronConsumer oneArgLambda) {
            SimpleJobManager.this.throwJobManagerNotInitializedYetException();
        }

        @Override
        public List<LaJobHistory> searchJobHistoryList() {
            return Collections.emptyList();
        }

        @Override
        public void setupNeighborConcurrent(String groupName, JobConcurrentExec concurrentExec, Set<LaJobKey> jobKeySet) {
            SimpleJobManager.this.throwJobManagerNotInitializedYetException();
        }

        @Override
        public void destroy() {
        }

        public String toString() {
            return this.getClass().getSimpleName() + ":{*no scheduling}";
        }
    }
}

