/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job.cron4j;

import it.sauronsoftware.cron4j.TaskExecutor;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.Srl;
import org.lastaflute.job.LaJobHistory;
import org.lastaflute.job.key.LaJobKey;
import org.lastaflute.job.key.LaJobNote;
import org.lastaflute.job.key.LaJobUnique;
import org.lastaflute.job.log.SavedHistoryCache;
import org.lastaflute.job.subsidiary.EndTitleRoll;
import org.lastaflute.job.subsidiary.ExecResultType;

public class Cron4jJobHistory
implements LaJobHistory {
    protected static final SavedHistoryCache historyCache = new SavedHistoryCache();
    protected final LaJobKey jobKey;
    protected final OptionalThing<LaJobNote> jobNote;
    protected final OptionalThing<LaJobUnique> jobUnique;
    protected final OptionalThing<String> cronExp;
    protected final String jobTypeFqcn;
    protected final LocalDateTime activationTime;
    protected final OptionalThing<LocalDateTime> beginTime;
    protected final OptionalThing<LocalDateTime> endTime;
    protected final ExecResultType execResultType;
    protected final Map<String, String> endTitleRollSnapshotMap;
    protected final OptionalThing<Throwable> cause;

    public static synchronized OptionalThing<LaJobHistory> find(TaskExecutor taskExecutor) {
        return historyCache.find(Cron4jJobHistory.generateHistoryKey(taskExecutor));
    }

    public static synchronized void record(TaskExecutor taskExecutor, LaJobHistory jobHistory, int limit) {
        historyCache.record(Cron4jJobHistory.generateHistoryKey(taskExecutor), jobHistory, limit);
    }

    public static synchronized List<LaJobHistory> list() {
        return historyCache.list();
    }

    public static synchronized void clear() {
        historyCache.clear();
    }

    protected static String generateHistoryKey(TaskExecutor taskExecutor) {
        return taskExecutor.getGuid();
    }

    public Cron4jJobHistory(LaJobKey jobKey, OptionalThing<LaJobNote> jobNote, OptionalThing<LaJobUnique> jobUnique, OptionalThing<String> cronExp, String jobTypeFqcn, LocalDateTime activationTime, OptionalThing<LocalDateTime> beginTime, OptionalThing<LocalDateTime> endTime, ExecResultType execResultType, OptionalThing<EndTitleRoll> endTitleRoll, OptionalThing<Throwable> cause) {
        this.jobKey = jobKey;
        this.jobNote = jobNote;
        this.jobUnique = jobUnique;
        this.cronExp = cronExp;
        this.jobTypeFqcn = jobTypeFqcn;
        this.activationTime = activationTime;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.execResultType = execResultType;
        this.endTitleRollSnapshotMap = this.prepareEndTitleRollSnapshotMap(endTitleRoll);
        this.cause = cause;
    }

    protected Map<String, String> prepareEndTitleRollSnapshotMap(OptionalThing<EndTitleRoll> endTitleRoll) {
        return (Map)endTitleRoll.map(roll -> {
            LinkedHashMap map = new LinkedHashMap();
            roll.getDataMap().forEach((key, value) -> map.put(key, value != null ? value.toString() : null));
            return Collections.unmodifiableMap(map);
        }).orElseGet(() -> Collections.emptyMap());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("history:{");
        sb.append(this.jobKey);
        sb.append((String)this.jobNote.map(title -> ", " + title).orElse((Object)""));
        sb.append((String)this.jobUnique.map(uq -> ", " + uq).orElse((Object)""));
        sb.append((String)this.cronExp.map(cron -> ", " + cron).orElse((Object)""));
        sb.append(", ").append(Srl.substringLastRear((String)this.jobTypeFqcn, (String[])new String[]{"."}));
        sb.append(", activation=").append(this.activationTime);
        sb.append(", begin=").append((String)this.beginTime.map(time -> time.toString()).orElse((Object)"*no begin"));
        sb.append(", end=").append((String)this.endTime.map(time -> time.toString()).orElse((Object)"*no end"));
        sb.append(", ").append((Object)this.execResultType);
        if (this.cause.isPresent()) {
            sb.append(", ").append(((Throwable)this.cause.get()).getClass().getSimpleName());
        }
        sb.append("}@").append(Integer.toHexString(this.hashCode()));
        return sb.toString();
    }

    @Override
    public LaJobKey getJobKey() {
        return this.jobKey;
    }

    @Override
    public OptionalThing<LaJobNote> getJobNote() {
        return this.jobNote;
    }

    @Override
    public OptionalThing<LaJobUnique> getJobUnique() {
        return this.jobUnique;
    }

    @Override
    public OptionalThing<String> getCronExp() {
        return this.cronExp;
    }

    @Override
    public String getJobTypeFqcn() {
        return this.jobTypeFqcn;
    }

    @Override
    public LocalDateTime getActivationTime() {
        return this.activationTime;
    }

    @Override
    public OptionalThing<LocalDateTime> getBeginTime() {
        return this.beginTime;
    }

    @Override
    public OptionalThing<LocalDateTime> getEndTime() {
        return this.endTime;
    }

    @Override
    public ExecResultType getExecResultType() {
        return this.execResultType;
    }

    @Override
    public Map<String, String> getEndTitleRollSnapshotMap() {
        return this.endTitleRollSnapshotMap;
    }

    @Override
    public OptionalThing<Throwable> getCause() {
        return this.cause;
    }
}

