/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job.cron4j;

import it.sauronsoftware.cron4j.RomanticCron4jNativeScheduler;
import it.sauronsoftware.cron4j.Scheduler;
import it.sauronsoftware.cron4j.TaskExecutor;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lastaflute.job.cron4j.Cron4jId;
import org.lastaflute.job.cron4j.Cron4jTask;
import org.lastaflute.job.subsidiary.LaunchNowOption;

public class Cron4jScheduler {
    protected final RomanticCron4jNativeScheduler nativeScheduler;

    public Cron4jScheduler(RomanticCron4jNativeScheduler cron4jScheduler) {
        this.nativeScheduler = cron4jScheduler;
    }

    public void start() {
        this.nativeScheduler.start();
    }

    public String schedule(String cronExp, Cron4jTask cron4jTask) {
        return this.nativeScheduler.schedule(cronExp, cron4jTask);
    }

    public void reschedule(Cron4jId cron4jId, String cronExp) {
        this.nativeScheduler.reschedule(cron4jId.value(), cronExp);
    }

    public void deschedule(Cron4jId cron4jId) {
        this.nativeScheduler.deschedule(cron4jId.value());
    }

    public List<TaskExecutor> findExecutorList(Cron4jTask cron4jTask) {
        return this.getExecutorList().stream().filter(executor -> ((Object)((Object)cron4jTask)).equals(executor.getTask())).collect(Collectors.toList());
    }

    public List<TaskExecutor> getExecutorList() {
        return Stream.of(this.nativeScheduler.getExecutingTasks()).collect(Collectors.toList());
    }

    public TaskExecutor launchNow(Cron4jTask cron4jTask, LaunchNowOption option) {
        return this.nativeScheduler.launchNow(cron4jTask, option);
    }

    public void stop() {
        this.nativeScheduler.stop();
    }

    public Scheduler getNativeScheduler() {
        return this.nativeScheduler;
    }
}

