/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job.log;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.optional.OptionalThing;
import org.lastaflute.job.LaJobHistory;
import org.lastaflute.job.exception.JobHistoryNotFoundException;

public class SavedHistoryCache {
    protected final Map<String, LaJobHistory> historyMap = new ConcurrentHashMap<String, LaJobHistory>();
    protected final List<String> historyKeyList = new CopyOnWriteArrayList<String>();

    public synchronized OptionalThing<LaJobHistory> find(String historyKey) {
        LaJobHistory found = this.historyMap.get(historyKey);
        return OptionalThing.ofNullable((Object)found, () -> {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Not found the job history by the job thread.");
            br.addItem("History Key");
            br.addElement((Object)historyKey);
            br.addItem("Existing Key");
            if (!this.historyKeyList.isEmpty()) {
                for (String existingKey : this.historyKeyList) {
                    br.addElement((Object)(existingKey + " = " + this.historyMap.get(existingKey)));
                }
            } else {
                br.addElement((Object)"*No history");
            }
            String msg = br.buildExceptionMessage();
            throw new JobHistoryNotFoundException(msg);
        });
    }

    public synchronized void record(String historyKey, LaJobHistory jobHistory, int limit) {
        if (this.historyMap.size() >= limit) {
            String removedKey = this.historyKeyList.remove(0);
            this.historyMap.remove(removedKey);
        }
        this.historyMap.put(historyKey, jobHistory);
        this.historyKeyList.add(historyKey);
    }

    public synchronized List<LaJobHistory> list() {
        return this.historyKeyList.stream().map(key -> this.historyMap.get(key)).collect(Collectors.toList());
    }

    public synchronized void clear() {
        this.historyMap.clear();
        this.historyKeyList.clear();
    }
}

