/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job.subsidiary;

import java.time.LocalDateTime;
import java.util.List;
import org.lastaflute.job.JobManager;
import org.lastaflute.job.key.LaJobKey;
import org.lastaflute.job.subsidiary.ConcurrentJobStopper;
import org.lastaflute.job.subsidiary.CrossVMHook;
import org.lastaflute.job.subsidiary.CrossVMState;
import org.lastaflute.job.subsidiary.NeighborConcurrentGroup;
import org.lastaflute.job.subsidiary.NeighborConcurrentJobStopper;
import org.lastaflute.job.subsidiary.ReadableJobState;

public abstract class ConcurrentCrossVMHook
implements CrossVMHook {
    protected final JobManager jobManager;

    public ConcurrentCrossVMHook(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    @Override
    public CrossVMState hookBeginning(ReadableJobState jobState, LocalDateTime activationTime) {
        return this.doHookBeginning(jobState, activationTime);
    }

    protected CrossVMState doHookBeginning(ReadableJobState jobState, LocalDateTime activationTime) {
        CrossVMState duplicateBoot = this.handleDuplicateBoot(jobState, activationTime);
        if (duplicateBoot.isQuit()) {
            return duplicateBoot;
        }
        CrossVMState neighborConcurrent = this.handleNeighborConcurrent(jobState, activationTime);
        if (neighborConcurrent.isQuit()) {
            return neighborConcurrent;
        }
        CrossVMState realState = this.asNormalExecution();
        this.markExecuting(jobState, activationTime, realState);
        return realState;
    }

    protected CrossVMState handleDuplicateBoot(ReadableJobState jobState, LocalDateTime activationTime) {
        ConcurrentJobStopper stopper = this.createConcurrentJobStopper();
        return (CrossVMState)stopper.stopIfNeeds(jobState, () -> this.buildDuplicateJobStateDisp(jobState, activationTime)).map(result -> this.asQuitState()).orElseGet(() -> this.asNormalExecution());
    }

    protected ConcurrentJobStopper createConcurrentJobStopper() {
        ConcurrentJobStopper stopper = new ConcurrentJobStopper(jobState -> this.determineDuplicateBoot((ReadableJobState)jobState));
        return stopper.waitress(jobState -> this.waitForDuplicateEnding((ReadableJobState)jobState));
    }

    protected abstract boolean determineDuplicateBoot(ReadableJobState var1);

    protected abstract void waitForDuplicateEnding(ReadableJobState var1);

    protected String buildDuplicateJobStateDisp(ReadableJobState jobState, LocalDateTime activationTime) {
        return activationTime.toString();
    }

    protected CrossVMState handleNeighborConcurrent(ReadableJobState me, LocalDateTime activationTime) {
        NeighborConcurrentJobStopper stopper = this.createNeighborConcurrentJobStopper(me.getNeighborConcurrentGroupList());
        return (CrossVMState)stopper.stopIfNeeds(me, neighbor -> this.buildNeighborJobStateDisp(me, (ReadableJobState)neighbor, activationTime)).map(result -> this.asQuitState()).orElseGet(() -> this.asNormalExecution());
    }

    private NeighborConcurrentJobStopper createNeighborConcurrentJobStopper(List<NeighborConcurrentGroup> neighborConcurrentGroupList) {
        NeighborConcurrentJobStopper stopper = new NeighborConcurrentJobStopper(jobState -> this.determineNeighborExecutingNow((ReadableJobState)jobState), jobKey -> this.jobManager.findJobByKey((LaJobKey)jobKey), neighborConcurrentGroupList);
        return stopper.waitress(jobState -> this.waitForNeighborEnding((ReadableJobState)jobState));
    }

    protected abstract boolean determineNeighborExecutingNow(ReadableJobState var1);

    protected abstract void waitForNeighborEnding(ReadableJobState var1);

    protected String buildNeighborJobStateDisp(ReadableJobState me, ReadableJobState neighbor, LocalDateTime activationTime) {
        return activationTime.toString();
    }

    protected CrossVMState asQuitState() {
        return new CrossVMState().asQuit();
    }

    protected CrossVMState asNormalExecution() {
        return new CrossVMState();
    }

    protected abstract void markExecuting(ReadableJobState var1, LocalDateTime var2, CrossVMState var3);

    @Override
    public void hookEnding(ReadableJobState jobState, CrossVMState crossVMState, LocalDateTime endTime) {
        this.doHookEnding(jobState, crossVMState, endTime);
    }

    protected void doHookEnding(ReadableJobState jobState, CrossVMState crossVMState, LocalDateTime endTime) {
        this.closeExecuting(jobState, crossVMState, endTime);
    }

    protected abstract void closeExecuting(ReadableJobState var1, CrossVMState var2, LocalDateTime var3);
}

