/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job.subsidiary;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.dbflute.optional.OptionalThing;
import org.lastaflute.job.exception.JobConcurrentlyExecutingException;
import org.lastaflute.job.log.JobNoticeLog;
import org.lastaflute.job.log.JobNoticeLogLevel;
import org.lastaflute.job.subsidiary.JobConcurrentExec;
import org.lastaflute.job.subsidiary.ReadableJobAttr;
import org.lastaflute.job.subsidiary.ReadableJobState;
import org.lastaflute.job.subsidiary.RunnerResult;

public class ConcurrentJobStopper {
    protected final Predicate<ReadableJobState> jobExecutingDeterminer;
    protected Consumer<ReadableJobState> waitress;

    public ConcurrentJobStopper(Predicate<ReadableJobState> jobExecutingDeterminer) {
        this.jobExecutingDeterminer = jobExecutingDeterminer;
    }

    public ConcurrentJobStopper waitress(Consumer<ReadableJobState> waitress) {
        if (waitress == null) {
            throw new IllegalArgumentException("The argument 'waitress' should not be null.");
        }
        this.waitress = waitress;
        return this;
    }

    public OptionalThing<RunnerResult> stopIfNeeds(ReadableJobState jobState, Supplier<String> stateDisp) {
        if (this.jobExecutingDeterminer.test(jobState)) {
            JobConcurrentExec concurrentExec = jobState.getConcurrentExec();
            if (concurrentExec.equals((Object)JobConcurrentExec.QUIT)) {
                this.noticeSilentlyQuit(jobState, stateDisp);
                return OptionalThing.of((Object)RunnerResult.asQuitByConcurrent());
            }
            if (concurrentExec.equals((Object)JobConcurrentExec.ERROR)) {
                this.throwJobConcurrentlyExecutingException(jobState, stateDisp);
            } else if (concurrentExec.equals((Object)JobConcurrentExec.WAIT) && this.waitress != null) {
                this.waitress.accept(jobState);
            }
        }
        return OptionalThing.empty();
    }

    protected void noticeSilentlyQuit(ReadableJobAttr jobAttr, Supplier<String> stateDisp) {
        JobNoticeLogLevel noticeLogLevel = jobAttr.getNoticeLogLevel();
        JobNoticeLog.log(noticeLogLevel, () -> {
            String identityDisp = jobAttr.toIdentityDisp();
            return "...Quitting the job for already executing job: " + identityDisp + "(" + (String)stateDisp.get() + ")";
        });
    }

    protected void throwJobConcurrentlyExecutingException(ReadableJobAttr jobAttr, Supplier<String> stateDisp) {
        throw new JobConcurrentlyExecutingException(this.buildConcurrentMessage(jobAttr, stateDisp));
    }

    protected String buildConcurrentMessage(ReadableJobAttr jobAttr, Supplier<String> stateDisp) {
        String identityDisp = jobAttr.toIdentityDisp();
        return "Already executing the job: " + identityDisp + "(" + stateDisp.get() + ")";
    }
}

