/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job.subsidiary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dbflute.optional.OptionalThing;
import org.lastaflute.job.key.LaJobKey;
import org.lastaflute.job.key.LaJobNote;
import org.lastaflute.job.key.LaJobUnique;
import org.lastaflute.job.log.JobNoticeLogLevel;
import org.lastaflute.job.subsidiary.CronParamsSupplier;
import org.lastaflute.job.subsidiary.InitialCronOption;
import org.lastaflute.job.subsidiary.JobSubIdentityAttr;
import org.lastaflute.job.subsidiary.RegisteredJob;
import org.lastaflute.job.subsidiary.VaryingCronOption;

public class CronOption
implements InitialCronOption,
VaryingCronOption,
JobSubIdentityAttr {
    protected String jobTitle;
    protected String jobDesc;
    protected LaJobUnique jobUnique;
    protected CronParamsSupplier paramsSupplier;
    protected List<LaJobKey> triggeringJobKeyList;
    protected JobNoticeLogLevel noticeLogLevel = JobNoticeLogLevel.INFO;
    protected boolean outlawParallelGranted;

    @Override
    public CronOption title(String jobTitle) {
        if (jobTitle == null || jobTitle.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument 'jobTitle' should not be null or empty: " + jobTitle);
        }
        this.jobTitle = jobTitle;
        return this;
    }

    @Override
    public CronOption desc(String jobDesc) {
        if (jobDesc == null || jobDesc.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument 'jobDesc' should not be null or empty: " + jobDesc);
        }
        this.jobDesc = jobDesc;
        return this;
    }

    @Override
    public CronOption uniqueBy(String uniqueCode) {
        if (uniqueCode == null || uniqueCode.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument 'uniqueCode' should not be null or empty: " + uniqueCode);
        }
        this.jobUnique = this.createJobUnique(uniqueCode);
        return this;
    }

    protected LaJobUnique createJobUnique(String uniqueCode) {
        return LaJobUnique.of(uniqueCode);
    }

    @Override
    public CronOption params(CronParamsSupplier noArgLambda) {
        if (noArgLambda == null) {
            throw new IllegalArgumentException("The argument 'noArgLambda' should not be null.");
        }
        this.paramsSupplier = noArgLambda;
        return this;
    }

    @Override
    public CronOption triggeredBy(RegisteredJob triggeringJob) {
        if (triggeringJob == null) {
            throw new IllegalArgumentException("The argument 'triggeringJob' should not be null or empty: " + triggeringJob);
        }
        if (this.triggeringJobKeyList == null) {
            this.triggeringJobKeyList = new ArrayList<LaJobKey>();
        }
        this.triggeringJobKeyList.add(triggeringJob.getJobKey());
        return this;
    }

    @Override
    public CronOption changeNoticeLogToDebug() {
        this.noticeLogLevel = JobNoticeLogLevel.DEBUG;
        return this;
    }

    @Override
    public CronOption changeNoticeLogToSuppressed() {
        this.noticeLogLevel = JobNoticeLogLevel.SUPPRESSED;
        return this;
    }

    @Override
    public VaryingCronOption grantOutlawParallel() {
        this.outlawParallelGranted = true;
        return this;
    }

    public String toString() {
        String uniqueExp = this.jobUnique != null ? "hasJobUnique(" + this.jobUnique + ")" : "noJobUnique";
        String paramsExp = this.paramsSupplier != null ? "hasParams" : "noParams";
        return "option:{" + uniqueExp + ", " + paramsExp + ", " + (Object)((Object)this.noticeLogLevel) + "}";
    }

    @Override
    public OptionalThing<LaJobNote> getJobNote() {
        LaJobNote note = this.jobTitle != null || this.jobDesc != null ? LaJobNote.of(this.jobTitle, this.jobDesc) : null;
        return OptionalThing.ofNullable((Object)note, () -> {
            throw new IllegalStateException("Not found the job note (both title and description).");
        });
    }

    @Override
    public OptionalThing<LaJobUnique> getJobUnique() {
        return OptionalThing.ofNullable((Object)this.jobUnique, () -> {
            throw new IllegalStateException("Not found the application unique code.");
        });
    }

    @Override
    public OptionalThing<CronParamsSupplier> getParamsSupplier() {
        return OptionalThing.ofNullable((Object)this.paramsSupplier, () -> {
            throw new IllegalStateException("Not found the parameters supplier.");
        });
    }

    public List<LaJobKey> getTriggeringJobKeyList() {
        return this.triggeringJobKeyList != null ? Collections.unmodifiableList(this.triggeringJobKeyList) : Collections.emptyList();
    }

    @Override
    public JobNoticeLogLevel getNoticeLogLevel() {
        return this.noticeLogLevel;
    }

    @Override
    public boolean isOutlawParallelGranted() {
        return this.outlawParallelGranted;
    }
}

