/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job.subsidiary;

import java.util.Collections;
import java.util.Set;
import org.lastaflute.job.key.LaJobKey;
import org.lastaflute.job.subsidiary.JobConcurrentExec;

public class NeighborConcurrentGroup {
    protected final String groupName;
    protected final JobConcurrentExec concurrentExec;
    protected final Set<LaJobKey> neighborJobKeySet;
    protected final Object groupPreparingLock;
    protected final Object groupRunningLock;

    public NeighborConcurrentGroup(String groupName, JobConcurrentExec concurrentExec, Set<LaJobKey> neighborJobKeySet, Object groupPreparingLock, Object groupRunningLock) {
        this.assertArgumentNotNull("groupName", groupName);
        if (groupName.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument 'groupName' should not be empty: [" + groupName + "]");
        }
        this.assertArgumentNotNull("concurrentExec", (Object)concurrentExec);
        this.assertArgumentNotNull("neighborJobKeySet", neighborJobKeySet);
        this.assertArgumentNotNull("groupPreparingLock", groupPreparingLock);
        this.assertArgumentNotNull("groupRunningLock", groupRunningLock);
        this.groupName = groupName;
        this.concurrentExec = concurrentExec;
        this.neighborJobKeySet = neighborJobKeySet;
        this.groupPreparingLock = groupPreparingLock;
        this.groupRunningLock = groupRunningLock;
    }

    protected void assertArgumentNotNull(String variableName, Object value) {
        if (variableName == null) {
            throw new IllegalArgumentException("The variableName should not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The argument '" + variableName + "' should not be null.");
        }
    }

    public String toString() {
        return "group:{" + this.groupName + ", " + (Object)((Object)this.concurrentExec) + ", " + this.neighborJobKeySet + "}";
    }

    public String getGroupName() {
        return this.groupName;
    }

    public JobConcurrentExec getConcurrentExec() {
        return this.concurrentExec;
    }

    public Set<LaJobKey> getNeighborJobKeySet() {
        return Collections.unmodifiableSet(this.neighborJobKeySet);
    }

    public Object getGroupPreparingLock() {
        return this.groupPreparingLock;
    }

    public Object getGroupRunningLock() {
        return this.groupRunningLock;
    }
}

