/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job.subsidiary;

import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.dbflute.optional.OptionalThing;
import org.lastaflute.job.exception.JobNeighborConcurrentlyExecutingException;
import org.lastaflute.job.key.LaJobKey;
import org.lastaflute.job.log.JobNoticeLog;
import org.lastaflute.job.log.JobNoticeLogLevel;
import org.lastaflute.job.subsidiary.JobConcurrentExec;
import org.lastaflute.job.subsidiary.NeighborConcurrentGroup;
import org.lastaflute.job.subsidiary.ReadableJobAttr;
import org.lastaflute.job.subsidiary.ReadableJobState;
import org.lastaflute.job.subsidiary.RunnerResult;

public class NeighborConcurrentJobStopper {
    protected final Predicate<ReadableJobState> jobExecutingDeterminer;
    protected final Function<LaJobKey, OptionalThing<? extends ReadableJobState>> jobFinder;
    protected final List<NeighborConcurrentGroup> neighborConcurrentGroupList;
    protected Consumer<ReadableJobState> waitress;

    public NeighborConcurrentJobStopper(Predicate<ReadableJobState> jobExecutingDeterminer, Function<LaJobKey, OptionalThing<? extends ReadableJobState>> jobFinder, List<NeighborConcurrentGroup> neighborConcurrentGroupList) {
        this.jobExecutingDeterminer = jobExecutingDeterminer;
        this.jobFinder = jobFinder;
        this.neighborConcurrentGroupList = neighborConcurrentGroupList;
    }

    public NeighborConcurrentJobStopper waitress(Consumer<ReadableJobState> waitress) {
        if (waitress == null) {
            throw new IllegalArgumentException("The argument 'waitress' should not be null.");
        }
        this.waitress = waitress;
        return this;
    }

    public OptionalThing<RunnerResult> stopIfNeeds(ReadableJobAttr me, Function<ReadableJobState, String> stateDisp) {
        OptionalThing<RunnerResult> quitResult = this.doStopIfNeeds(me, JobConcurrentExec.QUIT, (neighbor, group) -> {
            this.noticeSilentlyQuit(me, (ReadableJobState)neighbor, stateDisp, (NeighborConcurrentGroup)group);
            return RunnerResult.asQuitByConcurrent();
        });
        if (quitResult.isPresent()) {
            return quitResult;
        }
        OptionalThing<RunnerResult> errorResult = this.doStopIfNeeds(me, JobConcurrentExec.ERROR, (neighbor, group) -> {
            this.throwJobNeighborConcurrentlyExecutingException(me, (ReadableJobState)neighbor, stateDisp, (NeighborConcurrentGroup)group);
            return null;
        });
        if (quitResult.isPresent()) {
            return errorResult;
        }
        if (this.waitress != null) {
            this.doStopIfNeeds(me, JobConcurrentExec.WAIT, (neighbor, group) -> {
                this.waitress.accept((ReadableJobState)neighbor);
                return null;
            });
        }
        return OptionalThing.empty();
    }

    protected OptionalThing<RunnerResult> doStopIfNeeds(ReadableJobAttr me, JobConcurrentExec concurrentExec, BiFunction<ReadableJobState, NeighborConcurrentGroup, RunnerResult> action) {
        List filteredGroupList = this.neighborConcurrentGroupList.stream().filter(group -> concurrentExec.equals((Object)group.getConcurrentExec())).collect(Collectors.toList());
        for (NeighborConcurrentGroup group2 : filteredGroupList) {
            Set<LaJobKey> neighborJobKeySet = group2.getNeighborJobKeySet();
            for (LaJobKey neighborJobKey : neighborJobKeySet) {
                if (me.getJobKey().equals(neighborJobKey)) continue;
                OptionalThing<? extends ReadableJobState> optJobState = this.jobFinder.apply(neighborJobKey);
                if (!optJobState.isPresent()) {
                    return OptionalThing.empty();
                }
                ReadableJobState neighbor = (ReadableJobState)optJobState.get();
                if (!this.jobExecutingDeterminer.test(neighbor)) continue;
                return OptionalThing.ofNullable((Object)action.apply(neighbor, group2), () -> {
                    throw new IllegalStateException("Not found the neighbor concurrent runner result: " + neighbor);
                });
            }
        }
        return OptionalThing.empty();
    }

    protected void noticeSilentlyQuit(ReadableJobAttr me, ReadableJobState neighbor, Function<ReadableJobState, String> stateDisp, NeighborConcurrentGroup group) {
        JobNoticeLogLevel noticeLogLevel = me.getNoticeLogLevel();
        JobNoticeLog.log(noticeLogLevel, () -> "...Quitting the job for already executing neighbor job: " + this.buildMeAndNeighbor(me, neighbor, stateDisp, group));
    }

    protected void throwJobNeighborConcurrentlyExecutingException(ReadableJobAttr me, ReadableJobState neighbor, Function<ReadableJobState, String> stateDisp, NeighborConcurrentGroup group) {
        throw new JobNeighborConcurrentlyExecutingException(this.buildConcurrentMessage(me, neighbor, stateDisp, group));
    }

    protected String buildConcurrentMessage(ReadableJobAttr me, ReadableJobState neighbor, Function<ReadableJobState, String> stateDisp, NeighborConcurrentGroup group) {
        return "Already executing the neighbor job: " + this.buildMeAndNeighbor(me, neighbor, stateDisp, group);
    }

    protected String buildMeAndNeighbor(ReadableJobAttr me, ReadableJobState neighbor, Function<ReadableJobState, String> stateDisp, NeighborConcurrentGroup group) {
        StringBuilder sb = new StringBuilder();
        sb.append("me=").append(me.toIdentityDisp());
        sb.append(", neighbor=").append(neighbor.toIdentityDisp());
        sb.append("(").append(stateDisp.apply(neighbor)).append(")");
        sb.append(", group=").append(group.getGroupName());
        return sb.toString();
    }
}

