/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.cron4j;

import it.sauronsoftware.cron4j.RomanticCron4jNativeTaskExecutor;
import it.sauronsoftware.cron4j.Scheduler;
import it.sauronsoftware.cron4j.Task;
import it.sauronsoftware.cron4j.TaskExecutor;
import java.lang.reflect.Field;
import java.util.List;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfReflectionUtil;
import org.lastaflute.job.cron4j.Cron4jTask;
import org.lastaflute.job.subsidiary.LaunchNowOption;

public class RomanticCron4jNativeScheduler
extends Scheduler {
    protected final Object attributeLinkLock = this;
    protected final Object reflectionPartyLock = RomanticCron4jNativeScheduler.class;
    protected static Field executorsField;
    protected List<TaskExecutor> linkedExecutors;
    protected static Field lockField;
    protected Object linkedLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskExecutor launchNow(Cron4jTask cron4jTask, LaunchNowOption nowOption) {
        this.setupLinkedLockIfNeeds();
        Object object = this.linkedLock;
        synchronized (object) {
            if (!this.isStarted()) {
                throw new IllegalStateException("Scheduler not started");
            }
            return this.doSpawnExecutor(cron4jTask, (OptionalThing<LaunchNowOption>)OptionalThing.of((Object)nowOption));
        }
    }

    protected TaskExecutor spawnExecutor(Task task) {
        return this.doSpawnExecutor(task, (OptionalThing<LaunchNowOption>)OptionalThing.ofNullable(null, () -> {
            throw new IllegalStateException("Not found the launch-now option because of not launch-now.");
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskExecutor doSpawnExecutor(Task task, OptionalThing<LaunchNowOption> nowOption) {
        this.setupLinkedExecutorsIfNeeds();
        TaskExecutor executor = this.createTaskExecutor(task, nowOption);
        List<TaskExecutor> list = this.linkedExecutors;
        synchronized (list) {
            this.linkedExecutors.add(executor);
        }
        executor.start(this.isDaemon());
        return executor;
    }

    protected TaskExecutor createTaskExecutor(Task task, OptionalThing<LaunchNowOption> nowOption) {
        return new RomanticCron4jNativeTaskExecutor(this, task, nowOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupLinkedExecutorsIfNeeds() {
        this.readyExecutorsFieldIfNeeds();
        if (this.linkedExecutors == null) {
            Object object = this.attributeLinkLock;
            synchronized (object) {
                if (this.linkedExecutors == null) {
                    this.linkedExecutors = (List)this.getFieldValue(executorsField);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readyExecutorsFieldIfNeeds() {
        if (executorsField == null) {
            Object object = this.reflectionPartyLock;
            synchronized (object) {
                if (executorsField == null) {
                    executorsField = this.getAccessibleField("executors");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupLinkedLockIfNeeds() {
        this.readyLockFieldIfNeeds();
        if (this.linkedLock == null) {
            Object object = this.attributeLinkLock;
            synchronized (object) {
                if (this.linkedLock == null) {
                    this.linkedLock = this.getFieldValue(lockField);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readyLockFieldIfNeeds() {
        if (lockField == null) {
            Object object = this.reflectionPartyLock;
            synchronized (object) {
                if (lockField == null) {
                    lockField = this.getAccessibleField("lock");
                }
            }
        }
    }

    protected <RESULT> RESULT getFieldValue(Field field) {
        return (RESULT)DfReflectionUtil.getValue((Field)field, (Object)((Object)this));
    }

    protected Field getAccessibleField(String fieldName) {
        Field field = DfReflectionUtil.getWholeField(((Object)((Object)this)).getClass(), (String)fieldName);
        field.setAccessible(true);
        return field;
    }
}

