/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job;

import it.sauronsoftware.cron4j.RomanticCron4jNativeScheduler;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.function.Supplier;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.DfTypeUtil;
import org.lastaflute.core.direction.FwAssistantDirector;
import org.lastaflute.core.smartdeploy.ManagedHotdeploy;
import org.lastaflute.core.time.TimeManager;
import org.lastaflute.core.util.ContainerUtil;
import org.lastaflute.di.naming.NamingConvention;
import org.lastaflute.job.LaCron;
import org.lastaflute.job.LaJobRunner;
import org.lastaflute.job.LaJobScheduler;
import org.lastaflute.job.LaScheduledJob;
import org.lastaflute.job.LaSchedulingNow;
import org.lastaflute.job.cron4j.Cron4jCron;
import org.lastaflute.job.cron4j.Cron4jNow;
import org.lastaflute.job.cron4j.Cron4jScheduler;
import org.lastaflute.job.exception.JobSchedulerNoInterfaceException;
import org.lastaflute.job.exception.JobSchedulerNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastaJobStarter {
    private static final Logger logger = LoggerFactory.getLogger(LastaJobStarter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LaSchedulingNow start() {
        Cron4jNow cron4jNow;
        Cron4jScheduler cron4jScheduler;
        LaJobScheduler appScheduler;
        ClassLoader originalLoader = this.startHotdeploy();
        try {
            appScheduler = this.findAppScheduler();
            this.inject(appScheduler);
            LaJobRunner jobRunner = appScheduler.createRunner();
            this.inject(jobRunner);
            cron4jScheduler = this.createCron4jScheduler(jobRunner);
            cron4jNow = this.createCron4jNow(cron4jScheduler, jobRunner);
            Cron4jCron cron4jCron = this.createCron4jCron(cron4jScheduler, jobRunner, cron4jNow);
            appScheduler.schedule(cron4jCron);
            this.showBoot(appScheduler, jobRunner, cron4jScheduler, cron4jNow);
        }
        finally {
            this.stopHotdeploy(originalLoader);
        }
        this.startCron(cron4jScheduler);
        appScheduler.hookJustAfterBooting(cron4jNow);
        return cron4jNow;
    }

    protected ClassLoader startHotdeploy() {
        return ManagedHotdeploy.start();
    }

    protected void stopHotdeploy(ClassLoader originalLoader) {
        ManagedHotdeploy.stop((ClassLoader)originalLoader);
    }

    protected void showBoot(LaJobScheduler scheduler, LaJobRunner jobRunner, Cron4jScheduler cron4jScheduler, Cron4jNow cron4jNow) {
        logger.info("[Job Scheduling]");
        logger.info(" scheduler: {}", (Object)scheduler);
        logger.info(" jobRunner: {}", (Object)jobRunner);
        logger.info(" cron4j: {}", (Object)cron4jScheduler);
        int entryNumber = 1;
        for (LaScheduledJob laScheduledJob : cron4jNow.getJobList()) {
            logger.info(" ({}) {}", (Object)entryNumber, (Object)laScheduledJob);
            ++entryNumber;
        }
    }

    protected LaJobScheduler findAppScheduler() {
        ArrayList<LaJobScheduler> schedulerList = new ArrayList<LaJobScheduler>();
        ArrayList<String> derivedNameList = new ArrayList<String>();
        NamingConvention convention = this.getNamingConvention();
        for (String root : convention.getRootPackageNames()) {
            Class<?> schedulerType;
            String schedulerName = this.buildSchedulerName(root);
            derivedNameList.add(schedulerName);
            try {
                schedulerType = this.forSchedulerName(schedulerName);
            }
            catch (ClassNotFoundException ignored) {
                continue;
            }
            LaJobScheduler scheduler = this.createScheduler(schedulerType);
            schedulerList.add(scheduler);
        }
        if (schedulerList.isEmpty()) {
            this.throwJobSchedulerNotFoundException(derivedNameList);
        } else if (schedulerList.size() >= 2) {
            throw new IllegalStateException("Duplicate scheduler object: " + schedulerList);
        }
        return (LaJobScheduler)schedulerList.get(0);
    }

    protected void throwJobSchedulerNotFoundException(List<String> derivedNameList) {
        String pureName = this.getSchedulerPureName();
        String interfaceName = LaJobScheduler.class.getSimpleName();
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the job scheduler for your application.");
        br.addItem("Advice");
        br.addElement((Object)(pureName + " class is needed for job scheduling,"));
        br.addElement((Object)("which implements " + interfaceName + "."));
        br.addElement((Object)"For example:");
        br.addElement((Object)"  app");
        br.addElement((Object)"   |-job");
        br.addElement((Object)("   |  |-" + pureName + " // Good"));
        br.addElement((Object)"   |  |-SeaJob");
        br.addElement((Object)"   |  |-LandJob");
        br.addElement((Object)"   |-logic");
        br.addElement((Object)"   |-web");
        br.addElement((Object)"   |  |-...");
        br.addElement((Object)"");
        br.addElement((Object)("  public class " + pureName + " implements " + interfaceName + " {"));
        br.addElement((Object)"");
        br.addElement((Object)"      @Override");
        br.addElement((Object)("      public void schedule(" + LaCron.class.getSimpleName() + " cron) {"));
        br.addElement((Object)"          ...");
        br.addElement((Object)"      }");
        br.addElement((Object)"  }");
        br.addItem("Expected Class");
        for (String derivedName : derivedNameList) {
            br.addElement((Object)derivedName);
        }
        String msg = br.buildExceptionMessage();
        throw new JobSchedulerNotFoundException(msg);
    }

    protected Cron4jScheduler createCron4jScheduler(LaJobRunner jobRunner) {
        return new Cron4jScheduler(this.newNativeScheduler());
    }

    protected RomanticCron4jNativeScheduler newNativeScheduler() {
        return new RomanticCron4jNativeScheduler();
    }

    protected Cron4jNow createCron4jNow(Cron4jScheduler cron4jScheduler, LaJobRunner jobRunner) {
        return new Cron4jNow(cron4jScheduler, jobRunner, this.prepareCurrentTimeProvider(), this.isFrameworkDebug());
    }

    protected Cron4jCron createCron4jCron(Cron4jScheduler cron4jScheduler, LaJobRunner runner, Cron4jNow cron4jNow) {
        return new Cron4jCron(cron4jScheduler, runner, cron4jNow, Cron4jCron.CronRegistrationType.START, this.prepareCurrentTimeProvider(), this.isFrameworkDebug());
    }

    protected Supplier<LocalDateTime> prepareCurrentTimeProvider() {
        TimeManager timeManager = this.getTimeManager();
        return () -> {
            Date flashDate = timeManager.flashDate();
            return DfTypeUtil.toLocalDateTime((Object)flashDate, (TimeZone)timeManager.getBusinessTimeZone());
        };
    }

    protected boolean isFrameworkDebug() {
        return this.getAssistantDirector().assistCoreDirection().isFrameworkDebug();
    }

    protected String buildSchedulerName(String root) {
        return root + "." + this.getSchedulerPackage() + "." + this.getSchedulerPureName();
    }

    protected String getSchedulerPackage() {
        return "job";
    }

    protected String getSchedulerPureName() {
        return "AllJobScheduler";
    }

    protected Class<?> forSchedulerName(String schedulingName) throws ClassNotFoundException {
        return Class.forName(schedulingName, false, Thread.currentThread().getContextClassLoader());
    }

    protected LaJobScheduler createScheduler(Class<?> schedulingType) {
        Object schedulerObj = DfReflectionUtil.newInstance(schedulingType);
        if (!(schedulerObj instanceof LaJobScheduler)) {
            this.throwJobSchedulerNoInterfaceException(schedulerObj);
        }
        return (LaJobScheduler)schedulerObj;
    }

    protected void throwJobSchedulerNoInterfaceException(Object schedulerObj) {
        String pureName = this.getSchedulerPureName();
        String interfaceName = LaJobScheduler.class.getSimpleName();
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("You job scheduler does not implement the interface.");
        br.addItem("Advice");
        br.addElement((Object)(pureName + " class should implement " + interfaceName + "."));
        br.addElement((Object)"For example:");
        br.addElement((Object)("  public class " + pureName + " implements " + interfaceName + " { // Good"));
        br.addElement((Object)"");
        br.addElement((Object)"      @Override");
        br.addElement((Object)("      public void schedule(" + LaCron.class.getSimpleName() + " cron) {"));
        br.addElement((Object)"          ...");
        br.addElement((Object)"      }");
        br.addElement((Object)"  }");
        br.addItem("Job Scheduler");
        br.addElement(schedulerObj);
        String msg = br.buildExceptionMessage();
        throw new JobSchedulerNoInterfaceException(msg);
    }

    protected void startCron(Cron4jScheduler cron4jScheduler) {
        cron4jScheduler.start();
    }

    protected NamingConvention getNamingConvention() {
        return (NamingConvention)ContainerUtil.getComponent(NamingConvention.class);
    }

    protected FwAssistantDirector getAssistantDirector() {
        return (FwAssistantDirector)ContainerUtil.getComponent(FwAssistantDirector.class);
    }

    protected TimeManager getTimeManager() {
        return (TimeManager)ContainerUtil.getComponent(TimeManager.class);
    }

    protected void inject(Object target) {
        ContainerUtil.injectSimply((Object)target);
    }
}

