/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job.cron4j;

import java.time.LocalDateTime;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dbflute.optional.OptionalThing;
import org.lastaflute.job.LaCron;
import org.lastaflute.job.LaJob;
import org.lastaflute.job.LaJobRunner;
import org.lastaflute.job.cron4j.Cron4jJob;
import org.lastaflute.job.cron4j.Cron4jNow;
import org.lastaflute.job.cron4j.Cron4jScheduler;
import org.lastaflute.job.cron4j.Cron4jTask;
import org.lastaflute.job.key.LaJobKey;
import org.lastaflute.job.key.LaJobUnique;
import org.lastaflute.job.log.JobChangeLog;
import org.lastaflute.job.subsidiary.CronOption;
import org.lastaflute.job.subsidiary.InitialCronOpCall;
import org.lastaflute.job.subsidiary.JobConcurrentExec;
import org.lastaflute.job.subsidiary.RegisteredJob;
import org.lastaflute.job.subsidiary.VaryingCron;
import org.lastaflute.job.subsidiary.VaryingCronOption;

public class Cron4jCron
implements LaCron {
    public static String NON_CRON = "$$nonCron$$";
    protected final Cron4jScheduler cron4jScheduler;
    protected final LaJobRunner jobRunner;
    protected final Cron4jNow cron4jNow;
    protected final CronRegistrationType registrationType;
    protected final Supplier<LocalDateTime> currentTime;
    protected final boolean frameworkDebug;

    public static boolean isNonCronExp(String cronExp) {
        return NON_CRON.equals(cronExp);
    }

    public Cron4jCron(Cron4jScheduler cron4jScheduler, LaJobRunner jobRunner, Cron4jNow cron4jNow, CronRegistrationType registrationType, Supplier<LocalDateTime> currentTime, boolean frameworkDebug) {
        this.cron4jScheduler = cron4jScheduler;
        this.jobRunner = jobRunner;
        this.cron4jNow = cron4jNow;
        this.registrationType = registrationType;
        this.currentTime = currentTime;
        this.frameworkDebug = frameworkDebug;
    }

    @Override
    public RegisteredJob register(String cronExp, Class<? extends LaJob> jobType, JobConcurrentExec concurrentExec, InitialCronOpCall opLambda) {
        this.assertArgumentNotNull("cronExp", cronExp);
        if (this.isNonCrom(cronExp)) {
            throw new IllegalArgumentException("The cronExp for register() should not be non-cron: " + this.toString());
        }
        this.assertArgumentNotNull("jobType", jobType);
        this.assertArgumentNotNull("concurrentExec", (Object)concurrentExec);
        this.assertArgumentNotNull("opLambda (cronOptionConsumer)", opLambda);
        return this.doRegister(cronExp, jobType, concurrentExec, opLambda);
    }

    protected boolean isNonCrom(String cronExp) {
        return Cron4jCron.isNonCronExp(cronExp);
    }

    @Override
    public RegisteredJob registerNonCron(Class<? extends LaJob> jobType, JobConcurrentExec concurrentExec, InitialCronOpCall opLambda) {
        this.assertArgumentNotNull("jobType", jobType);
        this.assertArgumentNotNull("concurrentExec", (Object)concurrentExec);
        this.assertArgumentNotNull("opLambda (cronOptionConsumer)", opLambda);
        return this.doRegister(NON_CRON, jobType, concurrentExec, opLambda);
    }

    protected RegisteredJob doRegister(String cronExp, Class<? extends LaJob> jobType, JobConcurrentExec concurrentExec, InitialCronOpCall opLambda) {
        CronOption cronOption = this.createCronOption(opLambda);
        Cron4jTask cron4jTask = this.createCron4jTask(cronExp, jobType, concurrentExec, cronOption);
        this.showRegistering(cron4jTask);
        String cron4jId = this.scheduleIfNeeds(cronExp, cron4jTask);
        return this.saveJob(cron4jTask, cronOption, cron4jId);
    }

    protected CronOption createCronOption(InitialCronOpCall opLambda) {
        CronOption option = new CronOption();
        opLambda.callback(option);
        return option;
    }

    protected Cron4jTask createCron4jTask(String cronExp, Class<? extends LaJob> jobType, JobConcurrentExec concurrentExec, CronOption cronOption) {
        VaryingCron varyingCron = this.createVaryingCron(cronExp, cronOption);
        Cron4jTask.JobThreadNaming threadNaming = this.prepareThreadNaming(cronOption);
        return new Cron4jTask(varyingCron, jobType, concurrentExec, threadNaming, this.jobRunner, this.cron4jNow, this.currentTime, this.frameworkDebug);
    }

    protected VaryingCron createVaryingCron(String cronExp, VaryingCronOption cronOption) {
        return new VaryingCron(cronExp, cronOption);
    }

    protected Cron4jTask.JobThreadNaming prepareThreadNaming(CronOption cronOption) {
        OptionalThing<LaJobUnique> jobUnique = cronOption.getJobUnique();
        return option -> {
            StringBuilder sb = new StringBuilder();
            sb.append("job_");
            if (jobUnique.isPresent()) {
                sb.append(jobUnique.get());
                if (option.isAlwaysHash()) {
                    sb.append("_");
                    sb.append(this.buildThreadNameHashSuffix());
                }
            } else {
                sb.append(this.buildThreadNameHashSuffix());
            }
            return sb.toString();
        };
    }

    protected String buildThreadNameHashSuffix() {
        return Integer.toHexString(Thread.currentThread().hashCode());
    }

    protected void showRegistering(Cron4jTask cron4jTask) {
        if (CronRegistrationType.CHANGE.equals((Object)this.registrationType) && JobChangeLog.isEnabled()) {
            JobChangeLog.log("#job ...Registering job: {}", new Object[]{cron4jTask});
        }
    }

    protected String scheduleIfNeeds(String cronExp, Cron4jTask cron4jTask) {
        String cron4jId = cron4jTask.isNonCron() ? null : this.cron4jScheduler.schedule(cronExp, cron4jTask);
        return cron4jId;
    }

    protected Cron4jJob saveJob(Cron4jTask cron4jTask, CronOption cronOption, String cron4jId) {
        return this.cron4jNow.saveJob(cron4jTask, cronOption, cronOption.getTriggeringJobKeyList(), (OptionalThing<String>)OptionalThing.ofNullable((Object)cron4jId, () -> {
            throw new IllegalStateException("Not found the cron4jId: " + (Object)((Object)cron4jTask));
        }));
    }

    @Override
    public void setupNeighborConcurrent(String groupName, JobConcurrentExec concurrentExec, RegisteredJob ... jobs) {
        this.assertArgumentNotNull("groupName", groupName);
        if (groupName.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument 'groupName' should not be empty: [" + groupName + "]");
        }
        this.assertArgumentNotNull("concurrentExec", (Object)concurrentExec);
        this.assertArgumentNotNull("jobs", jobs);
        Set<LaJobKey> jobKeySet = Stream.of(jobs).map(job -> job.getJobKey()).collect(Collectors.toSet());
        this.cron4jNow.setupNeighborConcurrent(groupName, concurrentExec, jobKeySet);
    }

    protected void assertArgumentNotNull(String variableName, Object value) {
        if (variableName == null) {
            throw new IllegalArgumentException("The variableName should not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The argument '" + variableName + "' should not be null.");
        }
    }

    public static enum CronRegistrationType {
        START,
        CHANGE;

    }
}

