/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job.cron4j;

import it.sauronsoftware.cron4j.TaskExecutor;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dbflute.optional.OptionalThing;
import org.dbflute.optional.OptionalThingIfPresentAfter;
import org.dbflute.util.DfTypeUtil;
import org.lastaflute.job.LaJob;
import org.lastaflute.job.LaJobHistory;
import org.lastaflute.job.LaScheduledJob;
import org.lastaflute.job.cron4j.Cron4jCron;
import org.lastaflute.job.cron4j.Cron4jId;
import org.lastaflute.job.cron4j.Cron4jJobHistory;
import org.lastaflute.job.cron4j.Cron4jNow;
import org.lastaflute.job.cron4j.Cron4jScheduler;
import org.lastaflute.job.cron4j.Cron4jTask;
import org.lastaflute.job.exception.JobAlreadyDisappearedException;
import org.lastaflute.job.exception.JobAlreadyUnscheduleException;
import org.lastaflute.job.exception.JobTriggeredNotFoundException;
import org.lastaflute.job.key.LaJobKey;
import org.lastaflute.job.key.LaJobNote;
import org.lastaflute.job.key.LaJobUnique;
import org.lastaflute.job.log.JobChangeLog;
import org.lastaflute.job.log.JobNoticeLogLevel;
import org.lastaflute.job.subsidiary.CronOption;
import org.lastaflute.job.subsidiary.CronParamsSupplier;
import org.lastaflute.job.subsidiary.JobConcurrentExec;
import org.lastaflute.job.subsidiary.JobExecutingSnapshot;
import org.lastaflute.job.subsidiary.LaunchNowOpCall;
import org.lastaflute.job.subsidiary.LaunchNowOption;
import org.lastaflute.job.subsidiary.LaunchedProcess;
import org.lastaflute.job.subsidiary.NeighborConcurrentGroup;
import org.lastaflute.job.subsidiary.SnapshotExecState;
import org.lastaflute.job.subsidiary.VaryingCronOpCall;
import org.lastaflute.job.subsidiary.VaryingCronOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cron4jJob
implements LaScheduledJob {
    private static final Logger logger = LoggerFactory.getLogger(Cron4jJob.class);
    protected final LaJobKey jobKey;
    protected final OptionalThing<LaJobNote> jobNote;
    protected final OptionalThing<LaJobUnique> jobUnique;
    protected volatile OptionalThing<Cron4jId> cron4jId;
    protected final Cron4jTask cron4jTask;
    protected final Cron4jNow cron4jNow;
    protected volatile boolean unscheduled;
    protected volatile boolean disappeared;
    protected final Set<LaJobKey> triggeredJobKeySet = new CopyOnWriteArraySet<LaJobKey>();
    protected final Object triggeredJobLock = new Object();
    protected final List<Cron4jTask> outlawParallelTaskList = new CopyOnWriteArrayList<Cron4jTask>();
    protected final Object outlawParallelLock = new Object();
    protected Map<String, NeighborConcurrentGroup> neighborConcurrentGroupMap;
    protected List<NeighborConcurrentGroup> neighborConcurrentGroupList;

    public Cron4jJob(LaJobKey jobKey, OptionalThing<LaJobNote> jobNote, OptionalThing<LaJobUnique> jobUnique, OptionalThing<Cron4jId> cron4jId, Cron4jTask cron4jTask, Cron4jNow cron4jNow) {
        this.jobKey = jobKey;
        this.jobNote = jobNote;
        this.jobUnique = jobUnique;
        this.cron4jId = cron4jId;
        this.cron4jTask = cron4jTask;
        this.cron4jNow = cron4jNow;
    }

    @Override
    public OptionalThingIfPresentAfter ifExecutingNow(Consumer<SnapshotExecState> oneArgLambda) {
        return (OptionalThingIfPresentAfter)this.mapExecutingNow(execState -> {
            oneArgLambda.accept((SnapshotExecState)execState);
            return processor -> {};
        }).orElseGet(() -> processor -> processor.process());
    }

    @Override
    public boolean isExecutingNow() {
        return this.cron4jTask.isRunningNow() || this.isAnyOutlawParallelRunningNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAnyOutlawParallelRunningNow() {
        Object object = this.outlawParallelLock;
        synchronized (object) {
            return this.outlawParallelTaskList.stream().anyMatch(task -> task.isRunningNow());
        }
    }

    @Override
    public <RESULT> OptionalThing<RESULT> mapExecutingNow(Function<SnapshotExecState, RESULT> oneArgLambda) {
        return this.findRunningBeginTime().flatMap(time -> OptionalThing.ofNullable(oneArgLambda.apply(new SnapshotExecState((LocalDateTime)time)), () -> {
            throw new IllegalStateException("Not found the result from your scope: job=" + this.toIdentityDisp() + "(" + time + ")");
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OptionalThing<LocalDateTime> findRunningBeginTime() {
        OptionalThing beginTime = this.extractRunningBeginTime(this.cron4jTask);
        if (!beginTime.isPresent()) {
            Object object = this.outlawParallelLock;
            synchronized (object) {
                Optional<LocalDateTime> parallelTime = this.outlawParallelTaskList.stream().map(task -> this.extractRunningBeginTime((Cron4jTask)((Object)task))).filter(optTime -> optTime.isPresent()).map(optTime -> (LocalDateTime)optTime.get()).findFirst();
                if (parallelTime.isPresent()) {
                    beginTime = OptionalThing.of((Object)parallelTime.get());
                }
            }
        }
        return beginTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobExecutingSnapshot takeSnapshotNow() {
        List<SnapshotExecState> outlawParallelExecStateList;
        OptionalThing mainExecState = this.extractRunningBeginTime(this.cron4jTask).map(beginTime -> new SnapshotExecState((LocalDateTime)beginTime));
        Object object = this.outlawParallelLock;
        synchronized (object) {
            outlawParallelExecStateList = this.outlawParallelTaskList.stream().map(task -> this.extractRunningBeginTime((Cron4jTask)((Object)task))).filter(optTime -> optTime.isPresent()).map(optTime -> (LocalDateTime)optTime.get()).map(beginTime -> new SnapshotExecState((LocalDateTime)beginTime)).collect(Collectors.toList());
        }
        int executingCount = (mainExecState.isPresent() ? 1 : 0) + outlawParallelExecStateList.size();
        return new JobExecutingSnapshot(executingCount, (OptionalThing<SnapshotExecState>)mainExecState, outlawParallelExecStateList);
    }

    @Override
    public synchronized LaunchedProcess launchNow() {
        return this.doLaunchNow(op -> {});
    }

    @Override
    public synchronized LaunchedProcess launchNow(LaunchNowOpCall opLambda) {
        return this.doLaunchNow(opLambda);
    }

    protected LaunchedProcess doLaunchNow(LaunchNowOpCall opLambda) {
        this.verifyCanScheduleState();
        LaunchNowOption option = this.createLaunchNowOption(opLambda);
        if (JobChangeLog.isEnabled()) {
            JobChangeLog.log("#job ...Launching now: {}, {}", option, this);
        }
        Cron4jTask nowTask = option.isOutlawParallel() ? this.prepareOutlawParallelLaunch() : this.cron4jTask;
        TaskExecutor taskExecutor = this.cron4jNow.getCron4jScheduler().launchNow(nowTask, option);
        return this.createLaunchedProcess(taskExecutor);
    }

    protected LaunchNowOption createLaunchNowOption(LaunchNowOpCall opLambda) {
        LaunchNowOption op = new LaunchNowOption();
        opLambda.callback(op);
        return op;
    }

    protected LaunchedProcess createLaunchedProcess(TaskExecutor taskExecutor) {
        return new LaunchedProcess(this, () -> this.joinJobThread(taskExecutor), () -> this.findJobHistory(taskExecutor));
    }

    protected void joinJobThread(TaskExecutor taskExecutor) {
        try {
            taskExecutor.join();
        }
        catch (InterruptedException e) {
            String msg = "The current thread has been interrupted while join: taskExecutor=" + taskExecutor + ", job=" + this;
            throw new IllegalStateException(msg, e);
        }
    }

    protected OptionalThing<LaJobHistory> findJobHistory(TaskExecutor taskExecutor) {
        return Cron4jJobHistory.find(taskExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Cron4jTask prepareOutlawParallelLaunch() {
        Cron4jTask nowTask;
        if (!this.isOutlawParallelGranted()) {
            throw new IllegalStateException("The job is not allowed to use outlaw parallel: " + this.toIdentityDisp());
        }
        if (!this.isNonCron()) {
            throw new IllegalStateException("Cannot use outlaw parallel when scheduled cron: " + this.toIdentityDisp());
        }
        Object object = this.outlawParallelLock;
        synchronized (object) {
            this.outlawParallelTaskList.removeIf(task -> task.syncRunningOnceEnded());
            nowTask = this.cron4jTask.createOutlawParallelTask();
            this.outlawParallelTaskList.add(nowTask);
        }
        return nowTask;
    }

    @Override
    public synchronized void stopNow() {
        this.verifyCanStopState();
        List<TaskExecutor> executorList = this.findNativeExecutorList();
        if (JobChangeLog.isEnabled()) {
            JobChangeLog.log("#job ...Stopping {} execution(s) now: {}", executorList.size(), this.toString());
        }
        if (!executorList.isEmpty()) {
            executorList.forEach(executor -> executor.stop());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<TaskExecutor> findNativeExecutorList() {
        ArrayList<TaskExecutor> executorList = new ArrayList<TaskExecutor>();
        Cron4jScheduler cron4jScheduler = this.cron4jNow.getCron4jScheduler();
        executorList.addAll(cron4jScheduler.findExecutorList(this.cron4jTask));
        Object object = this.outlawParallelLock;
        synchronized (object) {
            this.outlawParallelTaskList.stream().flatMap(task -> cron4jScheduler.findExecutorList((Cron4jTask)((Object)task)).stream()).forEach(executor -> executorList.add((TaskExecutor)executor));
        }
        return executorList;
    }

    @Override
    public synchronized void reschedule(String cronExp, VaryingCronOpCall opLambda) {
        this.verifyCanRescheduleState();
        this.assertArgumentNotNull("cronExp", cronExp);
        this.assertArgumentNotNull("opLambda", opLambda);
        if (this.isNonCromExp(cronExp)) {
            throw new IllegalArgumentException("The cronExp for reschedule() should not be non-cron: " + this.toString());
        }
        if (this.unscheduled) {
            this.unscheduled = false;
        }
        String existingCronExp = this.cron4jTask.getVaryingCron().getCronExp();
        this.cron4jTask.switchCron(cronExp, this.createCronOption(opLambda));
        Cron4jScheduler cron4jScheduler = this.cron4jNow.getCron4jScheduler();
        this.cron4jId.ifPresent(id -> {
            if (JobChangeLog.isEnabled()) {
                JobChangeLog.log("#job ...Rescheduling {} as cron from '{}' to '{}'", this.jobKey, existingCronExp, cronExp);
            }
            if (this.isNativeScheduledId(cron4jScheduler, (Cron4jId)id)) {
                cron4jScheduler.reschedule((Cron4jId)id, cronExp);
            } else {
                this.cron4jId = this.scheduleNative(cronExp, cron4jScheduler);
            }
        }).orElse(() -> {
            if (JobChangeLog.isEnabled()) {
                JobChangeLog.log("#job ...Rescheduling {} as cron from non-cron to '{}'", this.jobKey, cronExp);
            }
            this.cron4jId = this.scheduleNative(cronExp, cron4jScheduler);
        });
    }

    protected boolean isNonCromExp(String cronExp) {
        return Cron4jCron.isNonCronExp(cronExp);
    }

    protected VaryingCronOption createCronOption(VaryingCronOpCall opLambda) {
        CronOption option = new CronOption();
        opLambda.callback(option);
        return option;
    }

    protected boolean isNativeScheduledId(Cron4jScheduler cron4jScheduler, Cron4jId id) {
        return cron4jScheduler.getNativeScheduler().getTask(id.value()) != null;
    }

    protected OptionalThing<Cron4jId> scheduleNative(String cronExp, Cron4jScheduler cron4jScheduler) {
        String generatedId = cron4jScheduler.schedule(cronExp, this.cron4jTask);
        return OptionalThing.of((Object)Cron4jId.of(generatedId));
    }

    @Override
    public synchronized void unschedule() {
        this.verifyCanUnscheduleState();
        if (JobChangeLog.isEnabled()) {
            JobChangeLog.log("#job ...Unscheduling {}", this.toString());
        }
        this.unscheduled = true;
        this.cron4jId.ifPresent(id -> this.cron4jNow.getCron4jScheduler().deschedule((Cron4jId)id));
    }

    @Override
    public boolean isUnscheduled() {
        return this.unscheduled;
    }

    @Override
    public synchronized void disappear() {
        this.verifyCanDisappearState();
        if (JobChangeLog.isEnabled()) {
            JobChangeLog.log("#job ...Disappearing {}", this.toString());
        }
        this.disappeared = true;
        this.cron4jId.ifPresent(id -> this.cron4jNow.getCron4jScheduler().deschedule((Cron4jId)id));
        this.cron4jNow.clearDisappearedJob();
    }

    @Override
    public boolean isDisappeared() {
        return this.disappeared;
    }

    @Override
    public synchronized void becomeNonCron() {
        this.verifyCanScheduleState();
        if (JobChangeLog.isEnabled()) {
            JobChangeLog.log("#job ...Becoming non-cron: {}", this.toString());
        }
        this.cron4jId.ifPresent(id -> {
            this.cron4jTask.becomeNonCrom();
            this.cron4jNow.getCron4jScheduler().deschedule((Cron4jId)id);
            this.cron4jId = OptionalThing.empty();
        });
    }

    @Override
    public boolean isNonCron() {
        return !this.cron4jId.isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerNext(LaJobKey triggeredJobKey) {
        this.verifyCanScheduleState();
        this.assertArgumentNotNull("triggeredJobKey", triggeredJobKey);
        if (triggeredJobKey.equals(this.jobKey)) {
            throw new IllegalArgumentException("Cannot register myself job as next trigger: " + this.toIdentityDisp());
        }
        Object object = this.triggeredJobLock;
        synchronized (object) {
            this.triggeredJobKeySet.add(triggeredJobKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerNext() {
        Object object = this.triggeredJobLock;
        synchronized (object) {
            List<Cron4jJob> triggeredJobList = this.triggeredJobKeySet.stream().map(triggeredJobKey -> this.findTriggeredJob((LaJobKey)triggeredJobKey)).collect(Collectors.toList());
            this.showPreparingNextTrigger(triggeredJobList);
            for (Cron4jJob triggeredJob : triggeredJobList) {
                triggeredJob.launchNow();
            }
        }
    }

    protected Cron4jJob findTriggeredJob(LaJobKey triggeredJobKey) {
        return (Cron4jJob)this.cron4jNow.findJobByKey(triggeredJobKey).orElseTranslatingThrow(cause -> {
            String msg = "Not found the next job: " + triggeredJobKey + " triggered by " + this.toString();
            throw new JobTriggeredNotFoundException(msg, (Throwable)cause);
        });
    }

    protected void showPreparingNextTrigger(List<Cron4jJob> triggeredJobList) {
        if (triggeredJobList.isEmpty()) {
            return;
        }
        List expList = triggeredJobList.stream().map(triggeredJob -> triggeredJob.toIdentityDisp()).collect(Collectors.toList());
        String exp = expList.size() == 1 ? (String)expList.get(0) : expList.toString();
        logger.info("#job ...Preparing next job {} triggered by {}", (Object)exp, (Object)this.toIdentityDisp());
    }

    protected String buildTriggerNextJobExp(Cron4jJob triggeredJob) {
        String keyExp = (String)triggeredJob.getJobUnique().map(unique -> unique.value()).orElseGet(() -> triggeredJob.getJobKey().value());
        return keyExp + "(" + triggeredJob.getJobType().getSimpleName() + ")";
    }

    public synchronized void registerNeighborConcurrent(String groupName, NeighborConcurrentGroup neighborConcurrentGroup) {
        this.verifyCanScheduleState();
        if (this.neighborConcurrentGroupMap == null) {
            this.neighborConcurrentGroupMap = new ConcurrentHashMap<String, NeighborConcurrentGroup>();
            this.neighborConcurrentGroupList = new CopyOnWriteArrayList<NeighborConcurrentGroup>();
        }
        this.neighborConcurrentGroupMap.put(groupName, neighborConcurrentGroup);
        this.neighborConcurrentGroupList.add(neighborConcurrentGroup);
    }

    @Override
    public String toIdentityDisp() {
        Class<? extends LaJob> jobType = this.cron4jTask.getJobType();
        return jobType.getSimpleName() + ":{" + (String)this.jobUnique.map(uq -> uq + "(" + this.jobKey + ")").orElseGet(() -> this.jobKey.value()) + "}";
    }

    protected OptionalThing<LocalDateTime> extractRunningBeginTime(Cron4jTask task) {
        return task.syncRunningCall(runningState -> (LocalDateTime)runningState.getBeginTime().get());
    }

    protected synchronized void verifyCanScheduleState() {
        if (this.disappeared) {
            throw new JobAlreadyDisappearedException("Already disappeared the job: " + this.toString());
        }
        if (this.unscheduled) {
            throw new JobAlreadyUnscheduleException("Already unscheduled the job: " + this.toString());
        }
    }

    protected synchronized void verifyCanRescheduleState() {
        if (this.disappeared) {
            throw new JobAlreadyDisappearedException("Already disappeared the job: " + this.toString());
        }
    }

    protected synchronized void verifyCanUnscheduleState() {
        if (this.disappeared) {
            throw new JobAlreadyDisappearedException("Already disappeared the job: " + this.toString());
        }
        if (this.unscheduled) {
            throw new JobAlreadyUnscheduleException("Already unscheduled the job: " + this.toString());
        }
    }

    protected synchronized void verifyCanDisappearState() {
        if (this.disappeared) {
            throw new JobAlreadyDisappearedException("Already disappeared the job: " + this.toString());
        }
    }

    protected synchronized void verifyCanStopState() {
    }

    protected void assertArgumentNotNull(String variableName, Object value) {
        if (variableName == null) {
            throw new IllegalArgumentException("The variableName should not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The argument '" + variableName + "' should not be null.");
        }
    }

    public String toString() {
        String titlePrefix = (String)this.jobNote.map(title -> title + ", ").orElse((Object)"");
        String keyExp = (String)this.jobUnique.map(uq -> uq + "(" + this.jobKey + ")").orElseGet(() -> this.jobKey.value());
        String idExp = (String)this.cron4jId.map(id -> id.value()).orElse((Object)"non-cron");
        String hash = Integer.toHexString(this.hashCode());
        return DfTypeUtil.toClassTitle((Object)this) + ":{" + titlePrefix + keyExp + ", " + idExp + ", " + (Object)((Object)this.cron4jTask) + "}@" + hash;
    }

    @Override
    public LaJobKey getJobKey() {
        return this.jobKey;
    }

    @Override
    public OptionalThing<LaJobNote> getJobNote() {
        return this.jobNote;
    }

    @Override
    public OptionalThing<LaJobUnique> getJobUnique() {
        return this.jobUnique;
    }

    @Override
    public synchronized OptionalThing<String> getCronExp() {
        String cronExp = !this.isNonCron() ? this.cron4jTask.getVaryingCron().getCronExp() : null;
        return OptionalThing.ofNullable((Object)cronExp, () -> {
            throw new IllegalStateException("Not found cron expression because of non-cron job: " + this.toString());
        });
    }

    @Override
    public Class<? extends LaJob> getJobType() {
        return this.cron4jTask.getJobType();
    }

    @Override
    public OptionalThing<CronParamsSupplier> getParamsSupplier() {
        return this.cron4jTask.getVaryingCron().getCronOption().getParamsSupplier();
    }

    @Override
    public JobNoticeLogLevel getNoticeLogLevel() {
        return this.cron4jTask.getVaryingCron().getCronOption().getNoticeLogLevel();
    }

    @Override
    public JobConcurrentExec getConcurrentExec() {
        return this.cron4jTask.getConcurrentExec();
    }

    @Override
    public boolean isOutlawParallelGranted() {
        return this.cron4jTask.getVaryingCron().getCronOption().isOutlawParallelGranted();
    }

    public OptionalThing<Cron4jId> getCron4jId() {
        return this.cron4jId;
    }

    public Cron4jTask getCron4jTask() {
        return this.cron4jTask;
    }

    public Cron4jNow getCron4jNow() {
        return this.cron4jNow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<LaJobKey> getTriggeredJobKeySet() {
        Object object = this.triggeredJobLock;
        synchronized (object) {
            return Collections.unmodifiableSet(this.triggeredJobKeySet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Cron4jTask> getOutlawParallelTaskList() {
        Object object = this.outlawParallelLock;
        synchronized (object) {
            return Collections.unmodifiableList(this.outlawParallelTaskList);
        }
    }

    @Override
    public synchronized List<NeighborConcurrentGroup> getNeighborConcurrentGroupList() {
        if (this.neighborConcurrentGroupList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new CopyOnWriteArrayList<NeighborConcurrentGroup>(this.neighborConcurrentGroupList));
    }

    @Override
    public synchronized Map<String, NeighborConcurrentGroup> getNeighborConcurrentGroupMap() {
        return this.neighborConcurrentGroupMap != null ? Collections.unmodifiableMap(this.neighborConcurrentGroupMap) : Collections.emptyMap();
    }
}

