/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job.cron4j;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Supplier;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfTypeUtil;
import org.dbflute.util.Srl;
import org.lastaflute.job.LaJobHistory;
import org.lastaflute.job.LaJobRunner;
import org.lastaflute.job.LaSchedulingNow;
import org.lastaflute.job.cron4j.Cron4jCron;
import org.lastaflute.job.cron4j.Cron4jId;
import org.lastaflute.job.cron4j.Cron4jJob;
import org.lastaflute.job.cron4j.Cron4jJobHistory;
import org.lastaflute.job.cron4j.Cron4jScheduler;
import org.lastaflute.job.cron4j.Cron4jTask;
import org.lastaflute.job.exception.JobNotFoundException;
import org.lastaflute.job.key.LaJobKey;
import org.lastaflute.job.key.LaJobNote;
import org.lastaflute.job.key.LaJobUnique;
import org.lastaflute.job.log.JobChangeLog;
import org.lastaflute.job.subsidiary.CronConsumer;
import org.lastaflute.job.subsidiary.JobConcurrentExec;
import org.lastaflute.job.subsidiary.JobSubIdentityAttr;
import org.lastaflute.job.subsidiary.NeighborConcurrentGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cron4jNow
implements LaSchedulingNow {
    private static final Logger logger = LoggerFactory.getLogger(Cron4jNow.class);
    protected final Cron4jScheduler cron4jScheduler;
    protected final LaJobRunner jobRunner;
    protected final Supplier<LocalDateTime> currentTime;
    protected final boolean frameworkDebug;
    protected final Map<LaJobKey, Cron4jJob> jobKeyJobMap = new ConcurrentHashMap<LaJobKey, Cron4jJob>();
    protected final List<Cron4jJob> jobOrderedList = new CopyOnWriteArrayList<Cron4jJob>();
    protected final Map<LaJobUnique, Cron4jJob> jobUniqueJobMap = new ConcurrentHashMap<LaJobUnique, Cron4jJob>();
    protected final Map<Cron4jTask.TaskJobIdentity, Cron4jJob> cron4jTaskJobMap = new ConcurrentHashMap<Cron4jTask.TaskJobIdentity, Cron4jJob>();
    protected final Map<String, NeighborConcurrentGroup> neighborConcurrentMap = new ConcurrentHashMap<String, NeighborConcurrentGroup>();
    protected int incrementedJobNumber;

    public Cron4jNow(Cron4jScheduler cron4jScheduler, LaJobRunner jobRunner, Supplier<LocalDateTime> currentTime, boolean frameworkDebug) {
        this.cron4jScheduler = cron4jScheduler;
        this.jobRunner = jobRunner;
        this.currentTime = currentTime;
        this.frameworkDebug = frameworkDebug;
    }

    public synchronized Cron4jJob saveJob(Cron4jTask cron4jTask, JobSubIdentityAttr subIdentityAttr, List<LaJobKey> triggeringJobKeyList, OptionalThing<String> cron4jId) {
        this.assertArgumentNotNull("cron4jTask", (Object)cron4jTask);
        LaJobKey jobKey = this.generateJobKey(cron4jTask);
        Cron4jJob cron4jJob = this.createCron4jJob(jobKey, subIdentityAttr, triggeringJobKeyList, cron4jId, cron4jTask);
        this.assertDuplicateJobKey(jobKey);
        this.jobKeyJobMap.put(jobKey, cron4jJob);
        this.jobOrderedList.add(cron4jJob);
        subIdentityAttr.getJobUnique().ifPresent(uniqueCode -> {
            this.assertDuplicateUniqueCode(jobKey, (LaJobUnique)uniqueCode);
            this.jobUniqueJobMap.put((LaJobUnique)uniqueCode, cron4jJob);
        });
        this.cron4jTaskJobMap.put(cron4jTask.getTaskJobIdentity(), cron4jJob);
        return cron4jJob;
    }

    protected LaJobKey generateJobKey(Cron4jTask cron4jTask) {
        this.incrementedJobNumber = this.incrementedJobNumber == Integer.MAX_VALUE ? 1 : ++this.incrementedJobNumber;
        return this.createJobKey(this.buildJobKey(cron4jTask, this.incrementedJobNumber));
    }

    protected String buildJobKey(Cron4jTask cron4jTask, int jobNumber) {
        return Srl.initUncap((String)cron4jTask.getJobType().getSimpleName()) + "_" + jobNumber;
    }

    protected LaJobKey createJobKey(String jobKey) {
        return LaJobKey.of(jobKey);
    }

    protected Cron4jJob createCron4jJob(LaJobKey jobKey, JobSubIdentityAttr subIdentityAttr, List<LaJobKey> triggeringJobKeyList, OptionalThing<String> cron4jId, Cron4jTask cron4jTask) {
        Cron4jJob job = this.newCron4jJob(jobKey, subIdentityAttr.getJobNote(), subIdentityAttr.getJobUnique(), (OptionalThing<Cron4jId>)cron4jId.map(id -> Cron4jId.of(id)), cron4jTask, this);
        triggeringJobKeyList.forEach(triggeringJobKey -> this.findJobByKey((LaJobKey)triggeringJobKey).alwaysPresent(triggeringJob -> triggeringJob.registerNext(jobKey)));
        return job;
    }

    protected Cron4jJob newCron4jJob(LaJobKey jobKey, OptionalThing<LaJobNote> jobNote, OptionalThing<LaJobUnique> jobUnique, OptionalThing<Cron4jId> cron4jId, Cron4jTask cron4jTask, Cron4jNow cron4jNow) {
        return new Cron4jJob(jobKey, jobNote, jobUnique, cron4jId, cron4jTask, cron4jNow);
    }

    protected void assertDuplicateJobKey(LaJobKey jobKey) {
        if (this.jobKeyJobMap.containsKey(jobKey)) {
            throw new IllegalStateException("Duplicate job key: " + jobKey + " existing=" + this.jobKeyJobMap);
        }
    }

    protected void assertDuplicateUniqueCode(LaJobKey jobKey, LaJobUnique jobUnique) {
        if (this.jobUniqueJobMap.containsKey(jobUnique)) {
            throw new IllegalStateException("Duplicate job unique: " + jobKey + " existing=" + this.jobUniqueJobMap);
        }
    }

    protected void assertDuplicateTask(Cron4jTask cron4jTask) {
        if (this.cron4jTaskJobMap.containsKey(cron4jTask.getTaskJobIdentity())) {
            throw new IllegalStateException("Duplicate task: " + (Object)((Object)cron4jTask) + " existing=" + this.cron4jTaskJobMap);
        }
    }

    public OptionalThing<Cron4jJob> findJobByKey(LaJobKey jobKey) {
        this.assertArgumentNotNull("jobKey", jobKey);
        Cron4jJob found = this.jobKeyJobMap.get(jobKey);
        return OptionalThing.ofNullable((Object)found, () -> {
            String msg = "Not found the job by the key: " + jobKey + " existing=" + this.jobKeyJobMap;
            throw new JobNotFoundException(msg);
        });
    }

    public OptionalThing<Cron4jJob> findJobByUniqueOf(LaJobUnique jobUnique) {
        this.assertArgumentNotNull("jobUnique", jobUnique);
        Cron4jJob found = this.jobUniqueJobMap.get(jobUnique);
        return OptionalThing.ofNullable((Object)found, () -> {
            String msg = "Not found the job by the unique code: " + jobUnique + " existing=" + this.jobUniqueJobMap;
            throw new JobNotFoundException(msg);
        });
    }

    public OptionalThing<Cron4jJob> findJobByTask(Cron4jTask.TaskJobIdentity taskJobIdentity) {
        this.assertArgumentNotNull("taskJobIdentity", taskJobIdentity);
        Cron4jJob found = this.cron4jTaskJobMap.get(taskJobIdentity);
        return OptionalThing.ofNullable((Object)found, () -> {
            String msg = "Not found the job by the task: " + taskJobIdentity + " existing=" + this.cron4jTaskJobMap;
            throw new JobNotFoundException(msg);
        });
    }

    public List<Cron4jJob> getJobList() {
        return Collections.unmodifiableList(this.jobOrderedList);
    }

    public List<Cron4jJob> getCron4jJobList() {
        return Collections.unmodifiableList(this.jobOrderedList);
    }

    @Override
    public synchronized void schedule(CronConsumer oneArgLambda) {
        this.assertArgumentNotNull("oneArgLambda", oneArgLambda);
        oneArgLambda.consume(this.createCron4jCron());
    }

    protected Cron4jCron createCron4jCron() {
        return new Cron4jCron(this.cron4jScheduler, this.jobRunner, this, Cron4jCron.CronRegistrationType.CHANGE, this.currentTime, this.isFrameworkDebug());
    }

    public synchronized void clearDisappearedJob() {
        this.getCron4jJobList().stream().filter(job -> job.isDisappeared()).forEach(job -> {
            LaJobKey jobKey = job.getJobKey();
            this.jobKeyJobMap.remove(jobKey);
            this.jobOrderedList.remove(job);
            job.getJobUnique().ifPresent(jobUnique -> this.jobUniqueJobMap.remove(jobUnique));
            this.cron4jTaskJobMap.remove(job.getCron4jTask().getTaskJobIdentity());
        });
    }

    @Override
    public List<LaJobHistory> searchJobHistoryList() {
        Supplier<List> nativeSearcher = () -> Cron4jJobHistory.list();
        return (List)this.jobRunner.getHistoryHook().map(hook -> hook.hookList(nativeSearcher)).orElseGet(() -> (List)nativeSearcher.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupNeighborConcurrent(String groupName, JobConcurrentExec concurrentExec, Set<LaJobKey> jobKeySet) {
        this.assertArgumentNotNull("groupName", groupName);
        if (groupName.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument 'groupName' should not be empty: [" + groupName + "]");
        }
        this.assertArgumentNotNull("concurrentExec", (Object)concurrentExec);
        this.assertArgumentNotNull("jobKeySet", jobKeySet);
        if (jobKeySet.size() <= 1) {
            throw new IllegalArgumentException("The specified jobs should be two or more: " + jobKeySet);
        }
        Map<String, NeighborConcurrentGroup> map = this.neighborConcurrentMap;
        synchronized (map) {
            this.checkDuplicateNeighborConcurrentGroup(groupName);
            Object groupPreparingLock = new Object();
            Object groupRunningLock = new Object();
            CopyOnWriteArraySet<LaJobKey> safeSet = new CopyOnWriteArraySet<LaJobKey>(jobKeySet);
            NeighborConcurrentGroup group = new NeighborConcurrentGroup(groupName, concurrentExec, safeSet, groupPreparingLock, groupRunningLock);
            this.neighborConcurrentMap.put(groupName, group);
            safeSet.stream().map(jobKey -> (Cron4jJob)this.findJobByKey((LaJobKey)jobKey).get()).forEach(job -> job.registerNeighborConcurrent(groupName, group));
        }
    }

    protected void checkDuplicateNeighborConcurrentGroup(String groupName) {
        NeighborConcurrentGroup existingGroup = this.neighborConcurrentMap.get(groupName);
        if (existingGroup != null) {
            String msg = "The groupName already exists: specified=" + groupName + ", existing=" + existingGroup;
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public synchronized void destroy() {
        if (JobChangeLog.isEnabled()) {
            JobChangeLog.log("#job ...Destroying scheduler completely: jobs={} scheduler={}", this.jobKeyJobMap.size(), this.cron4jScheduler);
        }
        new Thread(() -> {
            try {
                this.cron4jScheduler.stop();
            }
            catch (RuntimeException e) {
                String msg = "#job Failed to stop jobs: jobs={} scheduler={}";
                if (JobChangeLog.isEnabled()) {
                    JobChangeLog.log("#job Failed to stop jobs: jobs={} scheduler={}", this.jobKeyJobMap.size(), this.cron4jScheduler, e);
                }
                logger.info("#job Failed to stop jobs: jobs={} scheduler={}", new Object[]{this.jobKeyJobMap.size(), this.cron4jScheduler, e});
            }
            Cron4jJobHistory.clear();
        }).start();
    }

    protected boolean isFrameworkDebug() {
        return this.frameworkDebug;
    }

    protected void assertArgumentNotNull(String variableName, Object value) {
        if (variableName == null) {
            throw new IllegalArgumentException("The variableName should not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The argument '" + variableName + "' should not be null.");
        }
    }

    public String toString() {
        return DfTypeUtil.toClassTitle((Object)this) + ":{scheduled=" + this.jobKeyJobMap.size() + "}@" + Integer.toHexString(this.hashCode());
    }

    public Cron4jScheduler getCron4jScheduler() {
        return this.cron4jScheduler;
    }

    public LaJobRunner getJobRunner() {
        return this.jobRunner;
    }

    public Supplier<LocalDateTime> getCurrentTime() {
        return this.currentTime;
    }

    public Map<LaJobKey, Cron4jJob> getJobKeyJobMap() {
        return Collections.unmodifiableMap(this.jobKeyJobMap);
    }

    public Map<LaJobUnique, Cron4jJob> getJobUniqueJobMap() {
        return Collections.unmodifiableMap(this.jobUniqueJobMap);
    }

    public Map<Cron4jTask.TaskJobIdentity, Cron4jJob> getTaskJobMap() {
        return Collections.unmodifiableMap(this.cron4jTaskJobMap);
    }
}

