/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job.cron4j;

import it.sauronsoftware.cron4j.TaskExecutionContext;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfTypeUtil;
import org.lastaflute.job.LaJob;
import org.lastaflute.job.LaJobRuntime;
import org.lastaflute.job.exception.JobStoppedException;
import org.lastaflute.job.key.LaJobKey;
import org.lastaflute.job.key.LaJobNote;
import org.lastaflute.job.key.LaJobUnique;
import org.lastaflute.job.log.JobNoticeLogLevel;
import org.lastaflute.job.subsidiary.EndTitleRoll;

public class Cron4jRuntime
implements LaJobRuntime {
    protected final LaJobKey jobKey;
    protected final OptionalThing<LaJobNote> jobNote;
    protected final OptionalThing<LaJobUnique> jobUnique;
    protected final String cronExp;
    protected final Class<? extends LaJob> jobType;
    protected final Method runMethod;
    protected final Map<String, Object> parameterMap;
    protected final JobNoticeLogLevel noticeLogLevel;
    protected final LocalDateTime beginTime;
    protected final boolean frameworkDebug;
    protected final TaskExecutionContext cron4jContext;
    protected EndTitleRoll endTitleRollData;
    protected boolean nextTriggerSuppressed;

    public Cron4jRuntime(LaJobKey jobKey, OptionalThing<LaJobNote> jobNote, OptionalThing<LaJobUnique> jobUnique, String cronExp, Class<? extends LaJob> jobType, Map<String, Object> parameterMap, JobNoticeLogLevel noticeLogLevel, LocalDateTime beginTime, boolean frameworkDebug, TaskExecutionContext cron4jContext) {
        this.jobKey = jobKey;
        this.jobNote = jobNote;
        this.jobUnique = jobUnique;
        this.cronExp = cronExp;
        this.jobType = jobType;
        try {
            this.runMethod = jobType.getMethod("run", LaJobRuntime.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Not found the run method in the job: " + jobType, e);
        }
        this.parameterMap = Collections.unmodifiableMap(parameterMap);
        this.noticeLogLevel = noticeLogLevel;
        this.beginTime = beginTime;
        this.frameworkDebug = frameworkDebug;
        this.cron4jContext = cron4jContext;
    }

    @Override
    public LaJobKey getJobKey() {
        return this.jobKey;
    }

    @Override
    public OptionalThing<LaJobNote> getJobNote() {
        return this.jobNote;
    }

    @Override
    public OptionalThing<LaJobUnique> getJobUnique() {
        return this.jobUnique;
    }

    @Override
    public String getCronExp() {
        return this.cronExp;
    }

    @Override
    public Class<? extends LaJob> getJobType() {
        return this.jobType;
    }

    @Override
    public Method getRunMethod() {
        return this.runMethod;
    }

    @Override
    public Map<String, Object> getParameterMap() {
        return this.parameterMap;
    }

    @Override
    public JobNoticeLogLevel getNoticeLogLevel() {
        return this.noticeLogLevel;
    }

    @Override
    public LocalDateTime getBeginTime() {
        return this.beginTime;
    }

    @Override
    public boolean isFrameworkDebug() {
        return this.frameworkDebug;
    }

    @Override
    public OptionalThing<EndTitleRoll> getEndTitleRoll() {
        return OptionalThing.ofNullable((Object)this.endTitleRollData, () -> {
            throw new IllegalStateException("Not found the end-title roll data in the runtime: " + this.toString());
        });
    }

    @Override
    public void showEndTitleRoll(Consumer<EndTitleRoll> dataLambda) {
        this.assertArgumentNotNull("dataLambda", dataLambda);
        if (this.endTitleRollData == null) {
            this.endTitleRollData = this.newEndTitleRoll();
        }
        dataLambda.accept(this.endTitleRollData);
    }

    protected EndTitleRoll newEndTitleRoll() {
        return new EndTitleRoll();
    }

    @Override
    public void stopIfNeeds() {
        if (this.isStopRequested()) {
            throw new JobStoppedException("Stopped the job: " + this.toString());
        }
    }

    protected boolean isStopRequested() {
        return this.cron4jContext.isStopped();
    }

    @Override
    public void suppressNextTrigger() {
        this.nextTriggerSuppressed = true;
    }

    @Override
    public boolean isNextTriggerSuppressed() {
        return this.nextTriggerSuppressed;
    }

    @Override
    public String toCronMethodDisp() {
        return this.cronExp + " " + this.toRunMethodDisp();
    }

    @Override
    public String toRunMethodDisp() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildRunMethodExp()).append(this.buildJobUniqueSuffix());
        return sb.toString();
    }

    protected String buildRunMethodExp() {
        return this.jobType.getSimpleName() + "@" + this.runMethod.getName() + "()";
    }

    protected String buildJobUniqueSuffix() {
        return (String)this.jobUnique.map(uq -> " [" + uq + "]").orElse((Object)"");
    }

    protected void assertArgumentNotNull(String variableName, Object value) {
        if (variableName == null) {
            throw new IllegalArgumentException("The variableName should not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The argument '" + variableName + "' should not be null.");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DfTypeUtil.toClassTitle((Object)this));
        sb.append(":{").append(this.jobKey);
        sb.append((String)this.jobNote.map(title -> ", " + title).orElse((Object)""));
        sb.append((String)this.jobUnique.map(uq -> ", " + uq).orElse((Object)""));
        sb.append(", ").append(this.cronExp);
        sb.append(", ").append(this.jobType.getSimpleName()).append("@").append(this.runMethod.getName()).append("()");
        sb.append(", params=").append(this.parameterMap);
        sb.append("}@").append(Integer.toHexString(this.hashCode()));
        return sb.toString();
    }

    public TaskExecutionContext getCron4jContext() {
        return this.cron4jContext;
    }
}

