/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job.cron4j;

import it.sauronsoftware.cron4j.RomanticCron4jTaskExecutionContext;
import it.sauronsoftware.cron4j.Task;
import it.sauronsoftware.cron4j.TaskExecutionContext;
import it.sauronsoftware.cron4j.TaskExecutor;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.dbflute.bhv.proposal.callback.TraceableSqlAdditionalInfoProvider;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.hook.AccessContext;
import org.dbflute.hook.CallbackContext;
import org.dbflute.hook.SqlFireHook;
import org.dbflute.hook.SqlResultHandler;
import org.dbflute.hook.SqlStringFilter;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfTypeUtil;
import org.lastaflute.core.magic.ThreadCacheContext;
import org.lastaflute.db.dbflute.accesscontext.AccessContextArranger;
import org.lastaflute.db.dbflute.accesscontext.AccessContextResource;
import org.lastaflute.db.dbflute.accesscontext.PreparedAccessContext;
import org.lastaflute.db.dbflute.callbackcontext.traceablesql.RomanticTraceableSqlFireHook;
import org.lastaflute.db.dbflute.callbackcontext.traceablesql.RomanticTraceableSqlResultHandler;
import org.lastaflute.db.dbflute.callbackcontext.traceablesql.RomanticTraceableSqlStringFilter;
import org.lastaflute.job.LaJob;
import org.lastaflute.job.LaJobRunner;
import org.lastaflute.job.LaJobRuntime;
import org.lastaflute.job.cron4j.Cron4jCron;
import org.lastaflute.job.cron4j.Cron4jJob;
import org.lastaflute.job.cron4j.Cron4jJobHistory;
import org.lastaflute.job.cron4j.Cron4jNow;
import org.lastaflute.job.cron4j.Cron4jRuntime;
import org.lastaflute.job.exception.JobConcurrentlyExecutingException;
import org.lastaflute.job.exception.JobLaunchParameterConflictException;
import org.lastaflute.job.key.LaJobKey;
import org.lastaflute.job.key.LaJobNote;
import org.lastaflute.job.key.LaJobUnique;
import org.lastaflute.job.log.JobErrorLog;
import org.lastaflute.job.log.JobErrorResource;
import org.lastaflute.job.log.JobErrorStackTracer;
import org.lastaflute.job.log.JobHistoryHook;
import org.lastaflute.job.log.JobHistoryResource;
import org.lastaflute.job.log.JobNoticeLog;
import org.lastaflute.job.log.JobNoticeLogLevel;
import org.lastaflute.job.subsidiary.ConcurrentJobStopper;
import org.lastaflute.job.subsidiary.CrossVMHook;
import org.lastaflute.job.subsidiary.CrossVMState;
import org.lastaflute.job.subsidiary.EndTitleRoll;
import org.lastaflute.job.subsidiary.ExecResultType;
import org.lastaflute.job.subsidiary.JobConcurrentExec;
import org.lastaflute.job.subsidiary.JobIdentityAttr;
import org.lastaflute.job.subsidiary.LaunchNowOption;
import org.lastaflute.job.subsidiary.NeighborConcurrentGroup;
import org.lastaflute.job.subsidiary.NeighborConcurrentJobStopper;
import org.lastaflute.job.subsidiary.ReadableJobAttr;
import org.lastaflute.job.subsidiary.RunnerResult;
import org.lastaflute.job.subsidiary.TaskRunningState;
import org.lastaflute.job.subsidiary.VaryingCron;
import org.lastaflute.job.subsidiary.VaryingCronOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cron4jTask
extends Task {
    private static final Logger logger = LoggerFactory.getLogger(Cron4jTask.class);
    protected static final String LF = "\n";
    protected VaryingCron varyingCron;
    protected final Class<? extends LaJob> jobType;
    protected final JobConcurrentExec concurrentExec;
    protected final JobThreadNaming threadNaming;
    protected final LaJobRunner jobRunner;
    protected final Cron4jNow cron4jNow;
    protected final Supplier<LocalDateTime> currentTime;
    protected final boolean frameworkDebug;
    protected final TaskRunningState runningState;
    protected final Object preparingLock = new Object();
    protected final Object runningLock = new Object();
    protected final Object varyingLock = new Object();
    protected final TaskJobIdentity taskJobIdentity;
    protected final boolean outlawParallelTask;

    public Cron4jTask(VaryingCron varyingCron, Class<? extends LaJob> jobType, JobConcurrentExec concurrentExec, JobThreadNaming threadNaming, LaJobRunner jobRunner, Cron4jNow cron4jNow, Supplier<LocalDateTime> currentTime, boolean frameworkDebug) {
        this.varyingCron = varyingCron;
        this.jobType = jobType;
        this.concurrentExec = concurrentExec;
        this.threadNaming = threadNaming;
        this.jobRunner = jobRunner;
        this.cron4jNow = cron4jNow;
        this.currentTime = currentTime;
        this.frameworkDebug = frameworkDebug;
        this.runningState = new TaskRunningState(currentTime);
        this.taskJobIdentity = new TaskJobIdentity();
        this.outlawParallelTask = false;
    }

    protected Cron4jTask(VaryingCron varyingCron, Class<? extends LaJob> jobType, JobConcurrentExec concurrentExec, JobThreadNaming threadNaming, LaJobRunner jobRunner, Cron4jNow cron4jNow, Supplier<LocalDateTime> currentTime, boolean frameworkDebug, TaskJobIdentity taskJobIdentity) {
        this.varyingCron = varyingCron;
        this.jobType = jobType;
        this.concurrentExec = concurrentExec;
        this.threadNaming = threadNaming;
        this.jobRunner = jobRunner;
        this.cron4jNow = cron4jNow;
        this.currentTime = currentTime;
        this.frameworkDebug = frameworkDebug;
        this.runningState = new TaskRunningState(currentTime);
        this.taskJobIdentity = taskJobIdentity;
        this.outlawParallelTask = true;
    }

    public void execute(TaskExecutionContext context) {
        OptionalThing<LaunchNowOption> nowOption;
        TaskExecutionContext nativeContext;
        this.debugFw("...Beginning the cron4j task (before run): {}", this.jobType);
        if (context instanceof RomanticCron4jTaskExecutionContext) {
            RomanticCron4jTaskExecutionContext romantic = (RomanticCron4jTaskExecutionContext)context;
            nativeContext = romantic.getNativeContext();
            nowOption = romantic.getLaunchNowOption();
        } else {
            nativeContext = context;
            nowOption = OptionalThing.empty();
        }
        try {
            String msg;
            LocalDateTime activationTime = this.currentTime.get();
            Cron4jJob job = this.findJob();
            Thread jobThread = Thread.currentThread();
            RunnerResult runnerResult = null;
            Throwable controllerCause = null;
            try {
                this.debugFw("...Calling doExecute() of task (before run)", new Object[0]);
                runnerResult = this.doExecute(job, nativeContext, nowOption);
                if (this.canTriggerNext(job, runnerResult)) {
                    this.debugFw("...Calling triggerNext() of job in task (after run)", new Object[0]);
                    job.triggerNext();
                }
            }
            catch (JobConcurrentlyExecutingException e) {
                this.debugFw("...Calling catch clause of job concurrently executing exception: {}", e.getClass().getSimpleName());
                msg = "Cannot execute the job task by concurrent execution: " + this.varyingCron + ", " + this.jobType.getSimpleName();
                this.error((OptionalThing<ReadableJobAttr>)OptionalThing.of((Object)job), msg, e);
                controllerCause = e;
            }
            catch (Throwable cause) {
                this.debugFw("...Calling catch clause of job controller's exception: {}", cause.getClass().getSimpleName());
                msg = "Failed to execute the job task: " + this.varyingCron + ", " + this.jobType.getSimpleName();
                this.error((OptionalThing<ReadableJobAttr>)OptionalThing.of((Object)job), msg, cause);
                controllerCause = cause;
            }
            OptionalThing<RunnerResult> optRunnerResult = this.optRunnerResult(runnerResult);
            OptionalThing<LocalDateTime> endTime = this.deriveEndTime(optRunnerResult);
            this.debugFw("...Calling recordJobHistory() of task (after run): {}, {}", optRunnerResult, endTime);
            this.recordJobHistory(nativeContext, job, jobThread, activationTime, optRunnerResult, endTime, this.optControllerCause(controllerCause), nowOption);
            this.debugFw("...Ending the cron4j task (after run): {}, {}", optRunnerResult, endTime);
        }
        catch (Throwable coreCause) {
            String msg = "Failed to control the job task: " + this.varyingCron + ", " + this.jobType.getSimpleName();
            this.error((OptionalThing<ReadableJobAttr>)OptionalThing.empty(), msg, coreCause);
        }
    }

    protected Cron4jJob findJob() {
        return (Cron4jJob)this.cron4jNow.findJobByTask(this.taskJobIdentity).get();
    }

    protected OptionalThing<LocalDateTime> deriveEndTime(OptionalThing<RunnerResult> runnerResult) {
        return runnerResult.filter(res -> res.getBeginTime().isPresent()).map(res -> this.currentTime.get());
    }

    protected OptionalThing<RunnerResult> optRunnerResult(RunnerResult runnerResult) {
        return OptionalThing.ofNullable((Object)runnerResult, () -> {
            throw new IllegalStateException("Not found the runner result.");
        });
    }

    protected OptionalThing<Throwable> optControllerCause(Throwable controllerCause) {
        return OptionalThing.ofNullable((Object)controllerCause, () -> {
            throw new IllegalStateException("Not found the controller cause.");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RunnerResult doExecute(Cron4jJob job, TaskExecutionContext context, OptionalThing<LaunchNowOption> nowOption) {
        VaryingCronOption cronOption;
        String cronExp;
        this.debugFw("...Locking varying lock (before run): {}", this.varyingLock);
        Object object = this.varyingLock;
        synchronized (object) {
            cronExp = this.varyingCron.getCronExp();
            cronOption = this.varyingCron.getCronOption();
        }
        List<NeighborConcurrentGroup> neighborConcurrentGroupList = job.getNeighborConcurrentGroupList();
        this.debugFw("...Locking preparing lock (before run): {}", this.preparingLock);
        Object object2 = this.preparingLock;
        synchronized (object2) {
            OptionalThing<RunnerResult> concurrentResult = this.stopConcurrentJobIfNeeds(job);
            if (concurrentResult.isPresent()) {
                return (RunnerResult)concurrentResult.get();
            }
            OptionalThing<RunnerResult> neighborConcurrentResult = this.synchronizedNeighborPreparing(neighborConcurrentGroupList.iterator(), () -> {
                OptionalThing<RunnerResult> result = this.stopNeighborConcurrentJobIfNeeds(job, neighborConcurrentGroupList);
                if (!result.isPresent()) {
                    this.sleepForLockableLife();
                    this.debugFw("...Locking running lock (before run): {}", this.runningLock);
                    Object object = this.runningLock;
                    synchronized (object) {
                        this.debugFw("...Locking running state in preparing and running lock (before run): {}", this.runningState);
                        this.synchronizedNeighborRunning(neighborConcurrentGroupList.iterator(), () -> {
                            TaskRunningState taskRunningState = this.runningState;
                            synchronized (taskRunningState) {
                                this.runningState.begin();
                            }
                            return null;
                        });
                    }
                }
                return result;
            });
            if (neighborConcurrentResult.isPresent()) {
                return (RunnerResult)neighborConcurrentResult.get();
            }
        }
        this.debugFw("...Locking running lock (before run): {}", this.runningLock);
        object2 = this.runningLock;
        synchronized (object2) {
            RunnerResult runnerResult;
            try {
                runnerResult = this.synchronizedNeighborRunning(neighborConcurrentGroupList.iterator(), () -> {
                    LocalDateTime endTime;
                    RunnerResult runnerResult;
                    OptionalThing<CrossVMState> crossVMState;
                    if (!this.runningState.getBeginTime().isPresent()) {
                        this.runningState.begin();
                    }
                    if ((crossVMState = this.crossVMBeginning(job, nowOption)).isPresent() && ((CrossVMState)crossVMState.get()).isQuit()) {
                        return RunnerResult.asQuitByConcurrent();
                    }
                    try {
                        this.debugFw("...Calling actuallyExecute() of task (before run): {}", job);
                        runnerResult = this.actuallyExecute(job, cronExp, cronOption, context, nowOption);
                    }
                    finally {
                        this.debugFw("...Calling finally clause of job execution (after run)", new Object[0]);
                        endTime = this.currentTime.get();
                        this.crossVMEnding(job, crossVMState, endTime, nowOption);
                    }
                    runnerResult.acceptEndTime(endTime);
                    return runnerResult;
                });
            }
            catch (Throwable throwable) {
                this.debugFw("...Locking running state in running lock (after run): {}", this.runningState);
                TaskRunningState taskRunningState = this.runningState;
                synchronized (taskRunningState) {
                    if (this.runningState.getBeginTime().isPresent()) {
                        this.runningState.end();
                    }
                }
                throw throwable;
            }
            this.debugFw("...Locking running state in running lock (after run): {}", this.runningState);
            TaskRunningState taskRunningState = this.runningState;
            synchronized (taskRunningState) {
                if (this.runningState.getBeginTime().isPresent()) {
                    this.runningState.end();
                }
            }
            return runnerResult;
        }
    }

    protected void sleepForLockableLife() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OptionalThing<RunnerResult> stopConcurrentJobIfNeeds(Cron4jJob job) {
        TaskRunningState taskRunningState = this.runningState;
        synchronized (taskRunningState) {
            OptionalThing<RunnerResult> concurrentResult = this.createConcurrentJobStopper().stopIfNeeds(job, () -> ((LocalDateTime)this.runningState.getBeginTime().get()).toString());
            if (concurrentResult.isPresent()) {
                return concurrentResult;
            }
        }
        return OptionalThing.empty();
    }

    protected ConcurrentJobStopper createConcurrentJobStopper() {
        return new ConcurrentJobStopper(unused -> this.isRunningNow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OptionalThing<RunnerResult> synchronizedNeighborPreparing(Iterator<NeighborConcurrentGroup> groupIte, Supplier<OptionalThing<RunnerResult>> runner) {
        if (groupIte.hasNext()) {
            NeighborConcurrentGroup group = groupIte.next();
            Object object = group.getGroupPreparingLock();
            synchronized (object) {
                return this.synchronizedNeighborPreparing(groupIte, runner);
            }
        }
        return runner.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RunnerResult synchronizedNeighborRunning(Iterator<NeighborConcurrentGroup> groupIte, Supplier<RunnerResult> runner) {
        if (groupIte.hasNext()) {
            NeighborConcurrentGroup group = groupIte.next();
            Object object = group.getGroupRunningLock();
            synchronized (object) {
                return this.synchronizedNeighborRunning(groupIte, runner);
            }
        }
        return runner.get();
    }

    protected OptionalThing<RunnerResult> stopNeighborConcurrentJobIfNeeds(Cron4jJob job, List<NeighborConcurrentGroup> neighborConcurrentGroupList) {
        return this.createNeighborConcurrentJobStopper(neighborConcurrentGroupList).stopIfNeeds(job, jobState -> (String)jobState.mapExecutingNow(execState -> execState.getBeginTime().toString()).orElseGet(() -> "*the job have just ended now"));
    }

    protected NeighborConcurrentJobStopper createNeighborConcurrentJobStopper(List<NeighborConcurrentGroup> neighborConcurrentGroupList) {
        return new NeighborConcurrentJobStopper(jobState -> jobState.isExecutingNow(), jobKey -> this.cron4jNow.findJobByKey((LaJobKey)jobKey), neighborConcurrentGroupList);
    }

    protected RunnerResult actuallyExecute(JobIdentityAttr identityProvider, String cronExp, VaryingCronOption cronOption, TaskExecutionContext context, OptionalThing<LaunchNowOption> nowOption) {
        this.adjustThreadNameIfNeeds(cronOption);
        return this.runJob(identityProvider, cronExp, cronOption, context, nowOption);
    }

    protected void adjustThreadNameIfNeeds(VaryingCronOption cronOption) {
        JobThreadNamingOption option = new JobThreadNamingOption();
        if (this.outlawParallelTask) {
            option.asAlwaysHash();
        }
        String threadName = this.threadNaming.buildName(option);
        Thread currentThread = Thread.currentThread();
        if (currentThread.getName().equals(threadName)) {
            return;
        }
        currentThread.setName(threadName);
    }

    protected RunnerResult runJob(JobIdentityAttr identityProvider, String cronExp, VaryingCronOption cronOption, TaskExecutionContext cron4jContext, OptionalThing<LaunchNowOption> nowOption) {
        LocalDateTime beginTime = (LocalDateTime)this.runningState.getBeginTime().get();
        this.debugFw("...Calling run() of job runner in task (before run): beginTime={}", beginTime);
        return this.jobRunner.run(this.jobType, () -> this.createCron4jRuntime(identityProvider, cronExp, cronOption, beginTime, cron4jContext, nowOption)).acceptEndTime(this.currentTime.get());
    }

    protected Cron4jRuntime createCron4jRuntime(JobIdentityAttr identityProvider, String cronExp, VaryingCronOption cronOption, LocalDateTime beginTime, TaskExecutionContext cron4jContext, OptionalThing<LaunchNowOption> nowOption) {
        LaJobKey jobKey = identityProvider.getJobKey();
        OptionalThing<LaJobNote> jobNote = identityProvider.getJobNote();
        OptionalThing<LaJobUnique> jobUnique = identityProvider.getJobUnique();
        Map<String, Object> parameterMap = this.prepareParameterMap(cronOption, nowOption);
        JobNoticeLogLevel noticeLogLevel = cronOption.getNoticeLogLevel();
        return new Cron4jRuntime(jobKey, jobNote, jobUnique, cronExp, this.jobType, parameterMap, noticeLogLevel, beginTime, this.isFrameworkDebug(), cron4jContext);
    }

    protected Map<String, Object> prepareParameterMap(VaryingCronOption cronOption, OptionalThing<LaunchNowOption> nowOption) {
        Map<String, Object> byCronMap = this.extractParameterMap(cronOption);
        return nowOption.isPresent() ? this.mergeParameterMap(byCronMap, (LaunchNowOption)nowOption.get()) : byCronMap;
    }

    protected Map<String, Object> extractParameterMap(VaryingCronOption cronOption) {
        return (Map)cronOption.getParamsSupplier().map(supplier -> supplier.supply()).orElse(Collections.emptyMap());
    }

    protected Map<String, Object> mergeParameterMap(Map<String, Object> byCronMap, LaunchNowOption nowOption) {
        Map<String, Object> byLaunchMap = nowOption.getParameterMap();
        if (!nowOption.isPriorParams()) {
            byCronMap.keySet().forEach(key -> {
                if (byLaunchMap.containsKey(key)) {
                    this.throwJobLaunchParameterConflictException(byCronMap, byLaunchMap);
                }
            });
        }
        LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
        parameterMap.putAll(byCronMap);
        parameterMap.putAll(byLaunchMap);
        return Collections.unmodifiableMap(parameterMap);
    }

    protected void throwJobLaunchParameterConflictException(Map<String, Object> byCronMap, Map<String, Object> byLaunchMap) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Conflicted the key of launch parameter.");
        br.addItem("Advice");
        br.addElement((Object)"You cannot use the launch parameter key");
        br.addElement((Object)"that is same as cron paramter key.");
        br.addElement((Object)"Or you can override by launch parameter option.");
        br.addItem("Cron Parameter");
        br.addElement(byCronMap.keySet());
        br.addItem("Launch Parameter");
        br.addElement(byLaunchMap.keySet());
        String msg = br.buildExceptionMessage();
        throw new JobLaunchParameterConflictException(msg);
    }

    protected boolean canTriggerNext(Cron4jJob job, RunnerResult runnerResult) {
        return !runnerResult.getCause().isPresent() && !runnerResult.isNextTriggerSuppressed();
    }

    protected OptionalThing<CrossVMState> crossVMBeginning(Cron4jJob job, OptionalThing<LaunchNowOption> nowOption) {
        return this.jobRunner.getCrossVMHook().map(hook -> {
            Method hookMethod = this.findHookMethod(hook, "hookBeginning");
            this.arrangeHookThreadCacheContext();
            this.jobRunner.getAccessContextArranger().ifPresent(arranger -> this.arrangeHookPreparedAccessContext((AccessContextArranger)arranger, hook, hookMethod, job, nowOption));
            this.arrangeHookCallbackContext(hook, hookMethod, job);
            try {
                this.showCrossVMBeginning(job, (CrossVMHook)hook);
                CrossVMState crossVMState = hook.hookBeginning(job, (LocalDateTime)this.runningState.getBeginTime().get());
                return crossVMState;
            }
            finally {
                this.clearHookCallbackContext();
                this.clearHookPreparedAccessContext();
                this.clearHookThreadCacheContext();
            }
        });
    }

    protected void showCrossVMBeginning(Cron4jJob job, CrossVMHook hook) {
        if (!hook.suppressesNoticeLog()) {
            JobNoticeLog.log(this.getCrossVMHookNoticeLogLovel(job), () -> "#flow #job ...hookBeginning crossVM for the job: " + job.toIdentityDisp());
        }
    }

    protected void crossVMEnding(Cron4jJob job, OptionalThing<CrossVMState> crossVMState, LocalDateTime endTime, OptionalThing<LaunchNowOption> nowOption) {
        if (!crossVMState.isPresent()) {
            return;
        }
        this.jobRunner.getCrossVMHook().alwaysPresent(hook -> {
            Method hookMethod = this.findHookMethod(hook, "hookEnding");
            this.arrangeHookThreadCacheContext();
            this.jobRunner.getAccessContextArranger().ifPresent(arranger -> this.arrangeHookPreparedAccessContext((AccessContextArranger)arranger, hook, hookMethod, job, nowOption));
            this.arrangeHookCallbackContext(hook, hookMethod, job);
            try {
                this.showCrossVMEnding(job, (CrossVMHook)hook);
                hook.hookEnding(job, (CrossVMState)crossVMState.get(), endTime);
            }
            finally {
                this.clearHookCallbackContext();
                this.clearHookPreparedAccessContext();
                this.clearHookThreadCacheContext();
            }
        });
    }

    protected void showCrossVMEnding(Cron4jJob job, CrossVMHook hook) {
        if (!hook.suppressesNoticeLog()) {
            JobNoticeLog.log(this.getCrossVMHookNoticeLogLovel(job), () -> "#flow #job ...hookEnding crossVM for the job: " + job.toIdentityDisp());
        }
    }

    protected JobNoticeLogLevel getCrossVMHookNoticeLogLovel(Cron4jJob job) {
        return job.getNoticeLogLevel();
    }

    protected void recordJobHistory(TaskExecutionContext context, Cron4jJob job, Thread jobThread, LocalDateTime activationTime, OptionalThing<RunnerResult> runnerResult, OptionalThing<LocalDateTime> endTime, OptionalThing<Throwable> controllerCause, OptionalThing<LaunchNowOption> nowOption) {
        TaskExecutor taskExecutor = context.getTaskExecutor();
        Cron4jJobHistory jobHistory = this.prepareJobHistory(job, activationTime, runnerResult, endTime, controllerCause);
        int historyLimit = this.getHistoryLimit();
        this.jobRunner.getHistoryHook().ifPresent(hook -> {
            Method hookMethod = this.findHookMethod(hook, "hookRecord");
            this.arrangeHookThreadCacheContext();
            this.jobRunner.getAccessContextArranger().ifPresent(arranger -> this.arrangeHookPreparedAccessContext((AccessContextArranger)arranger, hook, hookMethod, job, nowOption));
            this.arrangeHookCallbackContext(hook, hookMethod, job);
            try {
                this.showJobHistoryHookRecording(job, (JobHistoryHook)hook);
                hook.hookRecord(jobHistory, new JobHistoryResource(historyLimit));
            }
            finally {
                this.clearHookCallbackContext();
                this.clearHookPreparedAccessContext();
                this.clearHookThreadCacheContext();
            }
        });
        Cron4jJobHistory.record(taskExecutor, jobHistory, historyLimit);
    }

    protected Cron4jJobHistory prepareJobHistory(Cron4jJob job, LocalDateTime activationTime, OptionalThing<RunnerResult> runnerResult, OptionalThing<LocalDateTime> endTime, OptionalThing<Throwable> controllerCause) {
        OptionalThing beginTime = runnerResult.flatMap(res -> res.getBeginTime());
        Cron4jJobHistory jobHistory = !controllerCause.isPresent() ? this.createJobHistory(job, activationTime, (OptionalThing<LocalDateTime>)beginTime, endTime, () -> this.deriveRunnerExecResultType(runnerResult), (OptionalThing<EndTitleRoll>)runnerResult.flatMap(res -> res.getEndTitleRoll()), (OptionalThing<Throwable>)runnerResult.flatMap(res -> res.getCause())) : (controllerCause.get() instanceof JobConcurrentlyExecutingException ? this.createJobHistory(job, activationTime, (OptionalThing<LocalDateTime>)beginTime, endTime, () -> ExecResultType.ERROR_BY_CONCURRENT, (OptionalThing<EndTitleRoll>)OptionalThing.empty(), controllerCause) : this.createJobHistory(job, activationTime, (OptionalThing<LocalDateTime>)beginTime, endTime, () -> ExecResultType.CAUSED_BY_FRAMEWORK, (OptionalThing<EndTitleRoll>)OptionalThing.empty(), controllerCause));
        return jobHistory;
    }

    protected ExecResultType deriveRunnerExecResultType(OptionalThing<RunnerResult> runnerResult) {
        return (ExecResultType)((Object)runnerResult.map(res -> {
            if (res.getCause().isPresent()) {
                return ExecResultType.CAUSED_BY_APPLICATION;
            }
            if (res.isQuitByConcurrent()) {
                return ExecResultType.QUIT_BY_CONCURRENT;
            }
            return ExecResultType.SUCCESS;
        }).orElseGet(() -> ExecResultType.SUCCESS));
    }

    protected Cron4jJobHistory createJobHistory(Cron4jJob job, LocalDateTime activationTime, OptionalThing<LocalDateTime> beginTime, OptionalThing<LocalDateTime> endTime, Supplier<ExecResultType> execResultTypeProvider, OptionalThing<EndTitleRoll> endTitleRoll, OptionalThing<Throwable> cause) {
        LaJobKey jobKey = job.getJobKey();
        OptionalThing<LaJobNote> jobNote = job.getJobNote();
        OptionalThing<LaJobUnique> jobUnique = job.getJobUnique();
        OptionalThing<String> cronExp = job.getCronExp();
        String jobTypeFqcn = job.getJobType().getName();
        ExecResultType execResultType = execResultTypeProvider.get();
        return new Cron4jJobHistory(jobKey, jobNote, jobUnique, cronExp, jobTypeFqcn, activationTime, beginTime, endTime, execResultType, endTitleRoll, cause);
    }

    protected int getHistoryLimit() {
        return 300;
    }

    protected void showJobHistoryHookRecording(Cron4jJob job, JobHistoryHook hook) {
        if (!hook.suppressesNoticeLog()) {
            JobNoticeLog.log(this.getJobHistoryHookNoticeLogLovel(job), () -> "#flow #job ...hookRecording job history for the job: " + job.toIdentityDisp());
        }
    }

    protected JobNoticeLogLevel getJobHistoryHookNoticeLogLovel(Cron4jJob job) {
        return job.getNoticeLogLevel();
    }

    protected void error(OptionalThing<ReadableJobAttr> jobAttr, String msg, Throwable cause) {
        String bigMsg = (msg + LF + new JobErrorStackTracer().buildExceptionStackTrace(cause)).trim();
        this.jobRunner.getErrorLogHook().ifPresent(hook -> hook.hookError(new JobErrorResource((OptionalThing<? extends ReadableJobAttr>)jobAttr, (OptionalThing<LaJobRuntime>)OptionalThing.empty(), bigMsg, cause)));
        JobErrorLog.log(bigMsg);
    }

    protected void arrangeHookThreadCacheContext() {
        ThreadCacheContext.initialize();
    }

    protected void clearHookThreadCacheContext() {
        ThreadCacheContext.clear();
    }

    protected void arrangeHookPreparedAccessContext(AccessContextArranger arranger, Object hook, Method hookMethod, Cron4jJob job, OptionalThing<LaunchNowOption> nowOption) {
        Map parameterMap;
        String moduleName = DfTypeUtil.toClassTitle(hook.getClass());
        AccessContextResource resource = new AccessContextResource(moduleName, hookMethod, parameterMap = (Map)nowOption.map(op -> op.getParameterMap()).orElseGet(() -> Collections.emptyMap()));
        AccessContext context = arranger.arrangePreparedAccessContext(resource);
        if (context == null) {
            String msg = "Cannot return null from access context arranger: " + arranger + " job=" + job.toIdentityDisp();
            throw new IllegalStateException(msg);
        }
        PreparedAccessContext.setAccessContextOnThread((AccessContext)context);
    }

    protected void clearHookPreparedAccessContext() {
        PreparedAccessContext.clearAccessContextOnThread();
    }

    protected void arrangeHookCallbackContext(Object hook, Method hookMethod, Cron4jJob job) {
        CallbackContext.setSqlFireHookOnThread((SqlFireHook)this.createHookSqlFireHook());
        CallbackContext.setSqlStringFilterOnThread((SqlStringFilter)this.createHookSqlStringFilter(hook, hookMethod, job));
        CallbackContext.setSqlResultHandlerOnThread((SqlResultHandler)this.createHookSqlResultHandler());
    }

    protected SqlFireHook createHookSqlFireHook() {
        return this.newHookRomanticTraceableSqlFireHook();
    }

    protected RomanticTraceableSqlFireHook newHookRomanticTraceableSqlFireHook() {
        return new RomanticTraceableSqlFireHook();
    }

    protected SqlStringFilter createHookSqlStringFilter(Object hook, Method hookMethod, Cron4jJob job) {
        return this.newHookRomanticTraceableSqlStringFilter(hookMethod, () -> this.buildHookSqlMarkingAdditionalInfo(hook, job));
    }

    protected String buildHookSqlMarkingAdditionalInfo(Object hook, Cron4jJob job) {
        return "(" + hook.getClass().getSimpleName() + ", " + job.toIdentityDisp() + ")";
    }

    protected RomanticTraceableSqlStringFilter newHookRomanticTraceableSqlStringFilter(Method actionMethod, TraceableSqlAdditionalInfoProvider additionalInfoProvider) {
        return new RomanticTraceableSqlStringFilter(actionMethod, additionalInfoProvider);
    }

    protected SqlResultHandler createHookSqlResultHandler() {
        return this.newHookRomanticTraceableSqlResultHandler();
    }

    protected RomanticTraceableSqlResultHandler newHookRomanticTraceableSqlResultHandler() {
        return new RomanticTraceableSqlResultHandler();
    }

    protected void clearHookCallbackContext() {
        CallbackContext.clearSqlResultHandlerOnThread();
        CallbackContext.clearSqlStringFilterOnThread();
        CallbackContext.clearSqlFireHookOnThread();
    }

    protected Method findHookMethod(Object hook, String methodName) {
        Method hookMethod = Stream.of(hook.getClass().getMethods()).filter(method -> method.getName().equals(methodName)).findFirst().orElseThrow(() -> new IllegalStateException("Not found the method in hook: " + methodName + ", " + hook));
        return hookMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void becomeNonCrom() {
        Object object = this.varyingLock;
        synchronized (object) {
            this.varyingCron = this.createVaryingCron(Cron4jCron.NON_CRON, this.varyingCron.getCronOption());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchCron(String cronExp, VaryingCronOption cronOption) {
        Object object = this.varyingLock;
        synchronized (object) {
            this.varyingCron = this.createVaryingCron(cronExp, cronOption);
        }
    }

    protected VaryingCron createVaryingCron(String cronExp, VaryingCronOption cronOption) {
        return new VaryingCron(cronExp, cronOption);
    }

    public boolean canBeStopped() {
        return true;
    }

    public boolean isNonCron() {
        return Cron4jCron.isNonCronExp(this.varyingCron.getCronExp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RESULT> OptionalThing<RESULT> syncRunningCall(Function<TaskRunningState, RESULT> oneArgLambda) {
        TaskRunningState taskRunningState = this.runningState;
        synchronized (taskRunningState) {
            if (this.runningState.getBeginTime().isPresent()) {
                return OptionalThing.ofNullable(oneArgLambda.apply(this.runningState), () -> {
                    throw new IllegalStateException("Not found the result from your scope: " + this.jobType);
                });
            }
            return OptionalThing.ofNullable(null, () -> {
                throw new IllegalStateException("Not running now: " + this.jobType);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncRunningOnceEnded() {
        TaskRunningState taskRunningState = this.runningState;
        synchronized (taskRunningState) {
            return this.runningState.isOnceEnded();
        }
    }

    protected void debugFw(String msg, Object ... args) {
        if (this.isFrameworkDebug()) {
            logger.info("#job #fw " + msg, args);
        }
    }

    protected boolean isFrameworkDebug() {
        return this.frameworkDebug;
    }

    public Cron4jTask createOutlawParallelTask() {
        return new Cron4jTask(this.varyingCron, this.jobType, this.concurrentExec, this.threadNaming, this.jobRunner, this.cron4jNow, this.currentTime, this.frameworkDebug, this.taskJobIdentity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        VaryingCronOption cronOption;
        String cronExpExp;
        String title = DfTypeUtil.toClassTitle((Object)((Object)this));
        Object object = this.varyingLock;
        synchronized (object) {
            cronExpExp = this.isNonCron() ? "non-cron" : this.varyingCron.getCronExp();
            cronOption = this.varyingCron.getCronOption();
        }
        return title + ":{" + cronExpExp + ", " + this.jobType.getName() + ", " + (Object)((Object)this.concurrentExec) + ", " + cronOption + "}";
    }

    public VaryingCron getVaryingCron() {
        return this.varyingCron;
    }

    public Class<? extends LaJob> getJobType() {
        return this.jobType;
    }

    public JobConcurrentExec getConcurrentExec() {
        return this.concurrentExec;
    }

    public Object getPreparingLock() {
        return this.preparingLock;
    }

    public Object getRunningLock() {
        return this.runningLock;
    }

    public Object getVaryingLock() {
        return this.varyingLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunningNow() {
        TaskRunningState taskRunningState = this.runningState;
        synchronized (taskRunningState) {
            return this.runningState.getBeginTime().isPresent();
        }
    }

    public TaskRunningState getRunningState() {
        return this.runningState;
    }

    public TaskJobIdentity getTaskJobIdentity() {
        return this.taskJobIdentity;
    }

    public static class TaskJobIdentity {
    }

    public static class JobThreadNamingOption {
        protected boolean alwaysHash;

        public JobThreadNamingOption asAlwaysHash() {
            this.alwaysHash = true;
            return this;
        }

        public boolean isAlwaysHash() {
            return this.alwaysHash;
        }
    }

    public static interface JobThreadNaming {
        public String buildName(JobThreadNamingOption var1);
    }
}

