/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job.log;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobChangeLog {
    private static final Logger logger = LoggerFactory.getLogger(JobChangeLog.class);
    protected static boolean _logLevelDebug;
    protected static boolean _loggingInHolidayMood;
    protected static boolean _locked;

    public static void log(String msg, Object ... args) {
        if (_logLevelDebug) {
            logger.debug(msg, args);
        } else {
            logger.info(msg, args);
        }
    }

    public static boolean isEnabled() {
        if (_loggingInHolidayMood) {
            return false;
        }
        if (_logLevelDebug) {
            return logger.isDebugEnabled();
        }
        return logger.isInfoEnabled();
    }

    public static void setLogLevelDebug(boolean logLevelDebug) {
        JobChangeLog.assertUnlocked();
        if (logger.isInfoEnabled()) {
            logger.info("...Setting job-change logLevelDebug: " + logLevelDebug);
        }
        _logLevelDebug = logLevelDebug;
        JobChangeLog.lock();
    }

    protected static boolean isLoggingInHolidayMood() {
        return _loggingInHolidayMood;
    }

    public static void setLoggingInHolidayMood(boolean loggingInHolidayMood) {
        JobChangeLog.assertUnlocked();
        if (logger.isInfoEnabled()) {
            logger.info("...Setting job-change loggingInHolidayMood: " + loggingInHolidayMood);
        }
        _loggingInHolidayMood = loggingInHolidayMood;
        JobChangeLog.lock();
    }

    public static boolean isLocked() {
        return _locked;
    }

    public static void lock() {
        if (_locked) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("...Locking the log object for job!");
        }
        _locked = true;
    }

    public static void unlock() {
        if (!_locked) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("...Unlocking the log object for job!");
        }
        _locked = false;
    }

    protected static void assertUnlocked() {
        if (!JobChangeLog.isLocked()) {
            return;
        }
        throw new IllegalStateException("The job change log is locked.");
    }

    static {
        _locked = true;
    }
}

