/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job.mock;

import it.sauronsoftware.cron4j.Scheduler;
import it.sauronsoftware.cron4j.TaskExecutionContext;
import it.sauronsoftware.cron4j.TaskExecutor;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.dbflute.optional.OptionalThing;
import org.lastaflute.job.LaJob;
import org.lastaflute.job.LaJobRuntime;
import org.lastaflute.job.cron4j.Cron4jRuntime;
import org.lastaflute.job.key.LaJobKey;
import org.lastaflute.job.key.LaJobNote;
import org.lastaflute.job.key.LaJobUnique;
import org.lastaflute.job.log.JobNoticeLogLevel;
import org.lastaflute.job.mock.MockJob;
import org.lastaflute.job.mock.MockTaskExecutionContext;
import org.lastaflute.job.subsidiary.CronOption;
import org.lastaflute.job.subsidiary.EndTitleRoll;
import org.lastaflute.job.subsidiary.InitialCronOpCall;

public class MockJobRuntime
implements LaJobRuntime {
    protected static final String MOCK_CRON_EXP = "* * * * *";
    protected final Cron4jRuntime cron4jRuntime;

    public MockJobRuntime(String cronExp, Class<? extends LaJob> jobType, CronOption cronOption, TaskExecutionContext cron4jContext) {
        LaJobKey jobKey = LaJobKey.of("mockKey_" + jobType.getSimpleName());
        Map parameterMap = (Map)cronOption.getParamsSupplier().map(supplier -> supplier.supply()).orElse(Collections.emptyMap());
        JobNoticeLogLevel noticeLogLevel = cronOption.getNoticeLogLevel();
        LocalDateTime beginTime = LocalDateTime.now();
        boolean frameworkDebug = this.determineFrameworkDebug();
        this.cron4jRuntime = new Cron4jRuntime(jobKey, cronOption.getJobNote(), cronOption.getJobUnique(), cronExp, jobType, parameterMap, noticeLogLevel, beginTime, frameworkDebug, cron4jContext);
    }

    protected boolean determineFrameworkDebug() {
        return false;
    }

    public static MockJobRuntime asDefault() {
        return MockJobRuntime.createRuntime(MOCK_CRON_EXP, MockJob.class, op -> {});
    }

    public static MockJobRuntime of(Class<? extends LaJob> jobType) {
        return MockJobRuntime.createRuntime(MOCK_CRON_EXP, jobType, op -> {});
    }

    public static MockJobRuntime of(Class<? extends LaJob> jobType, InitialCronOpCall opLambda) {
        return MockJobRuntime.createRuntime(MOCK_CRON_EXP, jobType, opLambda);
    }

    @Deprecated
    public static MockJobRuntime withParameter(Map<String, Object> parameterMap) {
        return MockJobRuntime.createRuntime(MOCK_CRON_EXP, MockJob.class, op -> op.params(() -> parameterMap));
    }

    protected static MockJobRuntime createRuntime(String cronExp, Class<? extends LaJob> jobType, InitialCronOpCall opLambda) {
        CronOption option = new CronOption();
        opLambda.callback(option);
        return new MockJobRuntime(cronExp, jobType, option, MockJobRuntime.createMockContext());
    }

    protected static MockTaskExecutionContext createMockContext() {
        Scheduler scheduler = new Scheduler();
        TaskExecutor taskExecutor = null;
        return new MockTaskExecutionContext(scheduler, taskExecutor);
    }

    public Map<String, Object> getEndTitleRollMap() {
        return (Map)this.getEndTitleRoll().map(roll -> roll.getDataMap()).orElse(Collections.emptyMap());
    }

    public String toString() {
        return "mock:{" + this.cron4jRuntime + "}";
    }

    @Override
    public LaJobKey getJobKey() {
        return this.cron4jRuntime.getJobKey();
    }

    @Override
    public OptionalThing<LaJobNote> getJobNote() {
        return this.cron4jRuntime.getJobNote();
    }

    @Override
    public OptionalThing<LaJobUnique> getJobUnique() {
        return this.cron4jRuntime.getJobUnique();
    }

    @Override
    public String getCronExp() {
        return this.cron4jRuntime.getCronExp();
    }

    @Override
    public Class<? extends LaJob> getJobType() {
        return this.cron4jRuntime.getJobType();
    }

    @Override
    public Method getRunMethod() {
        return this.cron4jRuntime.getRunMethod();
    }

    @Override
    public Map<String, Object> getParameterMap() {
        return this.cron4jRuntime.getParameterMap();
    }

    @Override
    public JobNoticeLogLevel getNoticeLogLevel() {
        return this.cron4jRuntime.getNoticeLogLevel();
    }

    @Override
    public LocalDateTime getBeginTime() {
        return this.cron4jRuntime.getBeginTime();
    }

    @Override
    public boolean isFrameworkDebug() {
        return this.cron4jRuntime.isFrameworkDebug();
    }

    @Override
    public OptionalThing<EndTitleRoll> getEndTitleRoll() {
        return this.cron4jRuntime.getEndTitleRoll();
    }

    @Override
    public void showEndTitleRoll(Consumer<EndTitleRoll> dataLambda) {
        this.cron4jRuntime.showEndTitleRoll(dataLambda);
    }

    @Override
    public void stopIfNeeds() {
        this.cron4jRuntime.stopIfNeeds();
    }

    @Override
    public void suppressNextTrigger() {
        this.cron4jRuntime.suppressNextTrigger();
    }

    @Override
    public boolean isNextTriggerSuppressed() {
        return this.cron4jRuntime.isNextTriggerSuppressed();
    }

    @Override
    public String toCronMethodDisp() {
        return this.cron4jRuntime.toCronMethodDisp();
    }

    @Override
    public String toRunMethodDisp() {
        return this.cron4jRuntime.toRunMethodDisp();
    }
}

