/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.job.subsidiary;

import java.time.LocalDateTime;
import org.dbflute.optional.OptionalThing;
import org.lastaflute.job.subsidiary.EndTitleRoll;

public class RunnerResult {
    protected final OptionalThing<LocalDateTime> beginTime;
    protected OptionalThing<LocalDateTime> endTime = OptionalThing.empty();
    protected final OptionalThing<EndTitleRoll> endTitleRoll;
    protected final OptionalThing<Throwable> cause;
    protected final boolean nextTriggerSuppressed;
    protected final boolean quitByConcurrent;

    protected RunnerResult(OptionalThing<LocalDateTime> beginTime, OptionalThing<EndTitleRoll> endTitleRoll, OptionalThing<Throwable> cause, boolean nextTriggerSuppressed, boolean quitByConcurrent) {
        this.beginTime = beginTime;
        this.endTitleRoll = endTitleRoll;
        this.cause = cause;
        this.nextTriggerSuppressed = nextTriggerSuppressed;
        this.quitByConcurrent = quitByConcurrent;
    }

    public static RunnerResult asExecuted(LocalDateTime beginTime, OptionalThing<EndTitleRoll> endTitleRoll, OptionalThing<Throwable> cause, boolean nextTriggerSuppressed) {
        return new RunnerResult((OptionalThing<LocalDateTime>)OptionalThing.of((Object)beginTime), endTitleRoll, cause, nextTriggerSuppressed, false);
    }

    public static RunnerResult asQuitByConcurrent() {
        return new RunnerResult((OptionalThing<LocalDateTime>)OptionalThing.empty(), (OptionalThing<EndTitleRoll>)OptionalThing.empty(), (OptionalThing<Throwable>)OptionalThing.empty(), false, true);
    }

    public RunnerResult acceptEndTime(LocalDateTime endTime) {
        this.endTime = OptionalThing.of((Object)endTime);
        return this;
    }

    public String toString() {
        return "result:{begin=" + this.beginTime + ", endTitleRoll=" + this.endTitleRoll.isPresent() + ", cause=" + this.cause.isPresent() + "}";
    }

    public OptionalThing<LocalDateTime> getBeginTime() {
        return this.beginTime;
    }

    public OptionalThing<LocalDateTime> getEndTime() {
        return this.endTime;
    }

    public OptionalThing<EndTitleRoll> getEndTitleRoll() {
        return this.endTitleRoll;
    }

    public OptionalThing<Throwable> getCause() {
        return this.cause;
    }

    public boolean isNextTriggerSuppressed() {
        return this.nextTriggerSuppressed;
    }

    public boolean isQuitByConcurrent() {
        return this.quitByConcurrent;
    }
}

