/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.lastaflute.di.helper.misc.LdiExceptionMessageBuilder;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiSrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastaDiProperties {
    public static final String LASTA_DI_PROPERTIES = "lasta_di.properties";
    public static final String SMART_DEPLOY_MODE_LOCATION_KEY = "smart.deploy.mode.location";
    public static final String SMART_PACKAGE1_KEY = "smart.package1";
    public static final String SMART_PACKAGE2_KEY = "smart.package2";
    public static final String SMART_PACKAGE3_KEY = "smart.package3";
    public static final String PLAIN_PROPERTY_INJECTION_PACKAGE1_KEY = "plain.property.injection.package1";
    public static final String DIXML_SCRIPT_EXPRESSION_ENGINE_KEY = "dixml.script.expression.engine";
    public static final String INTERNAL_DEBUG_KEY = "internal.debug";
    public static final String SUPPRESS_LASTA_ENV_KEY = "suppress.lasta.env";
    public static final String LASTA_ENV = "lasta.env";
    private static final Logger logger = LoggerFactory.getLogger(LastaDiProperties.class);
    private static LastaDiProperties instance;
    protected final Properties props;
    protected final boolean internalDebug;
    protected final boolean suppressLastaEnv;
    protected String smartDeployMode;
    protected boolean smartDeployLocationDone;
    protected List<String> smartPackageList;
    protected Class<?> diXmlScriptExpressionEngineType;
    protected boolean diXmlScriptExpressionEngineTypeDone;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LastaDiProperties getInstance() {
        if (instance != null) return instance;
        Class<LastaDiProperties> clazz = LastaDiProperties.class;
        synchronized (LastaDiProperties.class) {
            if (instance != null) return instance;
            instance = new LastaDiProperties();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected LastaDiProperties() {
        String suppressLastaEnvProp;
        String propName = LASTA_DI_PROPERTIES;
        Properties read = this.loadProperties(LASTA_DI_PROPERTIES);
        if (read != null) {
            this.props = read;
        } else {
            logger.info("*Not found the {} in your classpath.", (Object)LASTA_DI_PROPERTIES);
            this.props = new Properties();
        }
        String debugProp = this.getProperty(INTERNAL_DEBUG_KEY);
        boolean bl = this.internalDebug = debugProp != null && debugProp.equalsIgnoreCase("true");
        if (this.internalDebug) {
            logger.info("Lasta Di as Internal Debug by {}", (Object)INTERNAL_DEBUG_KEY);
        }
        boolean bl2 = this.suppressLastaEnv = (suppressLastaEnvProp = this.getProperty(SUPPRESS_LASTA_ENV_KEY)) != null && suppressLastaEnvProp.equalsIgnoreCase("true");
        if (this.suppressLastaEnv) {
            logger.info("Lasta Di suppresses lasta.env by {}", (Object)SUPPRESS_LASTA_ENV_KEY);
        }
    }

    public String getProperty(String propertyKey) {
        return this.props.getProperty(propertyKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSmartDeployMode() {
        if (this.smartDeployMode != null || this.smartDeployLocationDone) {
            return this.smartDeployMode;
        }
        LastaDiProperties lastaDiProperties = this;
        synchronized (lastaDiProperties) {
            if (this.smartDeployMode != null || this.smartDeployLocationDone) {
                return this.smartDeployMode;
            }
            String locKey = SMART_DEPLOY_MODE_LOCATION_KEY;
            String location = this.getProperty(SMART_DEPLOY_MODE_LOCATION_KEY);
            if (location != null && !location.isEmpty()) {
                String realMode;
                String delimiter = ":";
                int delimiterIndex = location.indexOf(":");
                if (delimiterIndex < 0) {
                    String msg = "The location should have delimiter colon ':' in lasta_di.properties but: " + location;
                    throw new IllegalStateException(msg);
                }
                String propName = this.resolveLastaEnvPath(location.substring(0, delimiterIndex).trim());
                String modeKey = location.substring(delimiterIndex + ":".length()).trim();
                logger.info("...Loading specified properties and get by the key: {}, {}", (Object)propName, (Object)modeKey);
                Properties read = this.loadProperties(propName);
                if (read == null) {
                    this.throwSmartDeployPropertiesFileNotFoundException(location, propName, modeKey);
                }
                if ((realMode = read.getProperty(modeKey)) == null) {
                    this.throwSmartDeployPropertiesModeKeyNotFoundException(location, propName, modeKey);
                }
                this.smartDeployMode = realMode;
            } else {
                logger.info("*Not found the smart-deploy mode location: {} in {}", (Object)SMART_DEPLOY_MODE_LOCATION_KEY, (Object)LASTA_DI_PROPERTIES);
            }
            this.smartDeployLocationDone = true;
            return this.smartDeployMode;
        }
    }

    protected void throwSmartDeployPropertiesFileNotFoundException(String location, String propName, String modeKey) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Not found the properties for smart deploy.");
        br.addItem("Advice");
        br.addElement("Make sure your properties or location setting.");
        br.addElement("  (x): at your lasta_di.properties");
        br.addElement("    smart.deploy.mode.location = no_exist.properties: lasta_di.smart.deploy.mode");
        br.addElement("");
        br.addElement("  (o): at your lasta_di.properties, e.g. maihama project");
        br.addElement("    smart.deploy.mode.location = maihama_env.properties: lasta_di.smart.deploy.mode");
        br.addItem("Location");
        br.addElement(location);
        br.addItem("NotFound File");
        br.addElement(propName);
        br.addItem("Deploy Mode Key");
        br.addElement(modeKey);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    protected void throwSmartDeployPropertiesModeKeyNotFoundException(String location, String propName, String modeKey) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Not found the property in your smart deploy properties.");
        br.addItem("Advice");
        br.addElement("Make sure your property key setting.");
        br.addElement("  (x): at your lasta_di.properties, e.g. maihama project");
        br.addElement("    smart.deploy.mode.location = maihama_env.properties: no_exist.smart.deploy.mode");
        br.addElement("");
        br.addElement("  (o): at your lasta_di.properties, e.g. maihama project");
        br.addElement("    smart.deploy.mode.location = maihama_env.properties: lasta_di.smart.deploy.mode");
        br.addElement("");
        br.addElement("  (o): at your maihama_env.properties, e.g. maihama project");
        br.addElement("    lasta_di.smart.deploy.mode = hot");
        br.addItem("Location");
        br.addElement(location);
        br.addItem("Properties File");
        br.addElement(propName);
        br.addItem("NotFound Key");
        br.addElement(modeKey);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSmartPackageList() {
        if (this.smartPackageList != null) {
            return this.smartPackageList;
        }
        LastaDiProperties lastaDiProperties = this;
        synchronized (lastaDiProperties) {
            if (this.smartPackageList != null) {
                return this.smartPackageList;
            }
            ArrayList<String> pkgList = new ArrayList<String>(3);
            pkgList.add(this.getSmartPackage1());
            pkgList.add(this.getSmartPackage2());
            pkgList.add(this.getSmartPackage3());
            this.smartPackageList = pkgList.stream().filter(pkg -> pkg != null).collect(Collectors.toList());
            return Collections.unmodifiableList(this.smartPackageList);
        }
    }

    public String getSmartPackage1() {
        return this.getProperty(SMART_PACKAGE1_KEY);
    }

    public String getSmartPackage2() {
        return this.getProperty(SMART_PACKAGE2_KEY);
    }

    public String getSmartPackage3() {
        return this.getProperty(SMART_PACKAGE3_KEY);
    }

    public String getDiXmlScriptExpressionEngine() {
        return this.getProperty(DIXML_SCRIPT_EXPRESSION_ENGINE_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getDiXmlScriptExpressionEngineType() {
        if (this.diXmlScriptExpressionEngineType == null && !this.diXmlScriptExpressionEngineTypeDone) {
            LastaDiProperties lastaDiProperties = this;
            synchronized (lastaDiProperties) {
                if (this.diXmlScriptExpressionEngineType == null) {
                    String engineName = this.getDiXmlScriptExpressionEngine();
                    if (engineName != null) {
                        this.diXmlScriptExpressionEngineType = LdiClassUtil.forName(engineName);
                    }
                    this.diXmlScriptExpressionEngineTypeDone = true;
                }
            }
        }
        return this.diXmlScriptExpressionEngineType;
    }

    public String getPlainPropertyInjectionPackage1() {
        return this.getProperty(PLAIN_PROPERTY_INJECTION_PACKAGE1_KEY);
    }

    public boolean isInternalDebug() {
        return this.internalDebug;
    }

    public String resolveLastaEnvPath(String envPath) {
        if (envPath == null) {
            throw new IllegalArgumentException("The argument 'envPath' should not be null.");
        }
        String lastaEnv = this.getLastaEnv();
        if (lastaEnv != null && envPath.contains("_env.")) {
            String front = LdiSrl.substringLastFront(envPath, "_env.");
            String rear = LdiSrl.substringLastRear(envPath, "_env.");
            return front + "_env_" + lastaEnv + "." + rear;
        }
        return envPath;
    }

    public boolean isSuppressLastaEnv() {
        return this.suppressLastaEnv;
    }

    public String getLastaEnv() {
        if (this.isSuppressLastaEnv()) {
            return null;
        }
        return System.getProperty(LASTA_ENV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties(String fileName) {
        Properties props = new Properties();
        InputStream ins = LastaDiProperties.class.getClassLoader().getResourceAsStream(fileName);
        if (ins == null) {
            return null;
        }
        try {
            props.load(ins);
        }
        catch (IOException | RuntimeException e) {
            this.handleLoadingFailureException(fileName, e);
        }
        finally {
            try {
                ins.close();
            }
            catch (IOException ignored) {}
        }
        return props;
    }

    protected void handleLoadingFailureException(String fileName, Exception e) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Failed to load the properties.");
        br.addItem("Properties File");
        br.addElement(fileName);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg, e);
    }
}

