/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.external;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractExternalContextMap
extends AbstractMap<String, Object> {
    private Set<Map.Entry<String, Object>> entrySet;
    private Set<String> keySet;
    private Collection<Object> values;

    @Override
    public void clear() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> it = this.getAttributeNames();
        while (it.hasNext()) {
            list.add(it.next());
        }
        this.clearReally(list);
    }

    private void clearReally(List<String> keys) {
        Iterator<String> itr = keys.iterator();
        while (itr.hasNext()) {
            this.removeAttribute(itr.next());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getAttribute(key.toString()) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value != null) {
            Iterator<String> it = this.getAttributeNames();
            while (it.hasNext()) {
                if (!value.equals(this.getAttribute(it.next()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this);
        }
        return this.entrySet;
    }

    @Override
    public Object get(Object key) {
        return this.getAttribute(key.toString());
    }

    @Override
    public Object put(String key, Object value) {
        String keyStr = key.toString();
        Object o = this.getAttribute(keyStr);
        this.setAttribute(keyStr, value);
        return o;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean isEmpty() {
        return !this.getAttributeNames().hasNext();
    }

    @Override
    public Set<String> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet(this);
        }
        return this.keySet;
    }

    @Override
    public Object remove(Object key) {
        String keyStr = key.toString();
        Object o = this.getAttribute(keyStr);
        this.removeAttribute(keyStr);
        return o;
    }

    @Override
    public Collection<Object> values() {
        if (this.values == null) {
            this.values = new ValuesCollection(this);
        }
        return this.values;
    }

    protected abstract Object getAttribute(String var1);

    protected abstract void setAttribute(String var1, Object var2);

    protected abstract Iterator<String> getAttributeNames();

    protected abstract void removeAttribute(String var1);

    protected static class ImmutableEntry
    implements Map.Entry<String, Object> {
        private final String key;
        private final Object value;

        public ImmutableEntry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object arg0) {
            throw new UnsupportedOperationException("Immutable entry.");
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ImmutableEntry)) {
                return false;
            }
            ImmutableEntry entry = (ImmutableEntry)obj;
            String k = entry.getKey();
            Object v = entry.getValue();
            return (k == this.key || k != null && k.equals(this.key)) && (v == this.value || v != null && v.equals(this.value));
        }

        @Override
        public int hashCode() {
            return (this.key != null ? this.key.hashCode() : 0) ^ (this.value != null ? this.value.hashCode() : 0);
        }
    }

    class ValuesIterator
    extends AbstractExternalContextIterator<Object> {
        public ValuesIterator(AbstractExternalContextMap contextMap) {
            super(contextMap);
        }

        @Override
        protected Object doNext() {
            return this.getValueFromMap(this.getCurrentKey());
        }

        @Override
        protected void doRemove() {
            this.removeValueFromMap(this.getValueFromMap(this.getCurrentKey()));
        }
    }

    class KeyIterator
    extends AbstractExternalContextIterator<String> {
        public KeyIterator(AbstractExternalContextMap contextMap) {
            super(contextMap);
        }

        @Override
        protected String doNext() {
            return this.getCurrentKey();
        }

        @Override
        protected void doRemove() {
            this.removeKeyFromMap(this.getCurrentKey());
        }
    }

    class EntryIterator
    extends AbstractExternalContextIterator<Map.Entry<String, Object>> {
        public EntryIterator(AbstractExternalContextMap contextMap) {
            super(contextMap);
        }

        @Override
        protected Map.Entry<String, Object> doNext() {
            String key = this.getCurrentKey();
            return new ImmutableEntry(key, this.getValueFromMap(key));
        }

        @Override
        protected void doRemove() {
            this.removeKeyFromMap(this.getCurrentKey());
        }
    }

    abstract class AbstractExternalContextIterator<ELEMENT>
    implements Iterator<ELEMENT> {
        private final Iterator<String> iterator;
        private final AbstractExternalContextMap contextMap;
        private String currentKey;
        private boolean removeCalled = false;

        public AbstractExternalContextIterator(AbstractExternalContextMap contextMap) {
            this.iterator = contextMap.getAttributeNames();
            this.contextMap = contextMap;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ELEMENT next() {
            this.currentKey = this.iterator.next();
            try {
                ELEMENT ELEMENT = this.doNext();
                return ELEMENT;
            }
            finally {
                this.removeCalled = false;
            }
        }

        @Override
        public void remove() {
            if (this.currentKey == null || this.removeCalled) {
                throw new IllegalStateException();
            }
            this.doRemove();
            this.removeCalled = true;
        }

        protected String getCurrentKey() {
            return this.currentKey;
        }

        protected Object getValueFromMap(String key) {
            return this.contextMap.get(key);
        }

        protected void removeKeyFromMap(String key) {
            this.contextMap.remove(key);
        }

        protected void removeValueFromMap(Object value) {
            if (AbstractExternalContextMap.this.containsValue(value)) {
                for (Map.Entry<String, Object> entry : AbstractExternalContextMap.this.entrySet()) {
                    if (!value.equals(entry.getValue())) continue;
                    this.contextMap.remove(entry.getKey());
                }
            }
        }

        protected abstract ELEMENT doNext();

        protected abstract void doRemove();
    }

    class ValuesCollection
    extends AbstractCollection<Object> {
        private AbstractExternalContextMap contextMap;

        public ValuesCollection(AbstractExternalContextMap contextMap) {
            this.contextMap = contextMap;
        }

        @Override
        public int size() {
            int size = 0;
            Iterator<Object> itr = this.iterator();
            while (itr.hasNext()) {
                itr.next();
                ++size;
            }
            return size;
        }

        @Override
        public Iterator<Object> iterator() {
            return new ValuesIterator(this.contextMap);
        }
    }

    class KeySet
    extends AbstractExternalContextSet<String> {
        private AbstractExternalContextMap contextMap;

        public KeySet(AbstractExternalContextMap contextMap) {
            this.contextMap = contextMap;
        }

        @Override
        public Iterator<String> iterator() {
            return new KeyIterator(this.contextMap);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof String)) {
                return false;
            }
            String s = (String)o;
            return this.contextMap.remove(s) != null;
        }
    }

    class EntrySet
    extends AbstractExternalContextSet<Map.Entry<String, Object>> {
        private AbstractExternalContextMap contextMap;

        public EntrySet(AbstractExternalContextMap contextMap) {
            this.contextMap = contextMap;
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new EntryIterator(this.contextMap);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return this.contextMap.remove(entry.getKey()) != null;
        }
    }

    abstract class AbstractExternalContextSet<ELEMENT>
    extends AbstractSet<ELEMENT> {
        AbstractExternalContextSet() {
        }

        @Override
        public int size() {
            int size = 0;
            Iterator itr = this.iterator();
            while (itr.hasNext()) {
                itr.next();
                ++size;
            }
            return size;
        }
    }
}

