/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.factory.conbuilder.impl;

import java.io.InputStream;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.factory.conbuilder.LaContainerBuilder;
import org.lastaflute.di.core.factory.resresolver.ResourceResolver;
import org.lastaflute.di.core.factory.resresolver.impl.ClassPathResourceResolver;
import org.lastaflute.di.exception.DiXmlNotFoundException;
import org.lastaflute.di.helper.misc.LdiExceptionMessageBuilder;

public abstract class AbstractLaContainerBuilder
implements LaContainerBuilder {
    public static final String resourceResolver_BINDING = "bindingType=may";
    protected ResourceResolver resourceResolver = new ClassPathResourceResolver();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LaContainer build(String path, ClassLoader classLoader) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            LaContainer laContainer = this.build(path);
            return laContainer;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    protected InputStream findDiXmlInputStream(LaContainer parent, String path) {
        InputStream is = this.resourceResolver.getInputStream(path);
        if (is == null) {
            this.throwDiXmlNotFoundException(parent, path);
        }
        return is;
    }

    protected void throwDiXmlNotFoundException(LaContainer parent, String path) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Not found the Di xml by the path.");
        br.addItem("Specified Path");
        br.addElement(path);
        if (parent != null) {
            br.addItem("Included By");
            br.addElement(parent.getPath());
        }
        String msg = br.buildExceptionMessage();
        throw new DiXmlNotFoundException(msg);
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(ResourceResolver resolver) {
        this.resourceResolver = resolver;
    }
}

