/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.j2ee;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.exception.ComponentNotFoundException;
import org.lastaflute.di.core.factory.SingletonLaContainerFactory;
import org.lastaflute.di.core.j2ee.JndiResourceLocator;
import org.lastaflute.di.exception.SRuntimeException;
import org.lastaflute.di.util.LdiStringUtil;

public class JndiContext
implements Context {
    protected final Hashtable<String, Object> env;
    protected final String path;

    public JndiContext(Hashtable<String, Object> env) {
        this.env = env;
        this.path = (String)env.get("java.naming.provider.url");
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.env.put(propName, propVal);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException("name is empty");
        }
        this.bind(JndiResourceLocator.resolveName(name), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(JndiResourceLocator.resolveName(name).split("\\."), obj);
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException("composeName");
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new OperationNotSupportedException("composeName");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("createSubcontext");
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("createSubcontext");
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("destroySubcontext");
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("destroySubcontext");
    }

    public Hashtable<String, Object> getEnvironment() throws NamingException {
        return this.env;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("getNameInNamespace");
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        throw new OperationNotSupportedException("getNameParser");
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        throw new OperationNotSupportedException("getNameParser");
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw new OperationNotSupportedException("list");
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        throw new OperationNotSupportedException("list");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        throw new OperationNotSupportedException("listBindings");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        throw new OperationNotSupportedException("listBindings");
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new JndiContext(new Hashtable<String, Object>(this.env));
        }
        return this.lookup(name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (LdiStringUtil.isEmpty(name)) {
            return new JndiContext(new Hashtable<String, Object>(this.env));
        }
        return SingletonLaContainerFactory.getContainer().getComponent(JndiResourceLocator.resolveName(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException("lookupLink");
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException("lookupLink");
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("rebind");
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("rebind");
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException("rename");
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException("rename");
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException("unbind");
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException("unbind");
    }

    protected void bind(String[] names, Object obj) throws NamingException {
        StringBuffer buf = new StringBuffer(100);
        try {
            LaContainer context = SingletonLaContainerFactory.getContainer();
            for (int i = 0; i < names.length - 1; ++i) {
                buf.append(names[i]);
                context = (LaContainer)context.getComponent(names[i]);
                buf.append('/');
            }
            String name = names[names.length - 1];
            buf.append(name);
            if (context.hasComponentDef(name)) {
                throw new NameAlreadyBoundException(new String(buf));
            }
            context.register(obj, name);
        }
        catch (ComponentNotFoundException e) {
            throw this.createNamingException(new String(buf), e);
        }
        catch (SRuntimeException e) {
            throw this.createNamingException(e.getMessage(), e);
        }
    }

    protected NamingException createNamingException(String message, Throwable cause) {
        NamingException e = new NamingException(message);
        e.initCause(cause);
        return e;
    }
}

