/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.meta.impl;

import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.ContainerConstants;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.assembler.AutoBindingDefFactory;
import org.lastaflute.di.core.deployer.ComponentDeployer;
import org.lastaflute.di.core.expression.Expression;
import org.lastaflute.di.core.meta.ArgDef;
import org.lastaflute.di.core.meta.AspectDef;
import org.lastaflute.di.core.meta.AutoBindingDef;
import org.lastaflute.di.core.meta.DestroyMethodDef;
import org.lastaflute.di.core.meta.InitMethodDef;
import org.lastaflute.di.core.meta.InstanceDef;
import org.lastaflute.di.core.meta.InterTypeDef;
import org.lastaflute.di.core.meta.MetaDef;
import org.lastaflute.di.core.meta.PropertyDef;
import org.lastaflute.di.core.meta.impl.InstanceDefFactory;
import org.lastaflute.di.core.util.AopProxyUtil;
import org.lastaflute.di.core.util.ArgDefSupport;
import org.lastaflute.di.core.util.AspectDefSupport;
import org.lastaflute.di.core.util.DestroyMethodDefSupport;
import org.lastaflute.di.core.util.InitMethodDefSupport;
import org.lastaflute.di.core.util.InterTypeDefSupport;
import org.lastaflute.di.core.util.MetaDefSupport;
import org.lastaflute.di.core.util.PropertyDefSupport;
import org.lastaflute.di.helper.beans.exception.BeanPropertyNotFoundException;

public class ComponentDefImpl
implements ComponentDef,
ContainerConstants {
    private Class<?> componentClass;
    private String componentName;
    private Class<?> concreteClass;
    private LaContainer container;
    private Expression expression;
    private ArgDefSupport argDefSupport = new ArgDefSupport();
    private PropertyDefSupport propertyDefSupport = new PropertyDefSupport();
    private InitMethodDefSupport initMethodDefSupport = new InitMethodDefSupport();
    private DestroyMethodDefSupport destroyMethodDefSupport = new DestroyMethodDefSupport();
    private AspectDefSupport aspectDefSupport = new AspectDefSupport();
    private InterTypeDefSupport interTypeDefSupport = new InterTypeDefSupport();
    private MetaDefSupport metaDefSupport = new MetaDefSupport();
    private InstanceDef instanceDef = InstanceDefFactory.SINGLETON;
    private AutoBindingDef autoBindingDef = AutoBindingDefFactory.AUTO;
    private ComponentDeployer componentDeployer;
    private boolean externalBinding = false;

    public ComponentDefImpl(Class<?> componentClass) {
        this(componentClass, null);
    }

    public ComponentDefImpl(Class<?> componentClass, String componentName) {
        this.componentClass = componentClass;
        this.setComponentName(componentName);
    }

    @Override
    public void init() {
        this.getConcreteClass();
        this.getComponentDeployer().init();
    }

    @Override
    public Object getComponent() {
        return this.getComponentDeployer().deploy();
    }

    @Override
    public void injectDependency(Object outerComponent) {
        this.getComponentDeployer().injectDependency(outerComponent);
    }

    @Override
    public void destroy() {
        this.getComponentDeployer().destroy();
        this.componentClass = null;
        this.componentName = null;
        this.concreteClass = null;
        this.container = null;
        this.expression = null;
        this.argDefSupport = null;
        this.propertyDefSupport = null;
        this.initMethodDefSupport = null;
        this.destroyMethodDefSupport = null;
        this.aspectDefSupport = null;
        this.interTypeDefSupport = null;
        this.metaDefSupport = null;
        this.instanceDef = null;
        this.autoBindingDef = null;
        this.componentDeployer = null;
    }

    @Override
    public void addArgDef(ArgDef argDef) {
        this.argDefSupport.addArgDef(argDef);
    }

    @Override
    public void addPropertyDef(PropertyDef propertyDef) {
        this.propertyDefSupport.addPropertyDef(propertyDef);
    }

    @Override
    public void addInitMethodDef(InitMethodDef methodDef) {
        this.initMethodDefSupport.addInitMethodDef(methodDef);
    }

    @Override
    public void addDestroyMethodDef(DestroyMethodDef methodDef) {
        this.destroyMethodDefSupport.addDestroyMethodDef(methodDef);
    }

    @Override
    public void addAspectDef(AspectDef aspectDef) {
        this.aspectDefSupport.addAspectDef(aspectDef);
        this.concreteClass = null;
    }

    @Override
    public void addAspectDef(int index, AspectDef aspectDef) {
        this.aspectDefSupport.addAspectDef(index, aspectDef);
        this.concreteClass = null;
    }

    @Override
    public void addInterTypeDef(InterTypeDef interTypeDef) {
        this.interTypeDefSupport.addInterTypeDef(interTypeDef);
        this.concreteClass = null;
    }

    @Override
    public int getArgDefSize() {
        return this.argDefSupport.getArgDefSize();
    }

    @Override
    public int getPropertyDefSize() {
        return this.propertyDefSupport.getPropertyDefSize();
    }

    @Override
    public int getInitMethodDefSize() {
        return this.initMethodDefSupport.getInitMethodDefSize();
    }

    @Override
    public int getDestroyMethodDefSize() {
        return this.destroyMethodDefSupport.getDestroyMethodDefSize();
    }

    @Override
    public int getAspectDefSize() {
        return this.aspectDefSupport.getAspectDefSize();
    }

    @Override
    public int getInterTypeDefSize() {
        return this.interTypeDefSupport.getInterTypeDefSize();
    }

    @Override
    public ArgDef getArgDef(int index) {
        return this.argDefSupport.getArgDef(index);
    }

    @Override
    public PropertyDef getPropertyDef(int index) {
        return this.propertyDefSupport.getPropertyDef(index);
    }

    @Override
    public PropertyDef getPropertyDef(String propertyName) {
        if (this.hasPropertyDef(propertyName)) {
            return this.propertyDefSupport.getPropertyDef(propertyName);
        }
        throw new BeanPropertyNotFoundException(this.componentClass, propertyName);
    }

    @Override
    public boolean hasPropertyDef(String propertyName) {
        return this.propertyDefSupport.hasPropertyDef(propertyName);
    }

    @Override
    public InitMethodDef getInitMethodDef(int index) {
        return this.initMethodDefSupport.getInitMethodDef(index);
    }

    @Override
    public DestroyMethodDef getDestroyMethodDef(int index) {
        return this.destroyMethodDefSupport.getDestroyMethodDef(index);
    }

    @Override
    public AspectDef getAspectDef(int index) {
        return this.aspectDefSupport.getAspectDef(index);
    }

    @Override
    public InterTypeDef getInterTypeDef(int index) {
        return this.interTypeDefSupport.getInterTypeDef(index);
    }

    @Override
    public void addMetaDef(MetaDef metaDef) {
        this.metaDefSupport.addMetaDef(metaDef);
    }

    @Override
    public MetaDef getMetaDef(int index) {
        return this.metaDefSupport.getMetaDef(index);
    }

    @Override
    public MetaDef getMetaDef(String name) {
        return this.metaDefSupport.getMetaDef(name);
    }

    @Override
    public MetaDef[] getMetaDefs(String name) {
        return this.metaDefSupport.getMetaDefs(name);
    }

    @Override
    public int getMetaDefSize() {
        return this.metaDefSupport.getMetaDefSize();
    }

    public ComponentDeployer getComponentDeployer() {
        if (this.componentDeployer == null) {
            this.componentDeployer = this.instanceDef.createComponentDeployer(this);
        }
        return this.componentDeployer;
    }

    public String toString() {
        String typeExp = this.componentClass != null ? this.componentClass.getSimpleName() : null;
        String hash = Integer.toHexString(this.hashCode());
        return this.getClass().getSimpleName() + ":{" + this.componentName + ", " + typeExp + "}@" + hash;
    }

    @Override
    public Class<?> getComponentClass() {
        return this.componentClass;
    }

    @Override
    public void setComponentClass(Class<?> componentClass) {
        this.componentClass = componentClass;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    @Override
    public Class<?> getConcreteClass() {
        if (this.concreteClass == null) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader loader;
                ClassLoader classLoader = loader = this.container != null ? this.container.getClassLoader() : null;
                if (loader != null) {
                    Thread.currentThread().setContextClassLoader(loader);
                }
                this.concreteClass = AopProxyUtil.getConcreteClass(this);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
        return this.concreteClass;
    }

    @Override
    public LaContainer getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(LaContainer container) {
        this.container = container;
        this.argDefSupport.setContainer(container);
        this.metaDefSupport.setContainer(container);
        this.propertyDefSupport.setContainer(container);
        this.initMethodDefSupport.setContainer(container);
        this.destroyMethodDefSupport.setContainer(container);
        this.aspectDefSupport.setContainer(container);
        this.interTypeDefSupport.setContainer(container);
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public InstanceDef getInstanceDef() {
        return this.instanceDef;
    }

    @Override
    public void setInstanceDef(InstanceDef instanceDef) {
        this.instanceDef = instanceDef;
    }

    @Override
    public AutoBindingDef getAutoBindingDef() {
        return this.autoBindingDef;
    }

    @Override
    public void setAutoBindingDef(AutoBindingDef autoBindingDef) {
        this.autoBindingDef = autoBindingDef;
    }

    @Override
    public boolean isExternalBinding() {
        return this.externalBinding;
    }

    @Override
    public void setExternalBinding(boolean externalBinding) {
        this.externalBinding = externalBinding;
    }
}

