/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.helper.beans.factory;

import java.util.Map;
import org.lastaflute.di.Disposable;
import org.lastaflute.di.DisposableUtil;
import org.lastaflute.di.helper.beans.BeanDesc;
import org.lastaflute.di.helper.beans.impl.BeanDescImpl;
import org.lastaflute.di.util.LdiMapUtil;

public class BeanDescFactory {
    private static volatile boolean initialized;
    private static Map<Class<?>, BeanDesc> beanDescCache;

    protected BeanDescFactory() {
    }

    public static BeanDesc getBeanDesc(Class<?> clazz) {
        BeanDesc beanDesc;
        if (!initialized) {
            BeanDescFactory.initialize();
        }
        if ((beanDesc = beanDescCache.get(clazz)) == null) {
            beanDesc = new BeanDescImpl(clazz);
            beanDescCache.put(clazz, beanDesc);
        }
        return beanDesc;
    }

    public static void initialize() {
        DisposableUtil.add(new Disposable(){

            @Override
            public void dispose() {
                BeanDescFactory.clear();
            }
        });
        initialized = true;
    }

    public static void clear() {
        beanDescCache.clear();
        initialized = false;
    }

    static {
        beanDescCache = LdiMapUtil.createHashMap(1024);
        BeanDescFactory.initialize();
    }
}

