/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.redefiner.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.assembler.DefaultDestroyMethodAssembler;
import org.lastaflute.di.core.exception.IllegalMethodRuntimeException;
import org.lastaflute.di.core.meta.DestroyMethodDef;
import org.lastaflute.di.core.meta.MethodDef;
import org.lastaflute.di.helper.beans.BeanDesc;
import org.lastaflute.di.redefiner.LaContainerPreparer;

public class ClassDestroyMethodAssembler
extends DefaultDestroyMethodAssembler {
    public ClassDestroyMethodAssembler(ComponentDef componentDef) {
        super(componentDef);
    }

    @Override
    public void assemble(Object component) throws IllegalMethodRuntimeException {
        if (component == null) {
            return;
        }
        BeanDesc beanDesc = this.getBeanDesc(component);
        int size = this.getComponentDef().getDestroyMethodDefSize();
        for (int i = 0; i < size; ++i) {
            DestroyMethodDef methodDef = this.getComponentDef().getDestroyMethodDef(i);
            Method method = methodDef.getMethod();
            if (method != null && LaContainerPreparer.class.isAssignableFrom(method.getDeclaringClass())) {
                this.invokePreparerMethod(component, methodDef);
                continue;
            }
            this.invoke(beanDesc, component, methodDef);
        }
    }

    protected void invokePreparerMethod(Object component, MethodDef methodDef) {
        try {
            methodDef.getMethod().invoke(methodDef.getArgs()[0], component);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalMethodRuntimeException(this.getComponentClass(component), this.getComponentDef().getComponentName(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalMethodRuntimeException(this.getComponentClass(component), this.getComponentDef().getComponentName(), (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalMethodRuntimeException(this.getComponentClass(component), this.getComponentDef().getComponentName(), (Throwable)ex);
        }
    }
}

