/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.redefiner.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.factory.conbuilder.impl.AbstractLaContainerBuilder;
import org.lastaflute.di.core.meta.MetaDef;
import org.lastaflute.di.exception.IORuntimeException;
import org.lastaflute.di.util.LdiResourceUtil;

public class LaContainerBuilderUtils {
    protected static final String PREFIX_JAR = "jar:";
    protected static final String SUFFIX_JAR = "!/";
    protected static final String PREFIX_FILE = "file:";
    protected static final String PREFIX_ZIP = "zip:";
    public static final String SUFFIX_ZIP = "!/";
    public static final String PREFIX_CODE_SOURCE = "code-source:";
    public static final String SUFFIX_CODE_SOURCE = "!/";
    protected static final char COLON = ':';

    protected LaContainerBuilderUtils() {
    }

    public static boolean resourceExists(String path, AbstractLaContainerBuilder builder) {
        InputStream is;
        try {
            is = builder.getResourceResolver().getInputStream(path);
        }
        catch (IORuntimeException ex) {
            if (ex.getCause() instanceof FileNotFoundException) {
                return false;
            }
            throw ex;
        }
        if (is == null) {
            return false;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public static void mergeContainer(LaContainer container, LaContainer merged) {
        int i;
        int size = merged.getChildSize();
        for (i = 0; i < size; ++i) {
            container.include(merged.getChild(i));
        }
        size = merged.getMetaDefSize();
        for (i = 0; i < size; ++i) {
            MetaDef metaDef = merged.getMetaDef(i);
            metaDef.setContainer(container);
            container.addMetaDef(metaDef);
        }
        size = merged.getComponentDefSize();
        for (i = 0; i < size; ++i) {
            ComponentDef componentDef = merged.getComponentDef(i);
            componentDef.setContainer(container);
            container.register(componentDef);
        }
    }

    public static String fromURLToResourcePath(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith(PREFIX_JAR)) {
            int idx = path.indexOf("!/");
            if (idx >= 0) {
                return path.substring(idx + "!/".length());
            }
            return null;
        }
        if (path.startsWith(PREFIX_FILE)) {
            String resourcePath;
            int idx;
            String filePath;
            try {
                filePath = LdiResourceUtil.getFileName(new URL(LaContainerBuilderUtils.encodeURL(path)));
            }
            catch (MalformedURLException ex) {
                return null;
            }
            ClassLoader cl = LaContainerBuilderUtils.getClassLoader();
            int pre = 0;
            while ((idx = filePath.indexOf(47, pre)) >= 0) {
                pre = idx + 1;
                resourcePath = filePath.substring(pre);
                try {
                    if (cl.getResource(resourcePath) == null) continue;
                    return resourcePath;
                }
                catch (RuntimeException ignored) {
                }
            }
            if (pre < filePath.length() && cl.getResource(resourcePath = filePath.substring(pre)) != null) {
                return resourcePath;
            }
        } else {
            if (path.startsWith(PREFIX_ZIP)) {
                int idx = path.indexOf("!/");
                if (idx >= 0) {
                    return path.substring(idx + "!/".length());
                }
                return null;
            }
            if (path.startsWith(PREFIX_CODE_SOURCE)) {
                int idx = path.indexOf("!/");
                if (idx >= 0) {
                    return path.substring(idx + "!/".length());
                }
                return null;
            }
        }
        return null;
    }

    public static URL[] getResourceURLs(String path) {
        return LaContainerBuilderUtils.getResourceURLs(path, Thread.currentThread().getContextClassLoader());
    }

    public static URL[] getResourceURLs(String path, ClassLoader classLoader) {
        Enumeration<URL> enm;
        if (path.indexOf(58) >= 0) {
            try {
                return new URL[]{new URL(path)};
            }
            catch (MalformedURLException ignored) {
                // empty catch block
            }
        }
        try {
            enm = classLoader.getResources(path);
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
        LinkedHashSet<URL> urlSet = new LinkedHashSet<URL>();
        while (enm.hasMoreElements()) {
            urlSet.add(enm.nextElement());
        }
        return urlSet.toArray(new URL[0]);
    }

    protected static String encodeURL(String path) {
        if (path == null) {
            return null;
        }
        return path.replace("+", "%2B");
    }

    protected static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = LaContainerBuilderUtils.class.getClassLoader();
        }
        return cl;
    }
}

