/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.lastaflute.di.util.LdiDecimalFormatUtil;
import org.lastaflute.di.util.LdiStringUtil;

public class LdiDoubleConversionUtil {
    protected LdiDoubleConversionUtil() {
    }

    public static Double toDouble(Object o) {
        return LdiDoubleConversionUtil.toDouble(o, null);
    }

    public static Double toDouble(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Number) {
            return new Double(((Number)o).doubleValue());
        }
        if (o instanceof String) {
            return LdiDoubleConversionUtil.toDouble((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Double(new SimpleDateFormat(pattern).format(o));
            }
            return new Double(((Date)o).getTime());
        }
        return LdiDoubleConversionUtil.toDouble(o.toString());
    }

    private static Double toDouble(String s) {
        if (LdiStringUtil.isEmpty(s)) {
            return null;
        }
        return new Double(LdiDecimalFormatUtil.normalize(s));
    }

    public static double toPrimitiveDouble(Object o) {
        return LdiDoubleConversionUtil.toPrimitiveDouble(o, null);
    }

    public static double toPrimitiveDouble(Object o, String pattern) {
        if (o == null) {
            return 0.0;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            return LdiDoubleConversionUtil.toPrimitiveDouble((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Double.parseDouble(new SimpleDateFormat(pattern).format(o));
            }
            return ((Date)o).getTime();
        }
        return LdiDoubleConversionUtil.toPrimitiveDouble(o.toString());
    }

    private static double toPrimitiveDouble(String s) {
        if (LdiStringUtil.isEmpty(s)) {
            return 0.0;
        }
        return Double.parseDouble(LdiDecimalFormatUtil.normalize(s));
    }
}

