/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import org.lastaflute.di.exception.SQLRuntimeException;
import org.lastaflute.di.util.LdiClassUtil;

public abstract class LdiDriverManagerUtil {
    public static void registerDriver(String driverClassName) {
        LdiDriverManagerUtil.registerDriver(LdiClassUtil.forName(driverClassName));
    }

    public static void registerDriver(Class<?> driverClass) {
        LdiDriverManagerUtil.registerDriver((Driver)LdiClassUtil.newInstance(driverClass));
    }

    public static void registerDriver(Driver driver) {
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    public static void deregisterDriver(Driver driver) {
        try {
            DriverManager.deregisterDriver(driver);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    public static synchronized void deregisterAllDrivers() {
        Enumeration<Driver> e = DriverManager.getDrivers();
        while (e.hasMoreElements()) {
            LdiDriverManagerUtil.deregisterDriver(e.nextElement());
        }
    }
}

