/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.lastaflute.di.util.LdiDecimalFormatUtil;
import org.lastaflute.di.util.LdiStringUtil;

public class LdiFloatConversionUtil {
    protected LdiFloatConversionUtil() {
    }

    public static Float toFloat(Object o) {
        return LdiFloatConversionUtil.toFloat(o, null);
    }

    public static Float toFloat(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Float) {
            return (Float)o;
        }
        if (o instanceof Number) {
            return new Float(((Number)o).floatValue());
        }
        if (o instanceof String) {
            return LdiFloatConversionUtil.toFloat((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Float(new SimpleDateFormat(pattern).format(o));
            }
            return new Float(((Date)o).getTime());
        }
        return LdiFloatConversionUtil.toFloat(o.toString());
    }

    private static Float toFloat(String s) {
        if (LdiStringUtil.isEmpty(s)) {
            return null;
        }
        return new Float(LdiDecimalFormatUtil.normalize(s));
    }

    public static float toPrimitiveFloat(Object o) {
        return LdiFloatConversionUtil.toPrimitiveFloat(o, null);
    }

    public static float toPrimitiveFloat(Object o, String pattern) {
        if (o == null) {
            return 0.0f;
        }
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        if (o instanceof String) {
            return LdiFloatConversionUtil.toPrimitiveFloat((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Float.parseFloat(new SimpleDateFormat(pattern).format(o));
            }
            return ((Date)o).getTime();
        }
        return LdiFloatConversionUtil.toPrimitiveFloat(o.toString());
    }

    private static float toPrimitiveFloat(String s) {
        if (LdiStringUtil.isEmpty(s)) {
            return 0.0f;
        }
        return Float.parseFloat(LdiDecimalFormatUtil.normalize(s));
    }
}

